/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.List;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.intellij.markdown.MarkdownParsingException;
import org.intellij.markdown.lexer.Compat;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.HtmlBlockMarkerBlock;
import org.intellij.markdown.parser.markerblocks.providers.HtmlBlockProvider;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nHtmlBlockProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HtmlBlockProvider.kt\norg/intellij/markdown/parser/markerblocks/providers/HtmlBlockProvider\n+ 2 Compat.kt\norg/intellij/markdown/lexer/Compat\n*L\n1#1,91:1\n107#2,4:92\n107#2,4:96\n*S KotlinDebug\n*F\n+ 1 HtmlBlockProvider.kt\norg/intellij/markdown/parser/markerblocks/providers/HtmlBlockProvider\n*L\n38#1:92,4\n44#1:96,4\n*E\n"})
public final class HtmlBlockProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG_NAMES = "address, article, aside, base, basefont, blockquote, body, caption, center, col, colgroup, dd, details, dialog, dir, div, dl, dt, fieldset, figcaption, figure, footer, form, frame, frameset, h1, head, header, hr, html, legend, li, link, main, menu, menuitem, meta, nav, noframes, ol, optgroup, option, p, param, pre, section, source, title, summary, table, tbody, td, tfoot, th, thead, title, tr, track, ul";
    @NotNull
    private static final String TAG_NAME = "[a-zA-Z][a-zA-Z0-9-]*";
    @NotNull
    private static final String ATTR_NAME = "[A-Za-z:_][A-Za-z0-9_.:-]*";
    @NotNull
    private static final String ATTR_VALUE = "\\s*=\\s*(?:[^ \"'=<>`]+|'[^']*'|\"[^\"]*\")";
    @NotNull
    private static final String ATTRIBUTE = "\\s+" + ATTR_NAME + "(?:" + ATTR_VALUE + ")?";
    @NotNull
    private static final String OPEN_TAG = '<' + TAG_NAME + "(?:" + ATTRIBUTE + ")*\\s*/?>";
    @NotNull
    private static final String CLOSE_TAG = "</" + TAG_NAME + "\\s*>";
    @NotNull
    private static final List<Pair<Regex, Regex>> OPEN_CLOSE_REGEXES;
    @NotNull
    private static final Regex FIND_START_REGEX;

    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkNotNullParameter((Object)stateInfo, (String)"stateInfo");
        int matchingGroup = this.matches(pos, stateInfo.getCurrentConstraints());
        if (matchingGroup != -1) {
            return CollectionsKt.listOf((Object)new HtmlBlockMarkerBlock(stateInfo.getCurrentConstraints(), productionHolder, (Regex)OPEN_CLOSE_REGEXES.get(matchingGroup).getSecond(), pos));
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        int n = this.matches(pos, constraints);
        return 0 <= n ? n < 6 : false;
    }

    private final int matches(LookaheadText.Position pos, MarkdownConstraints constraints) {
        if (!MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, constraints)) {
            return -1;
        }
        CharSequence text2 = pos.getCurrentLineFromPosition();
        int offset = MarkerBlockProvider.Companion.passSmallIndent$default(MarkerBlockProvider.Companion, text2, 0, 2, null);
        if (offset >= text2.length() || text2.charAt(offset) != '<') {
            return -1;
        }
        CharSequence charSequence = text2;
        int n = charSequence.length();
        MatchResult matchResult = Regex.find$default((Regex)FIND_START_REGEX, (CharSequence)((Object)charSequence.subSequence(offset, n)).toString(), (int)0, (int)2, null);
        if (matchResult == null) {
            return -1;
        }
        MatchResult matchResult2 = matchResult;
        Compat compat = Compat.INSTANCE;
        int condition$iv = matchResult2.getGroups().size() == OPEN_CLOSE_REGEXES.size() + 2 ? 1 : 0;
        boolean $i$f$assert = false;
        if (condition$iv == 0) {
            boolean bl = false;
            String string = "There are some excess capturing groups probably!";
            throw new MarkdownParsingException(string);
        }
        condition$iv = OPEN_CLOSE_REGEXES.size();
        for (int i2 = 0; i2 < condition$iv; ++i2) {
            if (matchResult2.getGroups().get(i2 + 2) == null) continue;
            return i2;
        }
        Compat i2 = Compat.INSTANCE;
        condition$iv = 0;
        $i$f$assert = false;
        boolean bl = false;
        String string = "Match found but all groups are empty!";
        throw new MarkdownParsingException(string);
    }

    static {
        Object[] objectArray = new Pair[]{new Pair((Object)new Regex("<(?:script|pre|style)(?: |>|$)", RegexOption.IGNORE_CASE), (Object)new Regex("</(?:script|style|pre)>", RegexOption.IGNORE_CASE)), new Pair((Object)new Regex("<!--"), (Object)new Regex("-->")), new Pair((Object)new Regex("<\\?"), (Object)new Regex("\\?>")), new Pair((Object)new Regex("<![A-Z]"), (Object)new Regex(">")), new Pair((Object)new Regex("<!\\[CDATA\\["), (Object)new Regex("\\]\\]>")), new Pair((Object)new Regex("</?(?:" + StringsKt.replace$default((String)TAG_NAMES, (String)", ", (String)"|", (boolean)false, (int)4, null) + ")(?: |/?>|$)", RegexOption.IGNORE_CASE), null), new Pair((Object)new Regex("(?:" + OPEN_TAG + '|' + CLOSE_TAG + ")(?: |$)"), null)};
        OPEN_CLOSE_REGEXES = CollectionsKt.listOf((Object[])objectArray);
        FIND_START_REGEX = new Regex("^(" + CollectionsKt.joinToString$default((Iterable)OPEN_CLOSE_REGEXES, (CharSequence)"|", null, null, (int)0, null, (Function1)Companion.FIND_START_REGEX.1.INSTANCE, (int)30, null) + ')');
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

