/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.CodeFenceMarkerBlock;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeFenceProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex REGEX = new Regex("^ {0,3}(~~~+|```+)([^`]*)$");

    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkNotNullParameter((Object)stateInfo, (String)"stateInfo");
        OpeningInfo openingInfo = this.obtainFenceOpeningInfo(pos, stateInfo.getCurrentConstraints());
        if (openingInfo == null) {
            return CollectionsKt.emptyList();
        }
        OpeningInfo openingInfo2 = openingInfo;
        this.createNodesForFenceStart(pos, openingInfo2, productionHolder);
        return CollectionsKt.listOf((Object)new CodeFenceMarkerBlock(stateInfo.getCurrentConstraints(), productionHolder, openingInfo2.getDelimiter()));
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        return this.obtainFenceOpeningInfo(pos, constraints) != null;
    }

    private final void createNodesForFenceStart(LookaheadText.Position pos, OpeningInfo openingInfo, ProductionHolder productionHolder) {
        String info = openingInfo.component2();
        int infoStartPosition = pos.getNextLineOrEofOffset() - info.length();
        productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node(new IntRange(pos.getOffset(), infoStartPosition), MarkdownTokenTypes.CODE_FENCE_START)));
        if (((CharSequence)openingInfo.getInfo()).length() > 0) {
            productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node(new IntRange(infoStartPosition, pos.getNextLineOrEofOffset()), MarkdownTokenTypes.FENCE_LANG)));
        }
    }

    @Nullable
    protected OpeningInfo obtainFenceOpeningInfo(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        if (!MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, constraints)) {
            return null;
        }
        MatchResult matchResult = Regex.find$default((Regex)REGEX, (CharSequence)pos.getCurrentLineFromPosition(), (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult matchResult2 = matchResult;
        MatchGroup matchGroup = matchResult2.getGroups().get(1);
        String string = matchGroup != null ? matchGroup.getValue() : null;
        Intrinsics.checkNotNull((Object)string);
        MatchGroup matchGroup2 = matchResult2.getGroups().get(2);
        String string2 = matchGroup2 != null ? matchGroup2.getValue() : null;
        Intrinsics.checkNotNull((Object)string2);
        return new OpeningInfo(string, string2);
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    protected static final class OpeningInfo {
        @NotNull
        private final String delimiter;
        @NotNull
        private final String info;

        public OpeningInfo(@NotNull String delimiter, @NotNull String info) {
            Intrinsics.checkNotNullParameter((Object)delimiter, (String)"delimiter");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            this.delimiter = delimiter;
            this.info = info;
        }

        @NotNull
        public final String getDelimiter() {
            return this.delimiter;
        }

        @NotNull
        public final String getInfo() {
            return this.info;
        }

        @NotNull
        public final String component2() {
            return this.info;
        }

        @NotNull
        public String toString() {
            return "OpeningInfo(delimiter=" + this.delimiter + ", info=" + this.info + ')';
        }

        public int hashCode() {
            int result2 = this.delimiter.hashCode();
            result2 = result2 * 31 + this.info.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OpeningInfo)) {
                return false;
            }
            OpeningInfo openingInfo = (OpeningInfo)other;
            if (!Intrinsics.areEqual((Object)this.delimiter, (Object)openingInfo.delimiter)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.info, (Object)openingInfo.info);
        }
    }
}

