/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.impl;

import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownParsingException;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.lexer.Compat;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.constraints.MarkdownConstraintsKt;
import org.intellij.markdown.parser.markerblocks.MarkdownParserUtil;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockImpl;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nCodeBlockMarkerBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeBlockMarkerBlock.kt\norg/intellij/markdown/parser/markerblocks/impl/CodeBlockMarkerBlock\n+ 2 Compat.kt\norg/intellij/markdown/lexer/Compat\n+ 3 Compat.kt\norg/intellij/markdown/lexer/Compat$assert$1\n*L\n1#1,81:1\n106#2,3:82\n110#2:86\n106#3:85\n*S KotlinDebug\n*F\n+ 1 CodeBlockMarkerBlock.kt\norg/intellij/markdown/parser/markerblocks/impl/CodeBlockMarkerBlock\n*L\n51#1:82,3\n51#1:86\n51#1:85\n*E\n"})
public final class CodeBlockMarkerBlock
extends MarkerBlockImpl {
    @NotNull
    private final ProductionHolder productionHolder;
    private int realInterestingOffset;

    public CodeBlockMarkerBlock(@NotNull MarkdownConstraints myConstraints, @NotNull ProductionHolder productionHolder, @NotNull LookaheadText.Position startPosition) {
        Intrinsics.checkNotNullParameter((Object)myConstraints, (String)"myConstraints");
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkNotNullParameter((Object)startPosition, (String)"startPosition");
        super(myConstraints, productionHolder.mark());
        this.productionHolder = productionHolder;
        this.productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node(new IntRange(startPosition.getOffset(), startPosition.getNextLineOrEofOffset()), MarkdownTokenTypes.CODE_LINE)));
        this.realInterestingOffset = -1;
    }

    @Override
    public boolean allowsSubBlocks() {
        return false;
    }

    @Override
    public boolean isInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return true;
    }

    @Override
    protected int calcNextInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return pos.getNextLineOrEofOffset();
    }

    @Override
    @NotNull
    protected MarkerBlock.ClosingAction getDefaultAction() {
        return MarkerBlock.ClosingAction.DONE;
    }

    @Override
    @NotNull
    protected MarkerBlock.ProcessingResult doProcessToken(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints currentConstraints) {
        LookaheadText.Position position;
        MarkdownConstraints nextConstraints;
        block10: {
            block9: {
                Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
                Intrinsics.checkNotNullParameter((Object)currentConstraints, (String)"currentConstraints");
                if (pos.getOffset() < this.realInterestingOffset) {
                    return MarkerBlock.ProcessingResult.Companion.getCANCEL();
                }
                if (pos.getOffsetInCurrentLine() != -1) {
                    return MarkerBlock.ProcessingResult.Companion.getCANCEL();
                }
                Compat compat = Compat.INSTANCE;
                boolean condition$iv = pos.getOffsetInCurrentLine() == -1;
                boolean $i$f$assert = false;
                if (!condition$iv) {
                    boolean bl = false;
                    String string = "";
                    throw new MarkdownParsingException(string);
                }
                LookaheadText.Position position2 = MarkdownParserUtil.INSTANCE.findNonEmptyLineWithSameConstraints(this.getConstraints(), pos);
                if (position2 == null) {
                    return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
                }
                LookaheadText.Position nonemptyPos = position2;
                nextConstraints = MarkdownConstraintsKt.applyToNextLineAndAddModifiers(this.getConstraints(), nonemptyPos);
                LookaheadText.Position shifted = nonemptyPos.nextPosition(1 + MarkdownConstraintsKt.getCharsEaten(nextConstraints, nonemptyPos.getCurrentLine()));
                position = shifted;
                if (position == null) break block9;
                Integer n = shifted.charsToNonWhitespace();
                if ((position = position.nextPosition(n != null ? n : 0)) != null) break block10;
            }
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        LookaheadText.Position nonWhitespace = position;
        if (!MarkdownParserUtil.INSTANCE.hasCodeBlockIndent(nonWhitespace, nextConstraints)) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        MarkdownConstraints nextLineConstraints = MarkdownConstraintsKt.applyToNextLineAndAddModifiers(this.getConstraints(), pos);
        IntRange nodeRange = new IntRange(pos.getOffset() + 1 + MarkdownConstraintsKt.getCharsEaten(nextLineConstraints, pos.getCurrentLine()), pos.getNextLineOrEofOffset());
        if (nodeRange.getLast() - nodeRange.getFirst() > 0) {
            this.productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node(nodeRange, MarkdownTokenTypes.CODE_LINE)));
        }
        this.realInterestingOffset = pos.getNextLineOrEofOffset();
        return MarkerBlock.ProcessingResult.Companion.getCANCEL();
    }

    @Override
    @NotNull
    public IElementType getDefaultNodeType() {
        return MarkdownElementTypes.CODE_BLOCK;
    }
}

