/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks;

import kotlin.jvm.internal.Intrinsics;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MarkerBlockImpl
implements MarkerBlock {
    @NotNull
    private final MarkdownConstraints constraints;
    @NotNull
    private final ProductionHolder.Marker marker;
    private int lastInterestingOffset;
    @Nullable
    private MarkerBlock.ProcessingResult scheduledResult;

    public MarkerBlockImpl(@NotNull MarkdownConstraints constraints, @NotNull ProductionHolder.Marker marker) {
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        this.constraints = constraints;
        this.marker = marker;
        this.lastInterestingOffset = -2;
    }

    @NotNull
    protected final MarkdownConstraints getConstraints() {
        return this.constraints;
    }

    @Override
    public final int getNextInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (this.scheduledResult != null) {
            return pos.getOffset() + 1;
        }
        if (this.lastInterestingOffset != -1 && this.lastInterestingOffset <= pos.getOffset()) {
            this.lastInterestingOffset = this.calcNextInterestingOffset(pos);
        }
        return this.lastInterestingOffset;
    }

    @Override
    @NotNull
    public final MarkerBlock.ProcessingResult processToken(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints currentConstraints) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)currentConstraints, (String)"currentConstraints");
        if (this.lastInterestingOffset != pos.getOffset() && this.scheduledResult != null) {
            return MarkerBlock.ProcessingResult.Companion.getCANCEL();
        }
        if (this.lastInterestingOffset == -1 || this.lastInterestingOffset > pos.getOffset()) {
            return MarkerBlock.ProcessingResult.Companion.getPASS();
        }
        if (this.lastInterestingOffset < pos.getOffset() && !this.isInterestingOffset(pos)) {
            return MarkerBlock.ProcessingResult.Companion.getPASS();
        }
        if (this.scheduledResult != null) {
            MarkerBlock.ProcessingResult processingResult = this.scheduledResult;
            Intrinsics.checkNotNull((Object)processingResult);
            return processingResult;
        }
        return this.doProcessToken(pos, currentConstraints);
    }

    @Override
    @NotNull
    public final MarkdownConstraints getBlockConstraints() {
        return this.constraints;
    }

    @Override
    public boolean acceptAction(@NotNull MarkerBlock.ClosingAction action2) {
        Intrinsics.checkNotNullParameter((Object)((Object)action2), (String)"action");
        MarkerBlock.ClosingAction actionToRun = action2;
        if (actionToRun == MarkerBlock.ClosingAction.DEFAULT) {
            actionToRun = this.getDefaultAction();
        }
        actionToRun.doAction(this.marker, this.getDefaultNodeType());
        return actionToRun != MarkerBlock.ClosingAction.NOTHING;
    }

    protected final void scheduleProcessingResult(int offset, @NotNull MarkerBlock.ProcessingResult result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        this.lastInterestingOffset = offset;
        this.scheduledResult = result2;
    }

    @NotNull
    protected abstract MarkerBlock.ClosingAction getDefaultAction();

    @NotNull
    protected abstract MarkerBlock.ProcessingResult doProcessToken(@NotNull LookaheadText.Position var1, @NotNull MarkdownConstraints var2);

    protected abstract int calcNextInterestingOffset(@NotNull LookaheadText.Position var1);

    @NotNull
    public abstract IElementType getDefaultNodeType();
}

