/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser;

import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownParsingException;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTNodeBuilder;
import org.intellij.markdown.ast.CompositeASTNode;
import org.intellij.markdown.ast.LeafASTNode;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.markdown.lexer.MarkdownLexer;
import org.intellij.markdown.parser.CancellationToken;
import org.intellij.markdown.parser.InlineBuilder;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.TopLevelBuilder;
import org.intellij.markdown.parser.sequentialparsers.LexerBasedTokensCache;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParserUtil;
import org.jetbrains.annotations.NotNull;

public final class MarkdownParser {
    @NotNull
    private final MarkdownFlavourDescriptor flavour;
    private final boolean assertionsEnabled;
    @NotNull
    private final CancellationToken cancellationToken;

    public MarkdownParser(@NotNull MarkdownFlavourDescriptor flavour, boolean assertionsEnabled, @NotNull CancellationToken cancellationToken) {
        Intrinsics.checkNotNullParameter((Object)flavour, (String)"flavour");
        Intrinsics.checkNotNullParameter((Object)cancellationToken, (String)"cancellationToken");
        this.flavour = flavour;
        this.assertionsEnabled = assertionsEnabled;
        this.cancellationToken = cancellationToken;
    }

    public MarkdownParser(@NotNull MarkdownFlavourDescriptor flavour) {
        Intrinsics.checkNotNullParameter((Object)flavour, (String)"flavour");
        this(flavour, true);
    }

    public MarkdownParser(@NotNull MarkdownFlavourDescriptor flavour, boolean assertionsEnabled) {
        Intrinsics.checkNotNullParameter((Object)flavour, (String)"flavour");
        this(flavour, assertionsEnabled, CancellationToken.NonCancellable.INSTANCE);
    }

    @NotNull
    public final ASTNode parse(@NotNull IElementType root, @NotNull String text2, boolean parseInlines) {
        ASTNode aSTNode;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        try {
            aSTNode = this.doParse(root, text2, parseInlines);
        }
        catch (MarkdownParsingException e) {
            if (this.assertionsEnabled) {
                throw e;
            }
            aSTNode = this.topLevelFallback(root, text2);
        }
        return aSTNode;
    }

    @NotNull
    public final ASTNode parseInline(@NotNull IElementType root, @NotNull CharSequence text2, int textStart, int textEnd) {
        ASTNode aSTNode;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        try {
            aSTNode = this.doParseInline(root, text2, textStart, textEnd);
        }
        catch (MarkdownParsingException e) {
            if (this.assertionsEnabled) {
                throw e;
            }
            aSTNode = this.inlineFallback(root, textStart, textEnd);
        }
        return aSTNode;
    }

    private final ASTNode doParse(IElementType root, String text2, boolean parseInlines) {
        ProductionHolder productionHolder = new ProductionHolder();
        MarkerProcessor<?> markerProcessor = this.flavour.getMarkerProcessorFactory().createMarkerProcessor(productionHolder);
        ProductionHolder.Marker rootMarker = productionHolder.mark();
        LookaheadText textHolder = new LookaheadText(text2);
        LookaheadText.Position pos = textHolder.getStartPosition();
        while (pos != null) {
            this.cancellationToken.checkCancelled();
            productionHolder.updatePosition(pos.getOffset());
            pos = markerProcessor.processPosition(pos);
        }
        productionHolder.updatePosition(text2.length());
        markerProcessor.flushMarkers();
        rootMarker.done(root);
        ASTNodeBuilder nodeBuilder = parseInlines ? (ASTNodeBuilder)new InlineExpandingASTNodeBuilder(text2) : new ASTNodeBuilder(text2);
        TopLevelBuilder builder = new TopLevelBuilder(nodeBuilder);
        return builder.buildTree(productionHolder.getProduction());
    }

    private final ASTNode doParseInline(IElementType root, CharSequence text2, int textStart, int textEnd) {
        MarkdownLexer lexer = this.flavour.createInlinesLexer();
        MarkdownLexer.start$default(lexer, text2, textStart, textEnd, 0, 8, null);
        LexerBasedTokensCache tokensCache = new LexerBasedTokensCache(lexer);
        IntRange wholeRange = new IntRange(0, tokensCache.getFilteredTokens().size());
        Collection<SequentialParser.Node> nodes = this.flavour.getSequentialParserManager().runParsingSequence(tokensCache, SequentialParserUtil.Companion.filterBlockquotes(tokensCache, wholeRange), this.cancellationToken);
        InlineBuilder builder = new InlineBuilder(new ASTNodeBuilder(text2, this.cancellationToken), tokensCache, this.cancellationToken);
        return builder.buildTree(CollectionsKt.plus(nodes, (Iterable)CollectionsKt.listOf((Object)new SequentialParser.Node(wholeRange, root))));
    }

    private final ASTNode topLevelFallback(IElementType root, String text2) {
        return new CompositeASTNode(root, CollectionsKt.listOf((Object)this.inlineFallback(MarkdownElementTypes.PARAGRAPH, 0, text2.length())));
    }

    private final ASTNode inlineFallback(IElementType root, int textStart, int textEnd) {
        return new CompositeASTNode(root, CollectionsKt.listOf((Object)new LeafASTNode(MarkdownTokenTypes.TEXT, textStart, textEnd)));
    }

    private final class InlineExpandingASTNodeBuilder
    extends ASTNodeBuilder {
        public InlineExpandingASTNodeBuilder(CharSequence text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            super(text2);
        }

        @Override
        @NotNull
        public List<ASTNode> createLeafNodes(@NotNull IElementType type2, int startOffset, int endOffset) {
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            IElementType iElementType = type2;
            return (((Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.PARAGRAPH) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.ATX_CONTENT)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.SETEXT_CONTENT)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)GFMTokenTypes.CELL)) ? CollectionsKt.listOf((Object)MarkdownParser.this.parseInline(type2, this.getText(), startOffset, endOffset)) : super.createLeafNodes(type2, startOffset, endOffset);
        }
    }
}

