/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownParsingException;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTNodeBuilder;
import org.intellij.markdown.lexer.Compat;
import org.intellij.markdown.parser.CancellationToken;
import org.intellij.markdown.parser.TreeBuilder;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nInlineBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineBuilder.kt\norg/intellij/markdown/parser/InlineBuilder\n+ 2 Compat.kt\norg/intellij/markdown/lexer/Compat\n+ 3 Compat.kt\norg/intellij/markdown/lexer/Compat$assert$1\n*L\n1#1,86:1\n106#2,3:87\n110#2:91\n106#3:90\n*S KotlinDebug\n*F\n+ 1 InlineBuilder.kt\norg/intellij/markdown/parser/InlineBuilder\n*L\n33#1:87,3\n33#1:91\n33#1:90\n*E\n"})
public final class InlineBuilder
extends TreeBuilder {
    @NotNull
    private final TokensCache tokensCache;
    private int currentTokenPosition;

    public InlineBuilder(@NotNull ASTNodeBuilder nodeBuilder, @NotNull TokensCache tokensCache, @NotNull CancellationToken cancellationToken) {
        Intrinsics.checkNotNullParameter((Object)nodeBuilder, (String)"nodeBuilder");
        Intrinsics.checkNotNullParameter((Object)tokensCache, (String)"tokensCache");
        Intrinsics.checkNotNullParameter((Object)cancellationToken, (String)"cancellationToken");
        super(nodeBuilder, cancellationToken);
        this.tokensCache = tokensCache;
        this.currentTokenPosition = -1;
    }

    @Override
    protected void flushEverythingBeforeEvent(@NotNull TreeBuilder.MyEvent event, @Nullable List<TreeBuilder.MyASTNodeWrapper> currentNodeChildren) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.currentTokenPosition == -1) {
            this.currentTokenPosition = event.getPosition();
        }
        while (this.currentTokenPosition < event.getPosition()) {
            this.flushOneTokenToTree(this.tokensCache, currentNodeChildren, this.currentTokenPosition);
            int n = this.currentTokenPosition;
            this.currentTokenPosition = n + 1;
        }
    }

    private final void flushOneTokenToTree(TokensCache tokensCache, List<TreeBuilder.MyASTNodeWrapper> currentNodeChildren, int currentTokenPosition) {
        TokensCache.Iterator iterator2 = new TokensCache.Iterator(tokensCache, currentTokenPosition);
        Compat compat = Compat.INSTANCE;
        boolean condition$iv = iterator2.getType() != null;
        boolean $i$f$assert = false;
        if (!condition$iv) {
            boolean bl = false;
            String string = "";
            throw new MarkdownParsingException(string);
        }
        ASTNodeBuilder aSTNodeBuilder = this.getNodeBuilder();
        IElementType iElementType = iterator2.getType();
        Intrinsics.checkNotNull((Object)iElementType);
        List<ASTNode> nodes = aSTNodeBuilder.createLeafNodes(iElementType, iterator2.getStart(), iterator2.getEnd());
        for (ASTNode node2 : nodes) {
            List<TreeBuilder.MyASTNodeWrapper> list2 = currentNodeChildren;
            if (list2 == null) continue;
            list2.add(new TreeBuilder.MyASTNodeWrapper(node2, iterator2.getIndex(), iterator2.getIndex() + 1));
        }
    }

    @Override
    @NotNull
    protected TreeBuilder.MyASTNodeWrapper createASTNodeOnClosingEvent(@NotNull TreeBuilder.MyEvent event, @NotNull List<TreeBuilder.MyASTNodeWrapper> currentNodeChildren, boolean isTopmostNode) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(currentNodeChildren, (String)"currentNodeChildren");
        ASTNode newNode = null;
        IElementType type2 = event.getInfo().getType();
        int startTokenId = event.getInfo().getRange().getFirst();
        int endTokenId = event.getInfo().getRange().getLast();
        ArrayList<ASTNode> childrenWithWhitespaces = new ArrayList<ASTNode>(currentNodeChildren.size());
        if (isTopmostNode) {
            this.addRawTokens(this.tokensCache, (List<ASTNode>)childrenWithWhitespaces, startTokenId, -1, -1);
        }
        int n = currentNodeChildren.size();
        for (int index = 1; index < n; ++index) {
            TreeBuilder.MyASTNodeWrapper prev = currentNodeChildren.get(index - 1);
            TreeBuilder.MyASTNodeWrapper next2 = currentNodeChildren.get(index);
            childrenWithWhitespaces.add(prev.getAstNode());
            this.addRawTokens(this.tokensCache, (List<ASTNode>)childrenWithWhitespaces, prev.getEndTokenIndex() - 1, 1, new TokensCache.Iterator(this.tokensCache, next2.getStartTokenIndex()).getStart());
        }
        if (!((Collection)currentNodeChildren).isEmpty()) {
            childrenWithWhitespaces.add(((TreeBuilder.MyASTNodeWrapper)CollectionsKt.last(currentNodeChildren)).getAstNode());
        }
        if (isTopmostNode) {
            this.addRawTokens(this.tokensCache, (List<ASTNode>)childrenWithWhitespaces, endTokenId - 1, 1, new TokensCache.Iterator(this.tokensCache, endTokenId).getStart());
        }
        newNode = this.getNodeBuilder().createCompositeNode(type2, (List<? extends ASTNode>)childrenWithWhitespaces);
        return new TreeBuilder.MyASTNodeWrapper(newNode, startTokenId, endTokenId);
    }

    private final void addRawTokens(TokensCache tokensCache, List<ASTNode> childrenWithWhitespaces, int from, int dx, int exitOffset) {
        TokensCache.Iterator iterator2 = new TokensCache.Iterator(tokensCache, from);
        int rawIdx = 0;
        while (iterator2.rawLookup(rawIdx + dx) != null && iterator2.rawStart(rawIdx + dx) != exitOffset) {
            rawIdx += dx;
        }
        while (rawIdx != 0) {
            IElementType rawType;
            Intrinsics.checkNotNull((Object)iterator2.rawLookup(rawIdx));
            childrenWithWhitespaces.addAll((Collection<ASTNode>)this.getNodeBuilder().createLeafNodes(rawType, iterator2.rawStart(rawIdx), iterator2.rawStart(rawIdx + 1)));
            rawIdx -= dx;
        }
    }
}

