/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.ast.impl;

import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.CompositeASTNode;
import org.jetbrains.annotations.NotNull;

public final class ListCompositeNode
extends CompositeASTNode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy loose$delegate;

    public ListCompositeNode(@NotNull IElementType type2, @NotNull List<? extends ASTNode> children) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        super(type2, children);
        this.loose$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ ListCompositeNode this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Boolean invoke() {
                return ListCompositeNode.access$isLoose(this.this$0);
            }
        }));
    }

    private final boolean isLoose() {
        if (ListCompositeNode.Companion.hasLooseContent(this)) {
            return true;
        }
        for (ASTNode child2 : this.getChildren()) {
            if (!Intrinsics.areEqual((Object)child2.getType(), (Object)MarkdownElementTypes.LIST_ITEM) || !ListCompositeNode.Companion.hasLooseContent(child2)) continue;
            return true;
        }
        return false;
    }

    public static final /* synthetic */ boolean access$isLoose(ListCompositeNode $this) {
        return $this.isLoose();
    }

    public static final class Companion {
        private Companion() {
        }

        private final boolean hasLooseContent(ASTNode node2) {
            int newlines = 0;
            boolean seenNonWhitespace = false;
            for (ASTNode child2 : node2.getChildren()) {
                IElementType iElementType = child2.getType();
                if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.EOL)) {
                    ++newlines;
                    continue;
                }
                if ((Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.LIST_BULLET) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.LIST_NUMBER)) ? true : Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.WHITE_SPACE)) continue;
                if (seenNonWhitespace && newlines > 1) {
                    return true;
                }
                seenNonWhitespace = true;
                newlines = 0;
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

