/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.field.FiniteField;
import org.bouncycastle.math.field.PolynomialExtensionField;

public class ECAlgorithms {
    public static boolean isF2mCurve(ECCurve eCCurve) {
        return ECAlgorithms.isF2mField(eCCurve.getField());
    }

    public static boolean isF2mField(FiniteField finiteField) {
        return finiteField.getDimension() > 1 && finiteField.getCharacteristic().equals(ECConstants.TWO) && finiteField instanceof PolynomialExtensionField;
    }

    public static boolean isFpCurve(ECCurve eCCurve) {
        return ECAlgorithms.isFpField(eCCurve.getField());
    }

    public static boolean isFpField(FiniteField finiteField) {
        return finiteField.getDimension() == 1;
    }

    public static void montgomeryTrick(ECFieldElement[] eCFieldElementArray, int n, int n2, ECFieldElement eCFieldElement) {
        ECFieldElement[] eCFieldElementArray2 = new ECFieldElement[n2];
        eCFieldElementArray2[0] = eCFieldElementArray[n];
        int n3 = 0;
        while (++n3 < n2) {
            eCFieldElementArray2[n3] = eCFieldElementArray2[n3 - 1].multiply(eCFieldElementArray[n + n3]);
        }
        --n3;
        if (eCFieldElement != null) {
            eCFieldElementArray2[n3] = eCFieldElementArray2[n3].multiply(eCFieldElement);
        }
        ECFieldElement eCFieldElement2 = eCFieldElementArray2[n3].invert();
        while (n3 > 0) {
            int n4 = n + n3--;
            ECFieldElement eCFieldElement3 = eCFieldElementArray[n4];
            eCFieldElementArray[n4] = eCFieldElementArray2[n3].multiply(eCFieldElement2);
            eCFieldElement2 = eCFieldElement2.multiply(eCFieldElement3);
        }
        eCFieldElementArray[n] = eCFieldElement2;
    }
}

