/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.commons.compress.archivers.zip.ZipShort;
import org.apache.commons.compress.archivers.zip.ZipUtil;

public abstract class PKWareExtraHeader
implements ZipExtraField {
    private final ZipShort headerId;
    private byte[] localData;
    private byte[] centralData;

    protected PKWareExtraHeader(ZipShort headerId) {
        this.headerId = headerId;
    }

    protected final void assertMinimalLength(int minimum, int length) throws ZipException {
        if (length < minimum) {
            throw new ZipException(this.getClass().getName() + " is too short, only " + length + " bytes, expected at least " + minimum);
        }
    }

    @Override
    public byte[] getCentralDirectoryData() {
        if (this.centralData != null) {
            return ZipUtil.copy(this.centralData);
        }
        return this.getLocalFileDataData();
    }

    @Override
    public ZipShort getCentralDirectoryLength() {
        if (this.centralData != null) {
            return new ZipShort(this.centralData.length);
        }
        return this.getLocalFileDataLength();
    }

    @Override
    public ZipShort getHeaderId() {
        return this.headerId;
    }

    @Override
    public byte[] getLocalFileDataData() {
        return ZipUtil.copy(this.localData);
    }

    @Override
    public ZipShort getLocalFileDataLength() {
        return new ZipShort(this.localData != null ? this.localData.length : 0);
    }

    @Override
    public void parseFromCentralDirectoryData(byte[] data2, int offset, int length) throws ZipException {
        byte[] tmp = Arrays.copyOfRange(data2, offset, offset + length);
        this.setCentralDirectoryData(tmp);
        if (this.localData == null) {
            this.setLocalFileDataData(tmp);
        }
    }

    @Override
    public void parseFromLocalFileData(byte[] data2, int offset, int length) throws ZipException {
        this.setLocalFileDataData(Arrays.copyOfRange(data2, offset, offset + length));
    }

    public void setCentralDirectoryData(byte[] data2) {
        this.centralData = ZipUtil.copy(data2);
    }

    public void setLocalFileDataData(byte[] data2) {
        this.localData = ZipUtil.copy(data2);
    }

    public static final class HashAlgorithm
    extends Enum<HashAlgorithm> {
        public static final /* enum */ HashAlgorithm NONE = new HashAlgorithm(0);
        public static final /* enum */ HashAlgorithm CRC32 = new HashAlgorithm(1);
        public static final /* enum */ HashAlgorithm MD5 = new HashAlgorithm(32771);
        public static final /* enum */ HashAlgorithm SHA1 = new HashAlgorithm(32772);
        public static final /* enum */ HashAlgorithm RIPEND160 = new HashAlgorithm(32775);
        public static final /* enum */ HashAlgorithm SHA256 = new HashAlgorithm(32780);
        public static final /* enum */ HashAlgorithm SHA384 = new HashAlgorithm(32781);
        public static final /* enum */ HashAlgorithm SHA512 = new HashAlgorithm(32782);
        private static final Map<Integer, HashAlgorithm> codeToEnum;
        private final int code;
        private static final /* synthetic */ HashAlgorithm[] $VALUES;

        public static HashAlgorithm[] values() {
            return (HashAlgorithm[])$VALUES.clone();
        }

        public static HashAlgorithm getAlgorithmByCode(int code) {
            return codeToEnum.get(code);
        }

        private HashAlgorithm(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        private static /* synthetic */ HashAlgorithm[] $values() {
            return new HashAlgorithm[]{NONE, CRC32, MD5, SHA1, RIPEND160, SHA256, SHA384, SHA512};
        }

        static {
            $VALUES = HashAlgorithm.$values();
            HashMap<Integer, HashAlgorithm> cte = new HashMap<Integer, HashAlgorithm>();
            for (HashAlgorithm method : HashAlgorithm.values()) {
                cte.put(method.getCode(), method);
            }
            codeToEnum = Collections.unmodifiableMap(cte);
        }
    }

    public static final class EncryptionAlgorithm
    extends Enum<EncryptionAlgorithm> {
        public static final /* enum */ EncryptionAlgorithm DES = new EncryptionAlgorithm(26113);
        public static final /* enum */ EncryptionAlgorithm RC2pre52 = new EncryptionAlgorithm(26114);
        public static final /* enum */ EncryptionAlgorithm TripleDES168 = new EncryptionAlgorithm(26115);
        public static final /* enum */ EncryptionAlgorithm TripleDES192 = new EncryptionAlgorithm(26121);
        public static final /* enum */ EncryptionAlgorithm AES128 = new EncryptionAlgorithm(26126);
        public static final /* enum */ EncryptionAlgorithm AES192 = new EncryptionAlgorithm(26127);
        public static final /* enum */ EncryptionAlgorithm AES256 = new EncryptionAlgorithm(26128);
        public static final /* enum */ EncryptionAlgorithm RC2 = new EncryptionAlgorithm(26370);
        public static final /* enum */ EncryptionAlgorithm RC4 = new EncryptionAlgorithm(26625);
        public static final /* enum */ EncryptionAlgorithm UNKNOWN = new EncryptionAlgorithm(65535);
        private static final Map<Integer, EncryptionAlgorithm> codeToEnum;
        private final int code;
        private static final /* synthetic */ EncryptionAlgorithm[] $VALUES;

        public static EncryptionAlgorithm[] values() {
            return (EncryptionAlgorithm[])$VALUES.clone();
        }

        public static EncryptionAlgorithm getAlgorithmByCode(int code) {
            return codeToEnum.get(code);
        }

        private EncryptionAlgorithm(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        private static /* synthetic */ EncryptionAlgorithm[] $values() {
            return new EncryptionAlgorithm[]{DES, RC2pre52, TripleDES168, TripleDES192, AES128, AES192, AES256, RC2, RC4, UNKNOWN};
        }

        static {
            $VALUES = EncryptionAlgorithm.$values();
            HashMap<Integer, EncryptionAlgorithm> cte = new HashMap<Integer, EncryptionAlgorithm>();
            for (EncryptionAlgorithm method : EncryptionAlgorithm.values()) {
                cte.put(method.getCode(), method);
            }
            codeToEnum = Collections.unmodifiableMap(cte);
        }
    }
}

