/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

class InflaterInputStreamWithStatistics
extends InflaterInputStream {
    private long compressedCount;
    private long uncompressedCount;

    InflaterInputStreamWithStatistics(InputStream in, Inflater inf) {
        super(in, inf);
    }

    @Override
    protected void fill() throws IOException {
        super.fill();
        this.compressedCount += (long)this.inf.getRemaining();
    }

    @Override
    public int read() throws IOException {
        int b = super.read();
        if (b > -1) {
            ++this.uncompressedCount;
        }
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytes2 = super.read(b, off, len);
        if (bytes2 > -1) {
            this.uncompressedCount += (long)bytes2;
        }
        return bytes2;
    }
}

