/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls.internal.der;

import kotlin.jvm.internal.Intrinsics;
import okhttp3.tls.internal.der.AlgorithmIdentifier;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PrivateKeyInfo {
    private final long version;
    @NotNull
    private final AlgorithmIdentifier algorithmIdentifier;
    @NotNull
    private final ByteString privateKey;

    public PrivateKeyInfo(long version, @NotNull AlgorithmIdentifier algorithmIdentifier2, @NotNull ByteString privateKey) {
        Intrinsics.checkNotNullParameter((Object)algorithmIdentifier2, (String)"algorithmIdentifier");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        this.version = version;
        this.algorithmIdentifier = algorithmIdentifier2;
        this.privateKey = privateKey;
    }

    public final long getVersion() {
        return this.version;
    }

    @NotNull
    public final AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algorithmIdentifier;
    }

    @NotNull
    public final ByteString getPrivateKey() {
        return this.privateKey;
    }

    public int hashCode() {
        int result2 = 0;
        result2 = 31 * result2 + (int)this.version;
        result2 = 31 * result2 + this.algorithmIdentifier.hashCode();
        result2 = 31 * result2 + this.privateKey.hashCode();
        return result2;
    }

    public final long component1() {
        return this.version;
    }

    @NotNull
    public final AlgorithmIdentifier component2() {
        return this.algorithmIdentifier;
    }

    @NotNull
    public final ByteString component3() {
        return this.privateKey;
    }

    @NotNull
    public final PrivateKeyInfo copy(long version, @NotNull AlgorithmIdentifier algorithmIdentifier2, @NotNull ByteString privateKey) {
        Intrinsics.checkNotNullParameter((Object)algorithmIdentifier2, (String)"algorithmIdentifier");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        return new PrivateKeyInfo(version, algorithmIdentifier2, privateKey);
    }

    public static /* synthetic */ PrivateKeyInfo copy$default(PrivateKeyInfo privateKeyInfo2, long l, AlgorithmIdentifier algorithmIdentifier2, ByteString byteString, int n, Object object) {
        if ((n & 1) != 0) {
            l = privateKeyInfo2.version;
        }
        if ((n & 2) != 0) {
            algorithmIdentifier2 = privateKeyInfo2.algorithmIdentifier;
        }
        if ((n & 4) != 0) {
            byteString = privateKeyInfo2.privateKey;
        }
        return privateKeyInfo2.copy(l, algorithmIdentifier2, byteString);
    }

    @NotNull
    public String toString() {
        return "PrivateKeyInfo(version=" + this.version + ", algorithmIdentifier=" + this.algorithmIdentifier + ", privateKey=" + this.privateKey + ')';
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PrivateKeyInfo)) {
            return false;
        }
        PrivateKeyInfo privateKeyInfo2 = (PrivateKeyInfo)other;
        if (this.version != privateKeyInfo2.version) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.algorithmIdentifier, (Object)privateKeyInfo2.algorithmIdentifier)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.privateKey, (Object)privateKeyInfo2.privateKey);
    }
}

