/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls.internal.der;

import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DerHeader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int tagClass;
    private long tag;
    private boolean constructed;
    private long length;
    public static final int TAG_CLASS_UNIVERSAL = 0;
    public static final int TAG_CLASS_APPLICATION = 64;
    public static final int TAG_CLASS_CONTEXT_SPECIFIC = 128;
    public static final int TAG_CLASS_PRIVATE = 192;
    public static final long TAG_END_OF_CONTENTS = 0L;

    public DerHeader(int tagClass, long tag, boolean constructed, long length) {
        this.tagClass = tagClass;
        this.tag = tag;
        this.constructed = constructed;
        this.length = length;
    }

    public final int getTagClass() {
        return this.tagClass;
    }

    public final void setTagClass(int n) {
        this.tagClass = n;
    }

    public final long getTag() {
        return this.tag;
    }

    public final void setTag(long l) {
        this.tag = l;
    }

    public final boolean getConstructed() {
        return this.constructed;
    }

    public final void setConstructed(boolean bl) {
        this.constructed = bl;
    }

    public final long getLength() {
        return this.length;
    }

    public final void setLength(long l) {
        this.length = l;
    }

    public final boolean isEndOfData() {
        return this.tagClass == 0 && this.tag == 0L;
    }

    public int hashCode() {
        int result2 = 0;
        result2 = 31 * result2 + this.tagClass;
        result2 = 31 * result2 + (int)this.tag;
        result2 = 31 * result2 + (this.constructed ? 0 : 1);
        result2 = 31 * result2 + (int)this.length;
        return result2;
    }

    @NotNull
    public String toString() {
        return "" + this.tagClass + '/' + this.tag;
    }

    public final int component1() {
        return this.tagClass;
    }

    public final long component2() {
        return this.tag;
    }

    public final boolean component3() {
        return this.constructed;
    }

    public final long component4() {
        return this.length;
    }

    @NotNull
    public final DerHeader copy(int tagClass, long tag, boolean constructed, long length) {
        return new DerHeader(tagClass, tag, constructed, length);
    }

    public static /* synthetic */ DerHeader copy$default(DerHeader derHeader, int n, long l, boolean bl, long l2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = derHeader.tagClass;
        }
        if ((n2 & 2) != 0) {
            l = derHeader.tag;
        }
        if ((n2 & 4) != 0) {
            bl = derHeader.constructed;
        }
        if ((n2 & 8) != 0) {
            l2 = derHeader.length;
        }
        return derHeader.copy(n, l, bl, l2);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DerHeader)) {
            return false;
        }
        DerHeader derHeader = (DerHeader)other;
        if (this.tagClass != derHeader.tagClass) {
            return false;
        }
        if (this.tag != derHeader.tag) {
            return false;
        }
        if (this.constructed != derHeader.constructed) {
            return false;
        }
        return this.length == derHeader.length;
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

