/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls.internal.der;

import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.NoSuchElementException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.tls.internal.der.AlgorithmIdentifier;
import okhttp3.tls.internal.der.AttributeTypeAndValue;
import okhttp3.tls.internal.der.BitString;
import okhttp3.tls.internal.der.CertificateAdapters;
import okhttp3.tls.internal.der.Extension;
import okhttp3.tls.internal.der.TbsCertificate;
import okio.Buffer;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\ncertificates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 certificates.kt\nokhttp3/tls/internal/der/Certificate\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,193:1\n288#2,2:194\n288#2,2:196\n288#2,2:198\n223#2,2:200\n*S KotlinDebug\n*F\n+ 1 certificates.kt\nokhttp3/tls/internal/der/Certificate\n*L\n37#1:194,2\n45#1:196,2\n51#1:198,2\n58#1:200,2\n*E\n"})
public final class Certificate {
    @NotNull
    private final TbsCertificate tbsCertificate;
    @NotNull
    private final AlgorithmIdentifier signatureAlgorithm;
    @NotNull
    private final BitString signatureValue;

    public Certificate(@NotNull TbsCertificate tbsCertificate2, @NotNull AlgorithmIdentifier signatureAlgorithm, @NotNull BitString signatureValue) {
        Intrinsics.checkNotNullParameter((Object)tbsCertificate2, (String)"tbsCertificate");
        Intrinsics.checkNotNullParameter((Object)signatureAlgorithm, (String)"signatureAlgorithm");
        Intrinsics.checkNotNullParameter((Object)signatureValue, (String)"signatureValue");
        this.tbsCertificate = tbsCertificate2;
        this.signatureAlgorithm = signatureAlgorithm;
        this.signatureValue = signatureValue;
    }

    @NotNull
    public final TbsCertificate getTbsCertificate() {
        return this.tbsCertificate;
    }

    @NotNull
    public final AlgorithmIdentifier getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    @NotNull
    public final BitString getSignatureValue() {
        return this.signatureValue;
    }

    @Nullable
    public final Object getCommonName() {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = CollectionsKt.flatten((Iterable)this.tbsCertificate.getSubject());
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AttributeTypeAndValue it = (AttributeTypeAndValue)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)"2.5.4.3")) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        AttributeTypeAndValue attributeTypeAndValue2 = v0;
        return attributeTypeAndValue2 != null ? attributeTypeAndValue2.getValue() : null;
    }

    @Nullable
    public final Object getOrganizationalUnitName() {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = CollectionsKt.flatten((Iterable)this.tbsCertificate.getSubject());
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AttributeTypeAndValue it = (AttributeTypeAndValue)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)"2.5.4.11")) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        AttributeTypeAndValue attributeTypeAndValue2 = v0;
        return attributeTypeAndValue2 != null ? attributeTypeAndValue2.getValue() : null;
    }

    @Nullable
    public final Extension getSubjectAlternativeNames() {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.tbsCertificate.getExtensions();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Extension it = (Extension)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)"2.5.29.17")) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final Extension getBasicConstraints() {
        Object element$iv2;
        block1: {
            Iterable $this$first$iv = this.tbsCertificate.getExtensions();
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                Extension it = (Extension)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)"2.5.29.19")) continue;
                break block1;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return (Extension)element$iv2;
    }

    public final boolean checkSignature(@NotNull PublicKey issuer) throws SignatureException {
        Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
        ByteString signedData = CertificateAdapters.INSTANCE.getTbsCertificate$okhttp_tls().toDer(this.tbsCertificate);
        Signature $this$checkSignature_u24lambda_u244 = Signature.getInstance(this.tbsCertificate.getSignatureAlgorithmName());
        boolean bl = false;
        $this$checkSignature_u24lambda_u244.initVerify(issuer);
        $this$checkSignature_u24lambda_u244.update(signedData.toByteArray());
        return $this$checkSignature_u24lambda_u244.verify(this.signatureValue.getByteString().toByteArray());
    }

    @NotNull
    public final X509Certificate toX509Certificate() {
        ByteString data2 = CertificateAdapters.INSTANCE.getCertificate$okhttp_tls().toDer(this);
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            Collection<? extends java.security.cert.Certificate> certificates = certificateFactory.generateCertificates(new Buffer().write(data2).inputStream());
            Intrinsics.checkNotNullExpressionValue(certificates, (String)"certificates");
            Object object = CollectionsKt.single((Iterable)certificates);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
            return (X509Certificate)object;
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("failed to decode certificate", e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("failed to decode certificate", e);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("failed to decode certificate", e);
        }
    }

    @NotNull
    public final TbsCertificate component1() {
        return this.tbsCertificate;
    }

    @NotNull
    public final AlgorithmIdentifier component2() {
        return this.signatureAlgorithm;
    }

    @NotNull
    public final BitString component3() {
        return this.signatureValue;
    }

    @NotNull
    public final Certificate copy(@NotNull TbsCertificate tbsCertificate2, @NotNull AlgorithmIdentifier signatureAlgorithm, @NotNull BitString signatureValue) {
        Intrinsics.checkNotNullParameter((Object)tbsCertificate2, (String)"tbsCertificate");
        Intrinsics.checkNotNullParameter((Object)signatureAlgorithm, (String)"signatureAlgorithm");
        Intrinsics.checkNotNullParameter((Object)signatureValue, (String)"signatureValue");
        return new Certificate(tbsCertificate2, signatureAlgorithm, signatureValue);
    }

    public static /* synthetic */ Certificate copy$default(Certificate certificate2, TbsCertificate tbsCertificate2, AlgorithmIdentifier algorithmIdentifier2, BitString bitString, int n, Object object) {
        if ((n & 1) != 0) {
            tbsCertificate2 = certificate2.tbsCertificate;
        }
        if ((n & 2) != 0) {
            algorithmIdentifier2 = certificate2.signatureAlgorithm;
        }
        if ((n & 4) != 0) {
            bitString = certificate2.signatureValue;
        }
        return certificate2.copy(tbsCertificate2, algorithmIdentifier2, bitString);
    }

    @NotNull
    public String toString() {
        return "Certificate(tbsCertificate=" + this.tbsCertificate + ", signatureAlgorithm=" + this.signatureAlgorithm + ", signatureValue=" + this.signatureValue + ')';
    }

    public int hashCode() {
        int result2 = this.tbsCertificate.hashCode();
        result2 = result2 * 31 + this.signatureAlgorithm.hashCode();
        result2 = result2 * 31 + this.signatureValue.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Certificate)) {
            return false;
        }
        Certificate certificate2 = (Certificate)other;
        if (!Intrinsics.areEqual((Object)this.tbsCertificate, (Object)certificate2.tbsCertificate)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.signatureAlgorithm, (Object)certificate2.signatureAlgorithm)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.signatureValue, (Object)certificate2.signatureValue);
    }
}

