/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls.internal;

import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.Util;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@IgnoreJRERequirement
public final class InsecureExtendedTrustManager
extends X509ExtendedTrustManager {
    @NotNull
    private final X509ExtendedTrustManager delegate;
    @NotNull
    private final List<String> insecureHosts;

    public InsecureExtendedTrustManager(@NotNull X509ExtendedTrustManager delegate, @NotNull List<String> insecureHosts) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter(insecureHosts, (String)"insecureHosts");
        this.delegate = delegate;
        this.insecureHosts = insecureHosts;
    }

    @Override
    @NotNull
    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] x509CertificateArray = this.delegate.getAcceptedIssuers();
        Intrinsics.checkNotNullExpressionValue((Object)x509CertificateArray, (String)"delegate.acceptedIssuers");
        return x509CertificateArray;
    }

    @Override
    public void checkServerTrusted(@NotNull X509Certificate[] chain, @NotNull String authType, @NotNull Socket socket) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        if (!this.insecureHosts.contains(Util.peerName(socket))) {
            this.delegate.checkServerTrusted(chain, authType, socket);
        }
    }

    @Override
    public void checkServerTrusted(@NotNull X509Certificate[] chain, @NotNull String authType, @NotNull SSLEngine engine2) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
        Intrinsics.checkNotNullParameter((Object)engine2, (String)"engine");
        if (!this.insecureHosts.contains(engine2.getPeerHost())) {
            this.delegate.checkServerTrusted(chain, authType, engine2);
        }
    }

    @NotNull
    public Void checkServerTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
        throw new CertificateException("Unsupported operation");
    }

    @NotNull
    public Void checkClientTrusted(@NotNull X509Certificate[] chain, @Nullable String authType) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        throw new CertificateException("Unsupported operation");
    }

    @NotNull
    public Void checkClientTrusted(@NotNull X509Certificate[] chain, @NotNull String authType, @Nullable SSLEngine engine2) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
        throw new CertificateException("Unsupported operation");
    }

    @NotNull
    public Void checkClientTrusted(@NotNull X509Certificate[] chain, @NotNull String authType, @Nullable Socket socket) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
        throw new CertificateException("Unsupported operation");
    }
}

