/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.ws;

import java.io.Closeable;
import java.io.IOException;
import java.util.Random;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.internal.ws.MessageDeflater;
import okhttp3.internal.ws.WebSocketProtocol;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nWebSocketWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSocketWriter.kt\nokhttp3/internal/ws/WebSocketWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,202:1\n1#2:203\n*E\n"})
public final class WebSocketWriter
implements Closeable {
    private final boolean isClient;
    @NotNull
    private final BufferedSink sink;
    @NotNull
    private final Random random;
    private final boolean perMessageDeflate;
    private final boolean noContextTakeover;
    private final long minimumDeflateSize;
    @NotNull
    private final Buffer messageBuffer;
    @NotNull
    private final Buffer sinkBuffer;
    private boolean writerClosed;
    @Nullable
    private MessageDeflater messageDeflater;
    @Nullable
    private final byte[] maskKey;
    @Nullable
    private final Buffer.UnsafeCursor maskCursor;

    public WebSocketWriter(boolean isClient, @NotNull BufferedSink sink, @NotNull Random random, boolean perMessageDeflate, boolean noContextTakeover, long minimumDeflateSize) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        this.isClient = isClient;
        this.sink = sink;
        this.random = random;
        this.perMessageDeflate = perMessageDeflate;
        this.noContextTakeover = noContextTakeover;
        this.minimumDeflateSize = minimumDeflateSize;
        this.messageBuffer = new Buffer();
        this.sinkBuffer = this.sink.getBuffer();
        this.maskKey = this.isClient ? new byte[4] : null;
        this.maskCursor = this.isClient ? new Buffer.UnsafeCursor() : null;
    }

    @NotNull
    public final BufferedSink getSink() {
        return this.sink;
    }

    @NotNull
    public final Random getRandom() {
        return this.random;
    }

    public final void writePing(@NotNull ByteString payload) throws IOException {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        this.writeControlFrame(9, payload);
    }

    public final void writePong(@NotNull ByteString payload) throws IOException {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        this.writeControlFrame(10, payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeClose(int code, @Nullable ByteString reason) throws IOException {
        ByteString payload = ByteString.EMPTY;
        if (code != 0 || reason != null) {
            if (code != 0) {
                WebSocketProtocol.INSTANCE.validateCloseCode(code);
            }
            Buffer $this$writeClose_u24lambda_u240 = new Buffer();
            boolean bl = false;
            $this$writeClose_u24lambda_u240.writeShort(code);
            if (reason != null) {
                $this$writeClose_u24lambda_u240.write(reason);
            }
            payload = $this$writeClose_u24lambda_u240.readByteString();
        }
        try {
            this.writeControlFrame(8, payload);
        }
        finally {
            this.writerClosed = true;
        }
    }

    private final void writeControlFrame(int opcode, ByteString payload) throws IOException {
        if (this.writerClosed) {
            throw new IOException("closed");
        }
        int length = payload.size();
        if (!((long)length <= 125L)) {
            boolean $i$a$-require-WebSocketWriter$writeControlFrame$22 = false;
            String $i$a$-require-WebSocketWriter$writeControlFrame$22 = "Payload size must be less than or equal to 125";
            throw new IllegalArgumentException($i$a$-require-WebSocketWriter$writeControlFrame$22.toString());
        }
        int b0 = 0x80 | opcode;
        this.sinkBuffer.writeByte(b0);
        int b1 = length;
        if (this.isClient) {
            this.sinkBuffer.writeByte(b1 |= 0x80);
            Intrinsics.checkNotNull((Object)this.maskKey);
            this.random.nextBytes(this.maskKey);
            this.sinkBuffer.write(this.maskKey);
            if (length > 0) {
                long payloadStart = this.sinkBuffer.size();
                this.sinkBuffer.write(payload);
                Buffer.UnsafeCursor unsafeCursor = this.maskCursor;
                Intrinsics.checkNotNull((Object)unsafeCursor);
                this.sinkBuffer.readAndWriteUnsafe(unsafeCursor);
                this.maskCursor.seek(payloadStart);
                WebSocketProtocol.INSTANCE.toggleMask(this.maskCursor, this.maskKey);
                this.maskCursor.close();
            }
        } else {
            this.sinkBuffer.writeByte(b1);
            this.sinkBuffer.write(payload);
        }
        this.sink.flush();
    }

    public final void writeMessageFrame(int formatOpcode, @NotNull ByteString data2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        if (this.writerClosed) {
            throw new IOException("closed");
        }
        this.messageBuffer.write(data2);
        int b0 = formatOpcode | 0x80;
        if (this.perMessageDeflate && (long)data2.size() >= this.minimumDeflateSize) {
            MessageDeflater messageDeflater = this.messageDeflater;
            if (messageDeflater == null) {
                MessageDeflater messageDeflater2;
                MessageDeflater it = messageDeflater2 = new MessageDeflater(this.noContextTakeover);
                boolean bl = false;
                this.messageDeflater = it;
                messageDeflater = messageDeflater2;
            }
            MessageDeflater messageDeflater3 = messageDeflater;
            messageDeflater3.deflate(this.messageBuffer);
            b0 |= 0x40;
        }
        long dataSize = this.messageBuffer.size();
        this.sinkBuffer.writeByte(b0);
        int b1 = 0;
        if (this.isClient) {
            b1 |= 0x80;
        }
        if (dataSize <= 125L) {
            this.sinkBuffer.writeByte(b1 |= (int)dataSize);
        } else if (dataSize <= 65535L) {
            this.sinkBuffer.writeByte(b1 |= 0x7E);
            this.sinkBuffer.writeShort((int)dataSize);
        } else {
            this.sinkBuffer.writeByte(b1 |= 0x7F);
            this.sinkBuffer.writeLong(dataSize);
        }
        if (this.isClient) {
            Intrinsics.checkNotNull((Object)this.maskKey);
            this.random.nextBytes(this.maskKey);
            this.sinkBuffer.write(this.maskKey);
            if (dataSize > 0L) {
                Buffer.UnsafeCursor unsafeCursor = this.maskCursor;
                Intrinsics.checkNotNull((Object)unsafeCursor);
                this.messageBuffer.readAndWriteUnsafe(unsafeCursor);
                this.maskCursor.seek(0L);
                WebSocketProtocol.INSTANCE.toggleMask(this.maskCursor, this.maskKey);
                this.maskCursor.close();
            }
        }
        this.sinkBuffer.write(this.messageBuffer, dataSize);
        this.sink.emit();
    }

    @Override
    public void close() {
        block0: {
            MessageDeflater messageDeflater = this.messageDeflater;
            if (messageDeflater == null) break block0;
            messageDeflater.close();
        }
    }
}

