/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.tls;

import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.internal.HostnamesKt;
import okhttp3.internal.Util;
import okio.Utf8;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nOkHostnameVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OkHostnameVerifier.kt\nokhttp3/internal/tls/OkHostnameVerifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,208:1\n1747#2,3:209\n1747#2,3:212\n*S KotlinDebug\n*F\n+ 1 OkHostnameVerifier.kt\nokhttp3/internal/tls/OkHostnameVerifier\n*L\n63#1:209,3\n71#1:212,3\n*E\n"})
public final class OkHostnameVerifier
implements HostnameVerifier {
    @NotNull
    public static final OkHostnameVerifier INSTANCE = new OkHostnameVerifier();
    private static final int ALT_DNS_NAME = 2;
    private static final int ALT_IPA_NAME = 7;

    private OkHostnameVerifier() {
    }

    @Override
    public boolean verify(@NotNull String host, @NotNull SSLSession session2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        if (!this.isAscii(host)) {
            bl = false;
        } else {
            boolean bl2;
            try {
                Certificate certificate2 = session2.getPeerCertificates()[0];
                Intrinsics.checkNotNull((Object)certificate2, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
                bl2 = this.verify(host, (X509Certificate)certificate2);
            }
            catch (SSLException _) {
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    public final boolean verify(@NotNull String host, @NotNull X509Certificate certificate2) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)certificate2, (String)"certificate");
        return Util.canParseAsIpAddress(host) ? this.verifyIpAddress(host, certificate2) : this.verifyHostname(host, certificate2);
    }

    private final boolean verifyIpAddress(String ipAddress, X509Certificate certificate2) {
        boolean bl;
        block3: {
            String canonicalIpAddress = HostnamesKt.toCanonicalHost(ipAddress);
            Iterable $this$any$iv = this.getSubjectAltNames(certificate2, 7);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)canonicalIpAddress, (Object)HostnamesKt.toCanonicalHost(it))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean verifyHostname(String hostname, X509Certificate certificate2) {
        boolean bl;
        block3: {
            String hostname2 = this.asciiToLowercase(hostname);
            Iterable $this$any$iv = this.getSubjectAltNames(certificate2, 2);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!INSTANCE.verifyHostname(hostname2, it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final String asciiToLowercase(String $this$asciiToLowercase) {
        String string;
        if (this.isAscii($this$asciiToLowercase)) {
            String string2 = $this$asciiToLowercase;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string3 = string2.toLowerCase(locale);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
        } else {
            string = $this$asciiToLowercase;
        }
        return string;
    }

    private final boolean isAscii(String $this$isAscii) {
        return $this$isAscii.length() == (int)Utf8.size$default((String)$this$isAscii, (int)0, (int)0, (int)3, null);
    }

    private final boolean verifyHostname(String hostname, String pattern) {
        String hostname2 = hostname;
        String pattern2 = pattern;
        CharSequence charSequence = hostname2;
        if (charSequence == null || charSequence.length() == 0 || StringsKt.startsWith$default((String)hostname2, (String)".", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)hostname2, (String)"..", (boolean)false, (int)2, null)) {
            return false;
        }
        charSequence = pattern2;
        if (charSequence == null || charSequence.length() == 0 || StringsKt.startsWith$default((String)pattern2, (String)".", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)pattern2, (String)"..", (boolean)false, (int)2, null)) {
            return false;
        }
        if (!StringsKt.endsWith$default((String)hostname2, (String)".", (boolean)false, (int)2, null)) {
            hostname2 = hostname2 + '.';
        }
        if (!StringsKt.endsWith$default((String)pattern2, (String)".", (boolean)false, (int)2, null)) {
            pattern2 = pattern2 + '.';
        }
        if (!StringsKt.contains$default((CharSequence)(pattern2 = this.asciiToLowercase(pattern2)), (CharSequence)"*", (boolean)false, (int)2, null)) {
            return Intrinsics.areEqual((Object)hostname2, (Object)pattern2);
        }
        if (!StringsKt.startsWith$default((String)pattern2, (String)"*.", (boolean)false, (int)2, null) || StringsKt.indexOf$default((CharSequence)pattern2, (char)'*', (int)1, (boolean)false, (int)4, null) != -1) {
            return false;
        }
        if (hostname2.length() < pattern2.length()) {
            return false;
        }
        if (Intrinsics.areEqual((Object)"*.", (Object)pattern2)) {
            return false;
        }
        String string = pattern2.substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        String suffix = string;
        if (!StringsKt.endsWith$default((String)hostname2, (String)suffix, (boolean)false, (int)2, null)) {
            return false;
        }
        int suffixStartIndexInHostname = hostname2.length() - suffix.length();
        return suffixStartIndexInHostname <= 0 || StringsKt.lastIndexOf$default((CharSequence)hostname2, (char)'.', (int)(suffixStartIndexInHostname - 1), (boolean)false, (int)4, null) == -1;
    }

    @NotNull
    public final List<String> allSubjectAltNames(@NotNull X509Certificate certificate2) {
        Intrinsics.checkNotNullParameter((Object)certificate2, (String)"certificate");
        List<String> altIpaNames = this.getSubjectAltNames(certificate2, 7);
        List<String> altDnsNames = this.getSubjectAltNames(certificate2, 2);
        return CollectionsKt.plus((Collection)altIpaNames, (Iterable)altDnsNames);
    }

    private final List<String> getSubjectAltNames(X509Certificate certificate2, int type2) {
        try {
            Collection<List<?>> collection = certificate2.getSubjectAlternativeNames();
            if (collection == null) {
                return CollectionsKt.emptyList();
            }
            Collection<List<?>> subjectAltNames = collection;
            List result2 = new ArrayList();
            for (List<?> subjectAltName : subjectAltNames) {
                Object altName;
                if (subjectAltName == null || subjectAltName.size() < 2 || !Intrinsics.areEqual(subjectAltName.get(0), (Object)type2) || subjectAltName.get(1) == null) continue;
                result2.add((String)altName);
            }
            return result2;
        }
        catch (CertificateParsingException _) {
            return CollectionsKt.emptyList();
        }
    }
}

