/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform.android;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import okhttp3.Protocol;
import okhttp3.internal.platform.AndroidPlatform;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.platform.android.DeferredSocketAdapter;
import okhttp3.internal.platform.android.SocketAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSocketAdapter
implements SocketAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Class<? super SSLSocket> sslSocketClass;
    @NotNull
    private final Method setUseSessionTickets;
    private final Method setHostname;
    private final Method getAlpnSelectedProtocol;
    private final Method setAlpnProtocols;
    @NotNull
    private static final DeferredSocketAdapter.Factory playProviderFactory = Companion.factory("com.google.android.gms.org.conscrypt");

    public AndroidSocketAdapter(@NotNull Class<? super SSLSocket> sslSocketClass) {
        Intrinsics.checkNotNullParameter(sslSocketClass, (String)"sslSocketClass");
        this.sslSocketClass = sslSocketClass;
        Class[] classArray = new Class[]{Boolean.TYPE};
        Method method = this.sslSocketClass.getDeclaredMethod("setUseSessionTickets", classArray);
        Intrinsics.checkNotNullExpressionValue((Object)method, (String)"sslSocketClass.getDeclar\u2026:class.javaPrimitiveType)");
        this.setUseSessionTickets = method;
        Class[] classArray2 = new Class[]{String.class};
        this.setHostname = this.sslSocketClass.getMethod("setHostname", classArray2);
        this.getAlpnSelectedProtocol = this.sslSocketClass.getMethod("getAlpnSelectedProtocol", new Class[0]);
        classArray2 = new Class[]{byte[].class};
        this.setAlpnProtocols = this.sslSocketClass.getMethod("setAlpnProtocols", classArray2);
    }

    @Override
    public boolean isSupported() {
        return AndroidPlatform.Companion.isSupported();
    }

    @Override
    public boolean matchesSocket(@NotNull SSLSocket sslSocket) {
        Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
        return this.sslSocketClass.isInstance(sslSocket);
    }

    @Override
    public void configureTlsExtensions(@NotNull SSLSocket sslSocket, @Nullable String hostname, @NotNull List<? extends Protocol> protocols) {
        Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
        Intrinsics.checkNotNullParameter(protocols, (String)"protocols");
        if (this.matchesSocket(sslSocket)) {
            try {
                Object[] objectArray = new Object[]{true};
                this.setUseSessionTickets.invoke((Object)sslSocket, objectArray);
                if (hostname != null) {
                    objectArray = new Object[]{hostname};
                    this.setHostname.invoke((Object)sslSocket, objectArray);
                }
                objectArray = new Object[]{Platform.Companion.concatLengthPrefixed(protocols)};
                this.setAlpnProtocols.invoke((Object)sslSocket, objectArray);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (InvocationTargetException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    @Override
    @Nullable
    public String getSelectedProtocol(@NotNull SSLSocket sslSocket) {
        String string;
        Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
        if (!this.matchesSocket(sslSocket)) {
            return null;
        }
        try {
            byte[] alpnResult = (byte[])this.getAlpnSelectedProtocol.invoke((Object)sslSocket, new Object[0]);
            string = alpnResult != null ? new String(alpnResult, Charsets.UTF_8) : null;
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (!(cause instanceof NullPointerException) || !Intrinsics.areEqual((Object)((NullPointerException)cause).getMessage(), (Object)"ssl == null")) {
                throw new AssertionError((Object)e);
            }
            string = null;
        }
        return string;
    }

    @Override
    @Nullable
    public X509TrustManager trustManager(@NotNull SSLSocketFactory sslSocketFactory) {
        return SocketAdapter.DefaultImpls.trustManager(this, sslSocketFactory);
    }

    @Override
    public boolean matchesSocketFactory(@NotNull SSLSocketFactory sslSocketFactory) {
        return SocketAdapter.DefaultImpls.matchesSocketFactory(this, sslSocketFactory);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DeferredSocketAdapter.Factory getPlayProviderFactory() {
            return playProviderFactory;
        }

        private final AndroidSocketAdapter build(Class<? super SSLSocket> actualSSLSocketClass) {
            Class<? super SSLSocket> possibleClass = actualSSLSocketClass;
            while (possibleClass != null && !Intrinsics.areEqual((Object)possibleClass.getSimpleName(), (Object)"OpenSSLSocketImpl")) {
                if ((possibleClass = possibleClass.getSuperclass()) == null) {
                    throw new AssertionError((Object)("No OpenSSLSocketImpl superclass of socket of type " + actualSSLSocketClass));
                }
            }
            Class<? super SSLSocket> clazz = possibleClass;
            Intrinsics.checkNotNull(clazz);
            return new AndroidSocketAdapter(clazz);
        }

        @NotNull
        public final DeferredSocketAdapter.Factory factory(@NotNull String packageName) {
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            return new DeferredSocketAdapter.Factory(packageName){
                final /* synthetic */ String $packageName;
                {
                    this.$packageName = $packageName;
                }

                public boolean matchesSocket(@NotNull SSLSocket sslSocket) {
                    Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
                    String string = sslSocket.getClass().getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sslSocket.javaClass.name");
                    return StringsKt.startsWith$default((String)string, (String)(this.$packageName + '.'), (boolean)false, (int)2, null);
                }

                @NotNull
                public SocketAdapter create(@NotNull SSLSocket sslSocket) {
                    Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
                    return okhttp3.internal.platform.android.AndroidSocketAdapter$Companion.access$build(AndroidSocketAdapter.Companion, sslSocket.getClass());
                }
            };
        }

        public static final /* synthetic */ AndroidSocketAdapter access$build(Companion $this, Class actualSSLSocketClass) {
            return $this.build(actualSSLSocketClass);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

