/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform.android;

import android.annotation.SuppressLint;
import android.net.ssl.SSLSockets;
import android.os.Build;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Protocol;
import okhttp3.internal.SuppressSignatureCheck;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.platform.android.SocketAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SuppressLint(value={"NewApi"})
@SuppressSignatureCheck
@SourceDebugExtension(value={"SMAP\nAndroid10SocketAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Android10SocketAdapter.kt\nokhttp3/internal/platform/android/Android10SocketAdapter\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,77:1\n37#2,2:78\n*S KotlinDebug\n*F\n+ 1 Android10SocketAdapter.kt\nokhttp3/internal/platform/android/Android10SocketAdapter\n*L\n60#1:78,2\n*E\n"})
public final class Android10SocketAdapter
implements SocketAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean matchesSocket(@NotNull SSLSocket sslSocket) {
        Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
        return SSLSockets.isSupportedSocket((SSLSocket)sslSocket);
    }

    @Override
    public boolean isSupported() {
        return Companion.isSupported();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @SuppressLint(value={"NewApi"})
    @Nullable
    public String getSelectedProtocol(@NotNull SSLSocket sslSocket) {
        void var2_2;
        String protocol;
        Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
        String string = protocol = sslSocket.getApplicationProtocol();
        return (string == null ? true : Intrinsics.areEqual((Object)string, (Object)"")) ? null : var2_2;
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void configureTlsExtensions(@NotNull SSLSocket sslSocket, @Nullable String hostname, @NotNull List<? extends Protocol> protocols) {
        Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
        Intrinsics.checkNotNullParameter(protocols, (String)"protocols");
        try {
            SSLSockets.setUseSessionTickets((SSLSocket)sslSocket, (boolean)true);
            SSLParameters sslParameters = sslSocket.getSSLParameters();
            Collection $this$toTypedArray$iv = Platform.Companion.alpnProtocolNames(protocols);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            sslParameters.setApplicationProtocols(thisCollection$iv.toArray(new String[0]));
            sslSocket.setSSLParameters(sslParameters);
        }
        catch (IllegalArgumentException iae) {
            throw new IOException("Android internal error", iae);
        }
    }

    @Override
    @Nullable
    public X509TrustManager trustManager(@NotNull SSLSocketFactory sslSocketFactory) {
        return SocketAdapter.DefaultImpls.trustManager(this, sslSocketFactory);
    }

    @Override
    public boolean matchesSocketFactory(@NotNull SSLSocketFactory sslSocketFactory) {
        return SocketAdapter.DefaultImpls.matchesSocketFactory(this, sslSocketFactory);
    }

    @SuppressSignatureCheck
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final SocketAdapter buildIfSupported() {
            return this.isSupported() ? (SocketAdapter)new Android10SocketAdapter() : null;
        }

        public final boolean isSupported() {
            return Platform.Companion.isAndroid() && Build.VERSION.SDK_INT >= 29;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

