/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.Protocol;
import okhttp3.internal.SuppressSignatureCheck;
import okhttp3.internal.platform.Platform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nJdk9Platform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Jdk9Platform.kt\nokhttp3/internal/platform/Jdk9Platform\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,89:1\n37#2,2:90\n*S KotlinDebug\n*F\n+ 1 Jdk9Platform.kt\nokhttp3/internal/platform/Jdk9Platform\n*L\n36#1:90,2\n*E\n"})
public class Jdk9Platform
extends Platform {
    @NotNull
    public static final Companion Companion;
    private static final boolean isAvailable;

    @Override
    @SuppressSignatureCheck
    public void configureTlsExtensions(@NotNull SSLSocket sslSocket, @Nullable String hostname, @NotNull List<Protocol> protocols) {
        Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
        Intrinsics.checkNotNullParameter(protocols, (String)"protocols");
        SSLParameters sslParameters = sslSocket.getSSLParameters();
        List<String> names = Platform.Companion.alpnProtocolNames(protocols);
        Collection $this$toTypedArray$iv = names;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        sslParameters.setApplicationProtocols(thisCollection$iv.toArray(new String[0]));
        sslSocket.setSSLParameters(sslParameters);
    }

    @Override
    @SuppressSignatureCheck
    @Nullable
    public String getSelectedProtocol(@NotNull SSLSocket sslSocket) {
        Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
        try {
            String protocol;
            String string = protocol = sslSocket.getApplicationProtocol();
            return (string == null ? true : Intrinsics.areEqual((Object)string, (Object)"")) ? null : protocol;
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    @Override
    @Nullable
    public X509TrustManager trustManager(@NotNull SSLSocketFactory sslSocketFactory) {
        Intrinsics.checkNotNullParameter((Object)sslSocketFactory, (String)"sslSocketFactory");
        throw new UnsupportedOperationException("clientBuilder.sslSocketFactory(SSLSocketFactory) not supported on JDK 9+");
    }

    static {
        boolean bl;
        Integer majorVersion;
        String jdkVersion;
        Companion = new Companion(null);
        String string = jdkVersion = System.getProperty("java.specification.version");
        Integer n = majorVersion = string != null ? StringsKt.toIntOrNull((String)string) : null;
        if (majorVersion != null) {
            bl = majorVersion >= 9;
        } else {
            boolean bl2;
            try {
                SSLSocket.class.getMethod("getApplicationProtocol", new Class[0]);
                bl2 = true;
            }
            catch (NoSuchMethodException nsme) {
                bl2 = false;
            }
            bl = bl2;
        }
        isAvailable = bl;
    }

    public static final class Companion {
        private Companion() {
        }

        public final boolean isAvailable() {
            return isAvailable;
        }

        @Nullable
        public final Jdk9Platform buildIfSupported() {
            return this.isAvailable() ? new Jdk9Platform() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

