/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLSocket;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Protocol;
import okhttp3.internal.platform.Platform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Jdk8WithJettyBootPlatform
extends Platform {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Method putMethod;
    @NotNull
    private final Method getMethod;
    @NotNull
    private final Method removeMethod;
    @NotNull
    private final Class<?> clientProviderClass;
    @NotNull
    private final Class<?> serverProviderClass;

    public Jdk8WithJettyBootPlatform(@NotNull Method putMethod, @NotNull Method getMethod, @NotNull Method removeMethod, @NotNull Class<?> clientProviderClass, @NotNull Class<?> serverProviderClass) {
        Intrinsics.checkNotNullParameter((Object)putMethod, (String)"putMethod");
        Intrinsics.checkNotNullParameter((Object)getMethod, (String)"getMethod");
        Intrinsics.checkNotNullParameter((Object)removeMethod, (String)"removeMethod");
        Intrinsics.checkNotNullParameter(clientProviderClass, (String)"clientProviderClass");
        Intrinsics.checkNotNullParameter(serverProviderClass, (String)"serverProviderClass");
        this.putMethod = putMethod;
        this.getMethod = getMethod;
        this.removeMethod = removeMethod;
        this.clientProviderClass = clientProviderClass;
        this.serverProviderClass = serverProviderClass;
    }

    public void configureTlsExtensions(@NotNull SSLSocket sslSocket, @Nullable String hostname, @NotNull List<? extends Protocol> protocols) {
        Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
        Intrinsics.checkNotNullParameter(protocols, (String)"protocols");
        List<String> names = Platform.Companion.alpnProtocolNames(protocols);
        try {
            Object[] objectArray = new Class[]{this.clientProviderClass, this.serverProviderClass};
            Object alpnProvider = Proxy.newProxyInstance(Platform.class.getClassLoader(), objectArray, (InvocationHandler)new AlpnProvider(names));
            objectArray = new Object[]{sslSocket, alpnProvider};
            this.putMethod.invoke(null, objectArray);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError("failed to set ALPN", e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError("failed to set ALPN", e);
        }
    }

    @Override
    public void afterHandshake(@NotNull SSLSocket sslSocket) {
        Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
        try {
            Object[] objectArray = new Object[]{sslSocket};
            this.removeMethod.invoke(null, objectArray);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError("failed to remove ALPN", e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError("failed to remove ALPN", e);
        }
    }

    @Override
    @Nullable
    public String getSelectedProtocol(@NotNull SSLSocket sslSocket) {
        Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
        try {
            Object[] objectArray = new Object[]{sslSocket};
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(this.getMethod.invoke(null, objectArray));
            Intrinsics.checkNotNull((Object)invocationHandler, (String)"null cannot be cast to non-null type okhttp3.internal.platform.Jdk8WithJettyBootPlatform.AlpnProvider");
            AlpnProvider provider2 = (AlpnProvider)invocationHandler;
            if (!provider2.getUnsupported() && provider2.getSelected() == null) {
                Platform.log$default(this, "ALPN callback dropped: HTTP/2 is disabled. Is alpn-boot on the boot class path?", 0, null, 6, null);
                return null;
            }
            return provider2.getUnsupported() ? null : provider2.getSelected();
        }
        catch (InvocationTargetException e) {
            throw new AssertionError("failed to get ALPN selected protocol", e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError("failed to get ALPN selected protocol", e);
        }
    }

    private static final class AlpnProvider
    implements InvocationHandler {
        @NotNull
        private final List<String> protocols;
        private boolean unsupported;
        @Nullable
        private String selected;

        public AlpnProvider(@NotNull List<String> protocols) {
            Intrinsics.checkNotNullParameter(protocols, (String)"protocols");
            this.protocols = protocols;
        }

        public final boolean getUnsupported() {
            return this.unsupported;
        }

        public final void setUnsupported(boolean bl) {
            this.unsupported = bl;
        }

        @Nullable
        public final String getSelected() {
            return this.selected;
        }

        public final void setSelected(@Nullable String string) {
            this.selected = string;
        }

        @Override
        @Nullable
        public Object invoke(@NotNull Object proxy, @NotNull Method method, @Nullable Object[] args) throws Throwable {
            Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Object[] objectArray = args;
            if (args == null) {
                objectArray = new Object[]{};
            }
            Object[] callArgs = objectArray;
            String methodName = method.getName();
            Class<?> returnType = method.getReturnType();
            if (Intrinsics.areEqual((Object)methodName, (Object)"supports") && Intrinsics.areEqual(Boolean.TYPE, returnType)) {
                return true;
            }
            if (Intrinsics.areEqual((Object)methodName, (Object)"unsupported") && Intrinsics.areEqual(Void.TYPE, returnType)) {
                this.unsupported = true;
                return null;
            }
            if (Intrinsics.areEqual((Object)methodName, (Object)"protocols") && callArgs.length == 0) {
                return this.protocols;
            }
            if ((Intrinsics.areEqual((Object)methodName, (Object)"selectProtocol") || Intrinsics.areEqual((Object)methodName, (Object)"select")) && Intrinsics.areEqual(String.class, returnType) && callArgs.length == 1 && callArgs[0] instanceof List) {
                Object object = callArgs[0];
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
                List peerProtocols = (List)object;
                int i2 = 0;
                int n = peerProtocols.size();
                if (i2 <= n) {
                    while (true) {
                        Object e = peerProtocols.get(i2);
                        Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.String");
                        String protocol = (String)e;
                        if (this.protocols.contains(protocol)) {
                            this.selected = protocol;
                            return this.selected;
                        }
                        if (i2 == n) break;
                        ++i2;
                    }
                }
                this.selected = this.protocols.get(0);
                return this.selected;
            }
            if ((Intrinsics.areEqual((Object)methodName, (Object)"protocolSelected") || Intrinsics.areEqual((Object)methodName, (Object)"selected")) && callArgs.length == 1) {
                Object object = callArgs[0];
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                this.selected = (String)object;
                return null;
            }
            return method.invoke((Object)this, Arrays.copyOf(callArgs, callArgs.length));
        }
    }

    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Platform buildIfSupported() {
            String jvmVersion = System.getProperty("java.specification.version", "unknown");
            try {
                Intrinsics.checkNotNullExpressionValue((Object)jvmVersion, (String)"jvmVersion");
                int version = Integer.parseInt(jvmVersion);
                if (version >= 9) {
                    return null;
                }
            }
            catch (NumberFormatException version) {
                // empty catch block
            }
            try {
                String alpnClassName = "org.eclipse.jetty.alpn.ALPN";
                Class<?> alpnClass = Class.forName(alpnClassName, true, null);
                Class<?> providerClass = Class.forName(alpnClassName + "$Provider", true, null);
                Class<?> clientProviderClass = Class.forName(alpnClassName + "$ClientProvider", true, null);
                Class<?> serverProviderClass = Class.forName(alpnClassName + "$ServerProvider", true, null);
                Class[] classArray = new Class[]{SSLSocket.class, providerClass};
                Method putMethod = alpnClass.getMethod("put", classArray);
                Class[] classArray2 = new Class[]{SSLSocket.class};
                Method getMethod = alpnClass.getMethod("get", classArray2);
                Class[] classArray3 = new Class[]{SSLSocket.class};
                Method removeMethod = alpnClass.getMethod("remove", classArray3);
                Intrinsics.checkNotNullExpressionValue((Object)putMethod, (String)"putMethod");
                Intrinsics.checkNotNullExpressionValue((Object)getMethod, (String)"getMethod");
                Intrinsics.checkNotNullExpressionValue((Object)removeMethod, (String)"removeMethod");
                Intrinsics.checkNotNullExpressionValue(clientProviderClass, (String)"clientProviderClass");
                Intrinsics.checkNotNullExpressionValue(serverProviderClass, (String)"serverProviderClass");
                return new Jdk8WithJettyBootPlatform(putMethod, getMethod, removeMethod, clientProviderClass, serverProviderClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

