/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.concurrent;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.concurrent.Task;
import okhttp3.internal.concurrent.TaskQueue;
import okhttp3.internal.concurrent.TaskRunner;
import org.jetbrains.annotations.NotNull;

public final class TaskLoggerKt {
    public static final void taskLog(@NotNull Task task, @NotNull TaskQueue queue, @NotNull Function0<String> messageBlock) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter(messageBlock, (String)"messageBlock");
        boolean $i$f$taskLog = false;
        if (TaskRunner.Companion.getLogger().isLoggable(Level.FINE)) {
            TaskLoggerKt.log(task, queue, (String)messageBlock.invoke());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T logElapsed(@NotNull Task task, @NotNull TaskQueue queue, @NotNull Function0<? extends T> block) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$logElapsed = false;
        long startNs = -1L;
        boolean loggingEnabled = TaskRunner.Companion.getLogger().isLoggable(Level.FINE);
        if (loggingEnabled) {
            startNs = queue.getTaskRunner$okhttp().getBackend().nanoTime();
            TaskLoggerKt.log(task, queue, "starting");
        }
        boolean completedNormally = false;
        try {
            Object result2 = block.invoke();
            completedNormally = true;
            object = result2;
        }
        catch (Throwable throwable) {
            InlineMarker.finallyStart((int)1);
            if (loggingEnabled) {
                long elapsedNs = queue.getTaskRunner$okhttp().getBackend().nanoTime() - startNs;
                if (completedNormally) {
                    TaskLoggerKt.log(task, queue, "finished run in " + TaskLoggerKt.formatDuration(elapsedNs));
                } else {
                    TaskLoggerKt.log(task, queue, "failed a run in " + TaskLoggerKt.formatDuration(elapsedNs));
                }
            }
            InlineMarker.finallyEnd((int)1);
            throw throwable;
        }
        InlineMarker.finallyStart((int)1);
        if (loggingEnabled) {
            long elapsedNs = queue.getTaskRunner$okhttp().getBackend().nanoTime() - startNs;
            TaskLoggerKt.log(task, queue, "finished run in " + TaskLoggerKt.formatDuration(elapsedNs));
        }
        InlineMarker.finallyEnd((int)1);
        return (T)object;
    }

    private static final void log(Task task, TaskQueue queue, String message2) {
        Logger logger = TaskRunner.Companion.getLogger();
        StringBuilder stringBuilder = new StringBuilder().append(queue.getName$okhttp()).append(' ');
        String string = "%-22s";
        Object[] objectArray = new Object[]{message2};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        logger.fine(stringBuilder.append(string2).append(": ").append(task.getName()).toString());
    }

    @NotNull
    public static final String formatDuration(long ns) {
        String s = ns <= -999500000L ? (ns - (long)500000000) / (long)1000000000 + " s " : (ns <= -999500L ? (ns - (long)500000) / (long)1000000 + " ms" : (ns <= 0L ? (ns - (long)500) / (long)1000 + " \u00b5s" : (ns < 999500L ? (ns + (long)500) / (long)1000 + " \u00b5s" : (ns < 999500000L ? (ns + (long)500000) / (long)1000000 + " ms" : (ns + (long)500000000) / (long)1000000000 + " s "))));
        String string = "%6s";
        Object[] objectArray = new Object[]{s};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }
}

