/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.cache;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Cache;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import okhttp3.internal.cache.CacheRequest;
import okhttp3.internal.cache.CacheStrategy;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http.HttpMethod;
import okhttp3.internal.http.RealResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CacheInterceptor
implements Interceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Cache cache;

    public CacheInterceptor(@Nullable Cache cache2) {
        this.cache = cache2;
    }

    @Nullable
    public final Cache getCache$okhttp() {
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Response networkResponse;
        Object listener;
        Response cacheResponse;
        Request networkRequest;
        Call call2;
        block23: {
            ResponseBody responseBody;
            Object object;
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            call2 = chain.call();
            Cache cache2 = this.cache;
            Response cacheCandidate = cache2 != null ? cache2.get$okhttp(chain.request()) : null;
            long now2 = System.currentTimeMillis();
            CacheStrategy strategy = new CacheStrategy.Factory(now2, chain.request(), cacheCandidate).compute();
            networkRequest = strategy.getNetworkRequest();
            cacheResponse = strategy.getCacheResponse();
            Cache cache3 = this.cache;
            if (cache3 != null) {
                cache3.trackResponse$okhttp(strategy);
            }
            if ((object = call2 instanceof RealCall ? (RealCall)call2 : null) == null || (object = ((RealCall)object).getEventListener$okhttp()) == null) {
                object = listener = EventListener.NONE;
            }
            if (cacheCandidate != null && cacheResponse == null) {
                ResponseBody responseBody2 = cacheCandidate.body();
                if (responseBody2 != null) {
                    Util.closeQuietly(responseBody2);
                }
            }
            if (networkRequest == null && cacheResponse == null) {
                Response response2;
                Response it = response2 = new Response.Builder().request(chain.request()).protocol(Protocol.HTTP_1_1).code(504).message("Unsatisfiable Request (only-if-cached)").body(Util.EMPTY_RESPONSE).sentRequestAtMillis(-1L).receivedResponseAtMillis(System.currentTimeMillis()).build();
                boolean bl = false;
                ((EventListener)listener).satisfactionFailure(call2, it);
                return response2;
            }
            if (networkRequest == null) {
                Response response3;
                Response response4 = cacheResponse;
                Intrinsics.checkNotNull((Object)response4);
                Response it = response3 = response4.newBuilder().cacheResponse(CacheInterceptor.Companion.stripBody(cacheResponse)).build();
                boolean bl2 = false;
                ((EventListener)listener).cacheHit(call2, it);
                return response3;
            }
            if (cacheResponse != null) {
                ((EventListener)listener).cacheConditionalHit(call2, cacheResponse);
            } else if (this.cache != null) {
                ((EventListener)listener).cacheMiss(call2);
            }
            networkResponse = null;
            try {
                networkResponse = chain.proceed(networkRequest);
                if (networkResponse != null || cacheCandidate == null) break block23;
                responseBody = cacheCandidate.body();
            }
            catch (Throwable it) {
                if (cacheCandidate != null) {
                    ResponseBody responseBody3 = cacheCandidate.body();
                    if (responseBody3 != null) {
                        Util.closeQuietly(responseBody3);
                    }
                }
                throw it;
            }
            if (responseBody != null) {
                Util.closeQuietly(responseBody);
            }
        }
        if (cacheResponse != null) {
            Response response5 = networkResponse;
            boolean bl = response5 != null ? response5.code() == 304 : false;
            if (bl) {
                Response bl2;
                Response response6 = cacheResponse.newBuilder().headers(CacheInterceptor.Companion.combine(cacheResponse.headers(), networkResponse.headers())).sentRequestAtMillis(networkResponse.sentRequestAtMillis()).receivedResponseAtMillis(networkResponse.receivedResponseAtMillis()).cacheResponse(CacheInterceptor.Companion.stripBody(cacheResponse)).networkResponse(CacheInterceptor.Companion.stripBody(networkResponse)).build();
                ResponseBody responseBody = networkResponse.body();
                Intrinsics.checkNotNull((Object)responseBody);
                responseBody.close();
                Cache cache4 = this.cache;
                Intrinsics.checkNotNull((Object)cache4);
                cache4.trackConditionalCacheHit$okhttp();
                this.cache.update$okhttp(cacheResponse, response6);
                Response it = bl2 = response6;
                boolean bl3 = false;
                ((EventListener)listener).cacheHit(call2, it);
                return bl2;
            }
            ResponseBody responseBody = cacheResponse.body();
            if (responseBody != null) {
                Util.closeQuietly(responseBody);
            }
        }
        Response response7 = networkResponse;
        Intrinsics.checkNotNull((Object)response7);
        Response response8 = response7.newBuilder().cacheResponse(CacheInterceptor.Companion.stripBody(cacheResponse)).networkResponse(CacheInterceptor.Companion.stripBody(networkResponse)).build();
        if (this.cache != null) {
            if (HttpHeaders.promisesBody(response8) && CacheStrategy.Companion.isCacheable(response8, networkRequest)) {
                Response response9;
                CacheRequest cacheRequest2 = this.cache.put$okhttp(response8);
                Response it = response9 = this.cacheWritingResponse(cacheRequest2, response8);
                boolean bl = false;
                if (cacheResponse != null) {
                    ((EventListener)listener).cacheMiss(call2);
                }
                return response9;
            }
            if (HttpMethod.INSTANCE.invalidatesCache(networkRequest.method())) {
                try {
                    this.cache.remove$okhttp(networkRequest);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return response8;
    }

    private final Response cacheWritingResponse(CacheRequest cacheRequest2, Response response2) throws IOException {
        if (cacheRequest2 == null) {
            return response2;
        }
        Sink cacheBodyUnbuffered = cacheRequest2.body();
        ResponseBody responseBody = response2.body();
        Intrinsics.checkNotNull((Object)responseBody);
        BufferedSource source = responseBody.source();
        BufferedSink cacheBody = Okio.buffer((Sink)cacheBodyUnbuffered);
        Source cacheWritingSource2 = new Source(source, cacheRequest2, cacheBody){
            private boolean cacheRequestClosed;
            final /* synthetic */ BufferedSource $source;
            final /* synthetic */ CacheRequest $cacheRequest;
            final /* synthetic */ BufferedSink $cacheBody;
            {
                this.$source = $source;
                this.$cacheRequest = $cacheRequest;
                this.$cacheBody = $cacheBody;
            }

            public long read(@NotNull Buffer sink, long byteCount) throws IOException {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                long bytesRead = 0L;
                try {
                    bytesRead = this.$source.read(sink, byteCount);
                }
                catch (IOException e) {
                    if (!this.cacheRequestClosed) {
                        this.cacheRequestClosed = true;
                        this.$cacheRequest.abort();
                    }
                    throw e;
                }
                if (bytesRead == -1L) {
                    if (!this.cacheRequestClosed) {
                        this.cacheRequestClosed = true;
                        this.$cacheBody.close();
                    }
                    return -1L;
                }
                sink.copyTo(this.$cacheBody.getBuffer(), sink.size() - bytesRead, bytesRead);
                this.$cacheBody.emitCompleteSegments();
                return bytesRead;
            }

            @NotNull
            public Timeout timeout() {
                return this.$source.timeout();
            }

            public void close() throws IOException {
                if (!this.cacheRequestClosed && !Util.discard(this, 100, TimeUnit.MILLISECONDS)) {
                    this.cacheRequestClosed = true;
                    this.$cacheRequest.abort();
                }
                this.$source.close();
            }
        };
        String contentType = Response.header$default(response2, "Content-Type", null, 2, null);
        long contentLength = response2.body().contentLength();
        return response2.newBuilder().body(new RealResponseBody(contentType, contentLength, Okio.buffer((Source)cacheWritingSource2))).build();
    }

    public static final class Companion {
        private Companion() {
        }

        private final Response stripBody(Response response2) {
            Response response3 = response2;
            return (response3 != null ? response3.body() : null) != null ? response2.newBuilder().body(null).build() : response2;
        }

        private final Headers combine(Headers cachedHeaders, Headers networkHeaders) {
            String fieldName;
            int index;
            Headers.Builder result2 = new Headers.Builder();
            int n = cachedHeaders.size();
            for (index = 0; index < n; ++index) {
                fieldName = cachedHeaders.name(index);
                String value2 = cachedHeaders.value(index);
                if (StringsKt.equals((String)"Warning", (String)fieldName, (boolean)true) && StringsKt.startsWith$default((String)value2, (String)"1", (boolean)false, (int)2, null) || !this.isContentSpecificHeader(fieldName) && this.isEndToEnd(fieldName) && networkHeaders.get(fieldName) != null) continue;
                result2.addLenient$okhttp(fieldName, value2);
            }
            n = networkHeaders.size();
            for (index = 0; index < n; ++index) {
                fieldName = networkHeaders.name(index);
                if (this.isContentSpecificHeader(fieldName) || !this.isEndToEnd(fieldName)) continue;
                result2.addLenient$okhttp(fieldName, networkHeaders.value(index));
            }
            return result2.build();
        }

        private final boolean isEndToEnd(String fieldName) {
            return !StringsKt.equals((String)"Connection", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Keep-Alive", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Proxy-Authenticate", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Proxy-Authorization", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"TE", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Trailers", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Transfer-Encoding", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Upgrade", (String)fieldName, (boolean)true);
        }

        private final boolean isContentSpecificHeader(String fieldName) {
            return StringsKt.equals((String)"Content-Length", (String)fieldName, (boolean)true) || StringsKt.equals((String)"Content-Encoding", (String)fieldName, (boolean)true) || StringsKt.equals((String)"Content-Type", (String)fieldName, (boolean)true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

