/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.CacheControl;
import okhttp3.Challenge;
import okhttp3.Handshake;
import okhttp3.Headers;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.ResponseBody;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.http.HttpHeaders;
import okio.Buffer;
import okio.BufferedSource;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nResponse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Response.kt\nokhttp3/Response\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,455:1\n1#2:456\n*E\n"})
public final class Response
implements Closeable {
    @NotNull
    private final Request request;
    @NotNull
    private final Protocol protocol;
    @NotNull
    private final String message;
    private final int code;
    @Nullable
    private final Handshake handshake;
    @NotNull
    private final Headers headers;
    @Nullable
    private final ResponseBody body;
    @Nullable
    private final Response networkResponse;
    @Nullable
    private final Response cacheResponse;
    @Nullable
    private final Response priorResponse;
    private final long sentRequestAtMillis;
    private final long receivedResponseAtMillis;
    @Nullable
    private final Exchange exchange;
    @Nullable
    private CacheControl lazyCacheControl;

    public Response(@NotNull Request request2, @NotNull Protocol protocol, @NotNull String message2, int code, @Nullable Handshake handshake2, @NotNull Headers headers2, @Nullable ResponseBody body, @Nullable Response networkResponse, @Nullable Response cacheResponse, @Nullable Response priorResponse, long sentRequestAtMillis, long receivedResponseAtMillis, @Nullable Exchange exchange) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter((Object)((Object)protocol), (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)headers2, (String)"headers");
        this.request = request2;
        this.protocol = protocol;
        this.message = message2;
        this.code = code;
        this.handshake = handshake2;
        this.headers = headers2;
        this.body = body;
        this.networkResponse = networkResponse;
        this.cacheResponse = cacheResponse;
        this.priorResponse = priorResponse;
        this.sentRequestAtMillis = sentRequestAtMillis;
        this.receivedResponseAtMillis = receivedResponseAtMillis;
        this.exchange = exchange;
    }

    @JvmName(name="request")
    @NotNull
    public final Request request() {
        return this.request;
    }

    @JvmName(name="protocol")
    @NotNull
    public final Protocol protocol() {
        return this.protocol;
    }

    @JvmName(name="message")
    @NotNull
    public final String message() {
        return this.message;
    }

    @JvmName(name="code")
    public final int code() {
        return this.code;
    }

    @JvmName(name="handshake")
    @Nullable
    public final Handshake handshake() {
        return this.handshake;
    }

    @JvmName(name="headers")
    @NotNull
    public final Headers headers() {
        return this.headers;
    }

    @JvmName(name="body")
    @Nullable
    public final ResponseBody body() {
        return this.body;
    }

    @JvmName(name="networkResponse")
    @Nullable
    public final Response networkResponse() {
        return this.networkResponse;
    }

    @JvmName(name="cacheResponse")
    @Nullable
    public final Response cacheResponse() {
        return this.cacheResponse;
    }

    @JvmName(name="priorResponse")
    @Nullable
    public final Response priorResponse() {
        return this.priorResponse;
    }

    @JvmName(name="sentRequestAtMillis")
    public final long sentRequestAtMillis() {
        return this.sentRequestAtMillis;
    }

    @JvmName(name="receivedResponseAtMillis")
    public final long receivedResponseAtMillis() {
        return this.receivedResponseAtMillis;
    }

    @JvmName(name="exchange")
    @Nullable
    public final Exchange exchange() {
        return this.exchange;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="request", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_request")
    @NotNull
    public final Request -deprecated_request() {
        return this.request;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="protocol", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_protocol")
    @NotNull
    public final Protocol -deprecated_protocol() {
        return this.protocol;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="code", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_code")
    public final int -deprecated_code() {
        return this.code;
    }

    public final boolean isSuccessful() {
        int n = this.code;
        return 200 <= n ? n < 300 : false;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="message", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_message")
    @NotNull
    public final String -deprecated_message() {
        return this.message;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="handshake", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_handshake")
    @Nullable
    public final Handshake -deprecated_handshake() {
        return this.handshake;
    }

    @NotNull
    public final List<String> headers(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.headers.values(name2);
    }

    @JvmOverloads
    @Nullable
    public final String header(@NotNull String name2, @Nullable String defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        String string = this.headers.get(name2);
        if (string == null) {
            string = defaultValue;
        }
        return string;
    }

    public static /* synthetic */ String header$default(Response response2, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return response2.header(string, string2);
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="headers", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_headers")
    @NotNull
    public final Headers -deprecated_headers() {
        return this.headers;
    }

    @NotNull
    public final Headers trailers() throws IOException {
        Exchange exchange = this.exchange;
        if (exchange == null) {
            boolean bl = false;
            String string = "trailers not available";
            throw new IllegalStateException(string.toString());
        }
        return exchange.trailers();
    }

    @NotNull
    public final ResponseBody peekBody(long byteCount) throws IOException {
        ResponseBody responseBody = this.body;
        Intrinsics.checkNotNull((Object)responseBody);
        BufferedSource peeked = responseBody.source().peek();
        Buffer buffer = new Buffer();
        peeked.request(byteCount);
        buffer.write((Source)peeked, Math.min(byteCount, peeked.getBuffer().size()));
        return ResponseBody.Companion.create((BufferedSource)buffer, this.body.contentType(), buffer.size());
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="body", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_body")
    @Nullable
    public final ResponseBody -deprecated_body() {
        return this.body;
    }

    @NotNull
    public final Builder newBuilder() {
        return new Builder(this);
    }

    public final boolean isRedirect() {
        boolean bl;
        switch (this.code) {
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="networkResponse", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_networkResponse")
    @Nullable
    public final Response -deprecated_networkResponse() {
        return this.networkResponse;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="cacheResponse", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_cacheResponse")
    @Nullable
    public final Response -deprecated_cacheResponse() {
        return this.cacheResponse;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="priorResponse", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_priorResponse")
    @Nullable
    public final Response -deprecated_priorResponse() {
        return this.priorResponse;
    }

    @NotNull
    public final List<Challenge> challenges() {
        String string;
        switch (this.code) {
            case 401: {
                string = "WWW-Authenticate";
                break;
            }
            case 407: {
                string = "Proxy-Authenticate";
                break;
            }
            default: {
                return CollectionsKt.emptyList();
            }
        }
        return HttpHeaders.parseChallenges(this.headers, string);
    }

    @JvmName(name="cacheControl")
    @NotNull
    public final CacheControl cacheControl() {
        CacheControl result2 = this.lazyCacheControl;
        if (result2 == null) {
            this.lazyCacheControl = result2 = CacheControl.Companion.parse(this.headers);
        }
        return result2;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="cacheControl", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_cacheControl")
    @NotNull
    public final CacheControl -deprecated_cacheControl() {
        return this.cacheControl();
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="sentRequestAtMillis", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_sentRequestAtMillis")
    public final long -deprecated_sentRequestAtMillis() {
        return this.sentRequestAtMillis;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="receivedResponseAtMillis", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_receivedResponseAtMillis")
    public final long -deprecated_receivedResponseAtMillis() {
        return this.receivedResponseAtMillis;
    }

    @Override
    public void close() {
        ResponseBody responseBody = this.body;
        if (responseBody == null) {
            boolean bl = false;
            String string = "response is not eligible for a body and must not be closed";
            throw new IllegalStateException(string.toString());
        }
        responseBody.close();
    }

    @NotNull
    public String toString() {
        return "Response{protocol=" + (Object)((Object)this.protocol) + ", code=" + this.code + ", message=" + this.message + ", url=" + this.request.url() + '}';
    }

    @JvmOverloads
    @Nullable
    public final String header(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return Response.header$default(this, name2, null, 2, null);
    }

    @SourceDebugExtension(value={"SMAP\nResponse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Response.kt\nokhttp3/Response$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,455:1\n1#2:456\n*E\n"})
    public static class Builder {
        @Nullable
        private Request request;
        @Nullable
        private Protocol protocol;
        private int code;
        @Nullable
        private String message;
        @Nullable
        private Handshake handshake;
        @NotNull
        private Headers.Builder headers;
        @Nullable
        private ResponseBody body;
        @Nullable
        private Response networkResponse;
        @Nullable
        private Response cacheResponse;
        @Nullable
        private Response priorResponse;
        private long sentRequestAtMillis;
        private long receivedResponseAtMillis;
        @Nullable
        private Exchange exchange;

        @Nullable
        public final Request getRequest$okhttp() {
            return this.request;
        }

        public final void setRequest$okhttp(@Nullable Request request2) {
            this.request = request2;
        }

        @Nullable
        public final Protocol getProtocol$okhttp() {
            return this.protocol;
        }

        public final void setProtocol$okhttp(@Nullable Protocol protocol) {
            this.protocol = protocol;
        }

        public final int getCode$okhttp() {
            return this.code;
        }

        public final void setCode$okhttp(int n) {
            this.code = n;
        }

        @Nullable
        public final String getMessage$okhttp() {
            return this.message;
        }

        public final void setMessage$okhttp(@Nullable String string) {
            this.message = string;
        }

        @Nullable
        public final Handshake getHandshake$okhttp() {
            return this.handshake;
        }

        public final void setHandshake$okhttp(@Nullable Handshake handshake2) {
            this.handshake = handshake2;
        }

        @NotNull
        public final Headers.Builder getHeaders$okhttp() {
            return this.headers;
        }

        public final void setHeaders$okhttp(@NotNull Headers.Builder builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"<set-?>");
            this.headers = builder;
        }

        @Nullable
        public final ResponseBody getBody$okhttp() {
            return this.body;
        }

        public final void setBody$okhttp(@Nullable ResponseBody responseBody) {
            this.body = responseBody;
        }

        @Nullable
        public final Response getNetworkResponse$okhttp() {
            return this.networkResponse;
        }

        public final void setNetworkResponse$okhttp(@Nullable Response response2) {
            this.networkResponse = response2;
        }

        @Nullable
        public final Response getCacheResponse$okhttp() {
            return this.cacheResponse;
        }

        public final void setCacheResponse$okhttp(@Nullable Response response2) {
            this.cacheResponse = response2;
        }

        @Nullable
        public final Response getPriorResponse$okhttp() {
            return this.priorResponse;
        }

        public final void setPriorResponse$okhttp(@Nullable Response response2) {
            this.priorResponse = response2;
        }

        public final long getSentRequestAtMillis$okhttp() {
            return this.sentRequestAtMillis;
        }

        public final void setSentRequestAtMillis$okhttp(long l) {
            this.sentRequestAtMillis = l;
        }

        public final long getReceivedResponseAtMillis$okhttp() {
            return this.receivedResponseAtMillis;
        }

        public final void setReceivedResponseAtMillis$okhttp(long l) {
            this.receivedResponseAtMillis = l;
        }

        @Nullable
        public final Exchange getExchange$okhttp() {
            return this.exchange;
        }

        public final void setExchange$okhttp(@Nullable Exchange exchange) {
            this.exchange = exchange;
        }

        public Builder() {
            this.code = -1;
            this.headers = new Headers.Builder();
        }

        public Builder(@NotNull Response response2) {
            Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
            this.code = -1;
            this.request = response2.request();
            this.protocol = response2.protocol();
            this.code = response2.code();
            this.message = response2.message();
            this.handshake = response2.handshake();
            this.headers = response2.headers().newBuilder();
            this.body = response2.body();
            this.networkResponse = response2.networkResponse();
            this.cacheResponse = response2.cacheResponse();
            this.priorResponse = response2.priorResponse();
            this.sentRequestAtMillis = response2.sentRequestAtMillis();
            this.receivedResponseAtMillis = response2.receivedResponseAtMillis();
            this.exchange = response2.exchange();
        }

        @NotNull
        public Builder request(@NotNull Request request2) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
            Builder $this$request_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$request_u24lambda_u240.request = request2;
            return builder;
        }

        @NotNull
        public Builder protocol(@NotNull Protocol protocol) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)protocol), (String)"protocol");
            Builder $this$protocol_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$protocol_u24lambda_u241.protocol = protocol;
            return builder;
        }

        @NotNull
        public Builder code(int code) {
            Builder builder;
            Builder $this$code_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$code_u24lambda_u242.code = code;
            return builder;
        }

        @NotNull
        public Builder message(@NotNull String message2) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            Builder $this$message_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$message_u24lambda_u243.message = message2;
            return builder;
        }

        @NotNull
        public Builder handshake(@Nullable Handshake handshake2) {
            Builder builder;
            Builder $this$handshake_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$handshake_u24lambda_u244.handshake = handshake2;
            return builder;
        }

        @NotNull
        public Builder header(@NotNull String name2, @NotNull String value2) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder $this$header_u24lambda_u245 = builder = this;
            boolean bl = false;
            $this$header_u24lambda_u245.headers.set(name2, value2);
            return builder;
        }

        @NotNull
        public Builder addHeader(@NotNull String name2, @NotNull String value2) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder $this$addHeader_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$addHeader_u24lambda_u246.headers.add(name2, value2);
            return builder;
        }

        @NotNull
        public Builder removeHeader(@NotNull String name2) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Builder $this$removeHeader_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$removeHeader_u24lambda_u247.headers.removeAll(name2);
            return builder;
        }

        @NotNull
        public Builder headers(@NotNull Headers headers2) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)headers2, (String)"headers");
            Builder $this$headers_u24lambda_u248 = builder = this;
            boolean bl = false;
            $this$headers_u24lambda_u248.headers = headers2.newBuilder();
            return builder;
        }

        @NotNull
        public Builder body(@Nullable ResponseBody body) {
            Builder builder;
            Builder $this$body_u24lambda_u249 = builder = this;
            boolean bl = false;
            $this$body_u24lambda_u249.body = body;
            return builder;
        }

        @NotNull
        public Builder networkResponse(@Nullable Response networkResponse) {
            Builder builder;
            Builder $this$networkResponse_u24lambda_u2410 = builder = this;
            boolean bl = false;
            $this$networkResponse_u24lambda_u2410.checkSupportResponse("networkResponse", networkResponse);
            $this$networkResponse_u24lambda_u2410.networkResponse = networkResponse;
            return builder;
        }

        @NotNull
        public Builder cacheResponse(@Nullable Response cacheResponse) {
            Builder builder;
            Builder $this$cacheResponse_u24lambda_u2411 = builder = this;
            boolean bl = false;
            $this$cacheResponse_u24lambda_u2411.checkSupportResponse("cacheResponse", cacheResponse);
            $this$cacheResponse_u24lambda_u2411.cacheResponse = cacheResponse;
            return builder;
        }

        private final void checkSupportResponse(String name2, Response response2) {
            Response response3 = response2;
            if (response3 != null) {
                Response response4;
                Response $this$checkSupportResponse_u24lambda_u2416 = response4 = response3;
                boolean bl = false;
                if (!($this$checkSupportResponse_u24lambda_u2416.body() == null)) {
                    boolean $i$a$-require-Response$Builder$checkSupportResponse$1$52 = false;
                    String $i$a$-require-Response$Builder$checkSupportResponse$1$52 = name2 + ".body != null";
                    throw new IllegalArgumentException($i$a$-require-Response$Builder$checkSupportResponse$1$52.toString());
                }
                if (!($this$checkSupportResponse_u24lambda_u2416.networkResponse() == null)) {
                    boolean $i$a$-require-Response$Builder$checkSupportResponse$1$62 = false;
                    String $i$a$-require-Response$Builder$checkSupportResponse$1$62 = name2 + ".networkResponse != null";
                    throw new IllegalArgumentException($i$a$-require-Response$Builder$checkSupportResponse$1$62.toString());
                }
                if (!($this$checkSupportResponse_u24lambda_u2416.cacheResponse() == null)) {
                    boolean $i$a$-require-Response$Builder$checkSupportResponse$1$72 = false;
                    String $i$a$-require-Response$Builder$checkSupportResponse$1$72 = name2 + ".cacheResponse != null";
                    throw new IllegalArgumentException($i$a$-require-Response$Builder$checkSupportResponse$1$72.toString());
                }
                if (!($this$checkSupportResponse_u24lambda_u2416.priorResponse() == null)) {
                    boolean bl2 = false;
                    String string = name2 + ".priorResponse != null";
                    throw new IllegalArgumentException(string.toString());
                }
            }
        }

        @NotNull
        public Builder priorResponse(@Nullable Response priorResponse) {
            Builder builder;
            Builder $this$priorResponse_u24lambda_u2417 = builder = this;
            boolean bl = false;
            $this$priorResponse_u24lambda_u2417.checkPriorResponse(priorResponse);
            $this$priorResponse_u24lambda_u2417.priorResponse = priorResponse;
            return builder;
        }

        private final void checkPriorResponse(Response response2) {
            Response response3 = response2;
            if (response3 != null) {
                Response response4;
                Response $this$checkPriorResponse_u24lambda_u2419 = response4 = response3;
                boolean bl = false;
                if (!($this$checkPriorResponse_u24lambda_u2419.body() == null)) {
                    boolean bl2 = false;
                    String string = "priorResponse.body != null";
                    throw new IllegalArgumentException(string.toString());
                }
            }
        }

        @NotNull
        public Builder sentRequestAtMillis(long sentRequestAtMillis) {
            Builder builder;
            Builder $this$sentRequestAtMillis_u24lambda_u2420 = builder = this;
            boolean bl = false;
            $this$sentRequestAtMillis_u24lambda_u2420.sentRequestAtMillis = sentRequestAtMillis;
            return builder;
        }

        @NotNull
        public Builder receivedResponseAtMillis(long receivedResponseAtMillis) {
            Builder builder;
            Builder $this$receivedResponseAtMillis_u24lambda_u2421 = builder = this;
            boolean bl = false;
            $this$receivedResponseAtMillis_u24lambda_u2421.receivedResponseAtMillis = receivedResponseAtMillis;
            return builder;
        }

        public final void initExchange$okhttp(@NotNull Exchange deferredTrailers) {
            Intrinsics.checkNotNullParameter((Object)deferredTrailers, (String)"deferredTrailers");
            this.exchange = deferredTrailers;
        }

        @NotNull
        public Response build() {
            if (!(this.code >= 0)) {
                boolean $i$a$-check-Response$Builder$build$22 = false;
                String $i$a$-check-Response$Builder$build$22 = "code < 0: " + this.code;
                throw new IllegalStateException($i$a$-check-Response$Builder$build$22.toString());
            }
            Request request2 = this.request;
            if (request2 == null) {
                boolean $i$a$-checkNotNull-Response$Builder$build$52 = false;
                String $i$a$-checkNotNull-Response$Builder$build$52 = "request == null";
                throw new IllegalStateException($i$a$-checkNotNull-Response$Builder$build$52.toString());
            }
            Protocol protocol = this.protocol;
            if (protocol == null) {
                Request request3 = request2;
                boolean $i$a$-checkNotNull-Response$Builder$build$62 = false;
                Request request4 = request3;
                String $i$a$-checkNotNull-Response$Builder$build$62 = "protocol == null";
                throw new IllegalStateException($i$a$-checkNotNull-Response$Builder$build$62.toString());
            }
            String string = this.message;
            if (string == null) {
                Protocol protocol2 = protocol;
                Request request5 = request2;
                boolean bl = false;
                String string2 = "message == null";
                Request request6 = request5;
                Protocol protocol3 = protocol2;
                String string3 = string2;
                throw new IllegalStateException(string3.toString());
            }
            Exchange exchange = this.exchange;
            long l = this.receivedResponseAtMillis;
            long l2 = this.sentRequestAtMillis;
            Response response2 = this.priorResponse;
            Response response3 = this.cacheResponse;
            Response response4 = this.networkResponse;
            ResponseBody responseBody = this.body;
            Headers headers2 = this.headers.build();
            Handshake handshake2 = this.handshake;
            int n = this.code;
            String string4 = string;
            Protocol protocol4 = protocol;
            Request request7 = request2;
            return new Response(request7, protocol4, string4, n, handshake2, headers2, responseBody, response4, response3, response2, l2, l, exchange);
        }
    }
}

