/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.CacheControl;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okhttp3.internal.http.HttpMethod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SourceDebugExtension(value={"SMAP\nRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Request.kt\nokhttp3/Request\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,298:1\n1864#2,3:299\n*S KotlinDebug\n*F\n+ 1 Request.kt\nokhttp3/Request\n*L\n119#1:299,3\n*E\n"})
public final class Request {
    @NotNull
    private final HttpUrl url;
    @NotNull
    private final String method;
    @NotNull
    private final Headers headers;
    @Nullable
    private final RequestBody body;
    @NotNull
    private final Map<Class<?>, Object> tags;
    @Nullable
    private CacheControl lazyCacheControl;

    public Request(@NotNull HttpUrl url, @NotNull String method, @NotNull Headers headers2, @Nullable RequestBody body, @NotNull Map<Class<?>, ? extends Object> tags) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)headers2, (String)"headers");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        this.url = url;
        this.method = method;
        this.headers = headers2;
        this.body = body;
        this.tags = tags;
    }

    @JvmName(name="url")
    @NotNull
    public final HttpUrl url() {
        return this.url;
    }

    @JvmName(name="method")
    @NotNull
    public final String method() {
        return this.method;
    }

    @JvmName(name="headers")
    @NotNull
    public final Headers headers() {
        return this.headers;
    }

    @JvmName(name="body")
    @Nullable
    public final RequestBody body() {
        return this.body;
    }

    @NotNull
    public final Map<Class<?>, Object> getTags$okhttp() {
        return this.tags;
    }

    public final boolean isHttps() {
        return this.url.isHttps();
    }

    @Nullable
    public final String header(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.headers.get(name2);
    }

    @NotNull
    public final List<String> headers(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.headers.values(name2);
    }

    @Nullable
    public final Object tag() {
        return this.tag(Object.class);
    }

    @Nullable
    public final <T> T tag(@NotNull Class<? extends T> type2) {
        Intrinsics.checkNotNullParameter(type2, (String)"type");
        return type2.cast(this.tags.get(type2));
    }

    @NotNull
    public final Builder newBuilder() {
        return new Builder(this);
    }

    @JvmName(name="cacheControl")
    @NotNull
    public final CacheControl cacheControl() {
        CacheControl result2 = this.lazyCacheControl;
        if (result2 == null) {
            this.lazyCacheControl = result2 = CacheControl.Companion.parse(this.headers);
        }
        return result2;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="url", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_url")
    @NotNull
    public final HttpUrl -deprecated_url() {
        return this.url;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="method", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_method")
    @NotNull
    public final String -deprecated_method() {
        return this.method;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="headers", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_headers")
    @NotNull
    public final Headers -deprecated_headers() {
        return this.headers;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="body", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_body")
    @Nullable
    public final RequestBody -deprecated_body() {
        return this.body;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="cacheControl", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_cacheControl")
    @NotNull
    public final CacheControl -deprecated_cacheControl() {
        return this.cacheControl();
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u241.append("Request{method=");
        $this$toString_u24lambda_u241.append(this.method);
        $this$toString_u24lambda_u241.append(", url=");
        $this$toString_u24lambda_u241.append(this.url);
        if (this.headers.size() != 0) {
            $this$toString_u24lambda_u241.append(", headers=[");
            Iterable $this$forEachIndexed$iv = this.headers;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Pair pair = (Pair)item$iv;
                int index = n;
                boolean bl2 = false;
                String name2 = (String)pair.component1();
                String value2 = (String)pair.component2();
                if (index > 0) {
                    $this$toString_u24lambda_u241.append(", ");
                }
                $this$toString_u24lambda_u241.append(name2);
                $this$toString_u24lambda_u241.append(':');
                $this$toString_u24lambda_u241.append(value2);
            }
            $this$toString_u24lambda_u241.append(']');
        }
        if (!this.tags.isEmpty()) {
            $this$toString_u24lambda_u241.append(", tags=");
            $this$toString_u24lambda_u241.append(this.tags);
        }
        $this$toString_u24lambda_u241.append('}');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @SourceDebugExtension(value={"SMAP\nRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Request.kt\nokhttp3/Request$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,298:1\n1#2:299\n*E\n"})
    public static class Builder {
        @Nullable
        private HttpUrl url;
        @NotNull
        private String method;
        @NotNull
        private Headers.Builder headers;
        @Nullable
        private RequestBody body;
        @NotNull
        private Map<Class<?>, Object> tags;

        @Nullable
        public final HttpUrl getUrl$okhttp() {
            return this.url;
        }

        public final void setUrl$okhttp(@Nullable HttpUrl httpUrl) {
            this.url = httpUrl;
        }

        @NotNull
        public final String getMethod$okhttp() {
            return this.method;
        }

        public final void setMethod$okhttp(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.method = string;
        }

        @NotNull
        public final Headers.Builder getHeaders$okhttp() {
            return this.headers;
        }

        public final void setHeaders$okhttp(@NotNull Headers.Builder builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"<set-?>");
            this.headers = builder;
        }

        @Nullable
        public final RequestBody getBody$okhttp() {
            return this.body;
        }

        public final void setBody$okhttp(@Nullable RequestBody requestBody) {
            this.body = requestBody;
        }

        @NotNull
        public final Map<Class<?>, Object> getTags$okhttp() {
            return this.tags;
        }

        public final void setTags$okhttp(@NotNull Map<Class<?>, Object> map2) {
            Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
            this.tags = map2;
        }

        public Builder() {
            this.tags = new LinkedHashMap();
            this.method = "GET";
            this.headers = new Headers.Builder();
        }

        public Builder(@NotNull Request request2) {
            Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
            this.tags = new LinkedHashMap();
            this.url = request2.url();
            this.method = request2.method();
            this.body = request2.body();
            this.tags = request2.getTags$okhttp().isEmpty() ? (Map)new LinkedHashMap() : MapsKt.toMutableMap(request2.getTags$okhttp());
            this.headers = request2.headers().newBuilder();
        }

        @NotNull
        public Builder url(@NotNull HttpUrl url) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Builder $this$url_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$url_u24lambda_u240.url = url;
            return builder;
        }

        @NotNull
        public Builder url(@NotNull String url) {
            String string;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            if (StringsKt.startsWith((String)url, (String)"ws:", (boolean)true)) {
                StringBuilder stringBuilder = new StringBuilder().append("http:");
                String string2 = url.substring(3);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                string = stringBuilder.append(string2).toString();
            } else if (StringsKt.startsWith((String)url, (String)"wss:", (boolean)true)) {
                StringBuilder stringBuilder = new StringBuilder().append("https:");
                String string3 = url.substring(4);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                string = stringBuilder.append(string3).toString();
            } else {
                string = url;
            }
            String finalUrl = string;
            return this.url(HttpUrl.Companion.get(finalUrl));
        }

        @NotNull
        public Builder url(@NotNull URL url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            String string = url.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.toString()");
            return this.url(HttpUrl.Companion.get(string));
        }

        @NotNull
        public Builder header(@NotNull String name2, @NotNull String value2) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder $this$header_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$header_u24lambda_u241.headers.set(name2, value2);
            return builder;
        }

        @NotNull
        public Builder addHeader(@NotNull String name2, @NotNull String value2) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder $this$addHeader_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$addHeader_u24lambda_u242.headers.add(name2, value2);
            return builder;
        }

        @NotNull
        public Builder removeHeader(@NotNull String name2) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Builder $this$removeHeader_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$removeHeader_u24lambda_u243.headers.removeAll(name2);
            return builder;
        }

        @NotNull
        public Builder headers(@NotNull Headers headers2) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)headers2, (String)"headers");
            Builder $this$headers_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$headers_u24lambda_u244.headers = headers2.newBuilder();
            return builder;
        }

        @NotNull
        public Builder cacheControl(@NotNull CacheControl cacheControl) {
            Intrinsics.checkNotNullParameter((Object)cacheControl, (String)"cacheControl");
            String value2 = cacheControl.toString();
            return ((CharSequence)value2).length() == 0 ? this.removeHeader("Cache-Control") : this.header("Cache-Control", value2);
        }

        @NotNull
        public Builder get() {
            return this.method("GET", null);
        }

        @NotNull
        public Builder head() {
            return this.method("HEAD", null);
        }

        @NotNull
        public Builder post(@NotNull RequestBody body) {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            return this.method("POST", body);
        }

        @JvmOverloads
        @NotNull
        public Builder delete(@Nullable RequestBody body) {
            return this.method("DELETE", body);
        }

        public static /* synthetic */ Builder delete$default(Builder builder, RequestBody requestBody, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: delete");
            }
            if ((n & 1) != 0) {
                requestBody = Util.EMPTY_REQUEST;
            }
            return builder.delete(requestBody);
        }

        @NotNull
        public Builder put(@NotNull RequestBody body) {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            return this.method("PUT", body);
        }

        @NotNull
        public Builder patch(@NotNull RequestBody body) {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            return this.method("PATCH", body);
        }

        @NotNull
        public Builder method(@NotNull String method, @Nullable RequestBody body) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Builder $this$method_u24lambda_u248 = builder = this;
            boolean bl = false;
            if (!(((CharSequence)method).length() > 0)) {
                boolean $i$a$-require-Request$Builder$method$1$42 = false;
                String $i$a$-require-Request$Builder$method$1$42 = "method.isEmpty() == true";
                throw new IllegalArgumentException($i$a$-require-Request$Builder$method$1$42.toString());
            }
            if (body == null) {
                if (!(!HttpMethod.requiresRequestBody(method))) {
                    boolean $i$a$-require-Request$Builder$method$1$52 = false;
                    String $i$a$-require-Request$Builder$method$1$52 = "method " + method + " must have a request body.";
                    throw new IllegalArgumentException($i$a$-require-Request$Builder$method$1$52.toString());
                }
            } else if (!HttpMethod.permitsRequestBody(method)) {
                boolean bl2 = false;
                String string = "method " + method + " must not have a request body.";
                throw new IllegalArgumentException(string.toString());
            }
            $this$method_u24lambda_u248.method = method;
            $this$method_u24lambda_u248.body = body;
            return builder;
        }

        @NotNull
        public Builder tag(@Nullable Object tag) {
            return this.tag(Object.class, tag);
        }

        @NotNull
        public <T> Builder tag(@NotNull Class<? super T> type2, @Nullable T tag) {
            Builder builder;
            Intrinsics.checkNotNullParameter(type2, (String)"type");
            Builder $this$tag_u24lambda_u249 = builder = this;
            boolean bl = false;
            if (tag == null) {
                $this$tag_u24lambda_u249.tags.remove(type2);
            } else {
                if ($this$tag_u24lambda_u249.tags.isEmpty()) {
                    $this$tag_u24lambda_u249.tags = new LinkedHashMap();
                }
                Map<Class<?>, Object> map2 = $this$tag_u24lambda_u249.tags;
                T t2 = type2.cast(tag);
                Intrinsics.checkNotNull(t2);
                map2.put(type2, t2);
            }
            return builder;
        }

        @NotNull
        public Request build() {
            HttpUrl httpUrl = this.url;
            if (httpUrl == null) {
                boolean bl = false;
                String string = "url == null";
                throw new IllegalStateException(string.toString());
            }
            Map<Class<?>, Object> map2 = Util.toImmutableMap(this.tags);
            RequestBody requestBody = this.body;
            Headers headers2 = this.headers.build();
            String string = this.method;
            HttpUrl httpUrl2 = httpUrl;
            return new Request(httpUrl2, string, headers2, requestBody, map2);
        }

        @JvmOverloads
        @NotNull
        public final Builder delete() {
            return Builder.delete$default(this, null, 1, null);
        }
    }
}

