/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.text.StringsKt;
import okhttp3.internal.Util;
import okhttp3.internal.http.DatesKt;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Headers
implements Iterable<Pair<? extends String, ? extends String>>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String[] namesAndValues;

    private Headers(String[] namesAndValues) {
        this.namesAndValues = namesAndValues;
    }

    @Nullable
    public final String get(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return Headers.Companion.get(this.namesAndValues, name2);
    }

    @Nullable
    public final Date getDate(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        String string = this.get(name2);
        return string != null ? DatesKt.toHttpDateOrNull(string) : null;
    }

    @IgnoreJRERequirement
    @Nullable
    public final Instant getInstant(@NotNull String name2) {
        Date value2;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Date date = value2 = this.getDate(name2);
        return date != null ? date.toInstant() : null;
    }

    @JvmName(name="size")
    public final int size() {
        return this.namesAndValues.length / 2;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="size", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_size")
    public final int -deprecated_size() {
        return this.size();
    }

    @NotNull
    public final String name(int index) {
        return this.namesAndValues[index * 2];
    }

    @NotNull
    public final String value(int index) {
        return this.namesAndValues[index * 2 + 1];
    }

    @NotNull
    public final Set<String> names() {
        TreeSet<String> result2 = new TreeSet<String>(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        int n = this.size();
        for (int i2 = 0; i2 < n; ++i2) {
            result2.add(this.name(i2));
        }
        Set<String> set = Collections.unmodifiableSet((Set)result2);
        Intrinsics.checkNotNullExpressionValue(set, (String)"unmodifiableSet(result)");
        return set;
    }

    @NotNull
    public final List<String> values(@NotNull String name2) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        List result2 = null;
        int n = this.size();
        for (int i2 = 0; i2 < n; ++i2) {
            if (!StringsKt.equals((String)name2, (String)this.name(i2), (boolean)true)) continue;
            if (result2 == null) {
                result2 = new ArrayList(2);
            }
            result2.add(this.value(i2));
        }
        if (result2 != null) {
            List list3 = Collections.unmodifiableList(result2);
            list2 = list3;
            Intrinsics.checkNotNullExpressionValue(list3, (String)"{\n      Collections.unmodifiableList(result)\n    }");
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    public final long byteCount() {
        long result2 = this.namesAndValues.length * 2;
        int n = this.namesAndValues.length;
        for (int i2 = 0; i2 < n; ++i2) {
            result2 += (long)this.namesAndValues[i2].length();
        }
        return result2;
    }

    @Override
    @NotNull
    public Iterator<Pair<String, String>> iterator() {
        int n = 0;
        int n2 = this.size();
        Object[] objectArray = new Pair[n2];
        while (n < n2) {
            int n3 = n++;
            objectArray[n3] = TuplesKt.to((Object)this.name(n3), (Object)this.value(n3));
        }
        return ArrayIteratorKt.iterator((Object[])objectArray);
    }

    @NotNull
    public final Builder newBuilder() {
        Builder result2 = new Builder();
        CollectionsKt.addAll((Collection)result2.getNamesAndValues$okhttp(), (Object[])this.namesAndValues);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof Headers && Arrays.equals(this.namesAndValues, ((Headers)other).namesAndValues);
    }

    public int hashCode() {
        return Arrays.hashCode(this.namesAndValues);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = this.size();
        for (int i2 = 0; i2 < n; ++i2) {
            String name2 = this.name(i2);
            String value2 = this.value(i2);
            $this$toString_u24lambda_u240.append(name2);
            $this$toString_u24lambda_u240.append(": ");
            $this$toString_u24lambda_u240.append(Util.isSensitiveHeader(name2) ? "\u2588\u2588" : value2);
            $this$toString_u24lambda_u240.append("\n");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final Map<String, List<String>> toMultimap() {
        TreeMap result2 = new TreeMap(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        int n = this.size();
        for (int i2 = 0; i2 < n; ++i2) {
            String name2;
            String string = this.name(i2);
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            Intrinsics.checkNotNullExpressionValue((Object)string.toLowerCase(locale), (String)"this as java.lang.String).toLowerCase(locale)");
            List values = (List)result2.get(name2);
            if (values == null) {
                values = new ArrayList(2);
                ((Map)result2).put(name2, values);
            }
            values.add(this.value(i2));
        }
        return result2;
    }

    @JvmStatic
    @JvmName(name="of")
    @NotNull
    public static final Headers of(String ... namesAndValues) {
        return Companion.of(namesAndValues);
    }

    @JvmStatic
    @JvmName(name="of")
    @NotNull
    public static final Headers of(@NotNull Map<String, String> $this$of) {
        return Companion.of($this$of);
    }

    public /* synthetic */ Headers(String[] namesAndValues, DefaultConstructorMarker $constructor_marker) {
        this(namesAndValues);
    }

    @SourceDebugExtension(value={"SMAP\nHeaders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Headers.kt\nokhttp3/Headers$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,458:1\n1#2:459\n37#3,2:460\n*S KotlinDebug\n*F\n+ 1 Headers.kt\nokhttp3/Headers$Builder\n*L\n359#1:460,2\n*E\n"})
    public static final class Builder {
        @NotNull
        private final List<String> namesAndValues = new ArrayList(20);

        @NotNull
        public final List<String> getNamesAndValues$okhttp() {
            return this.namesAndValues;
        }

        @NotNull
        public final Builder addLenient$okhttp(@NotNull String line) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            Builder $this$addLenient_u24lambda_u240 = builder = this;
            boolean bl = false;
            int index = StringsKt.indexOf$default((CharSequence)line, (char)':', (int)1, (boolean)false, (int)4, null);
            if (index != -1) {
                String string = line.substring(0, index);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String string2 = line.substring(index + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                $this$addLenient_u24lambda_u240.addLenient$okhttp(string, string2);
            } else if (line.charAt(0) == ':') {
                String string = line.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                $this$addLenient_u24lambda_u240.addLenient$okhttp("", string);
            } else {
                $this$addLenient_u24lambda_u240.addLenient$okhttp("", line);
            }
            return builder;
        }

        @NotNull
        public final Builder add(@NotNull String line) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            Builder $this$add_u24lambda_u242 = builder = this;
            boolean bl = false;
            int index = StringsKt.indexOf$default((CharSequence)line, (char)':', (int)0, (boolean)false, (int)6, null);
            if (!(index != -1)) {
                boolean bl2 = false;
                String string = "Unexpected header: " + line;
                throw new IllegalArgumentException(string.toString());
            }
            String string = line.substring(0, index);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
            String string3 = line.substring(index + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            $this$add_u24lambda_u242.add(string2, string3);
            return builder;
        }

        @NotNull
        public final Builder add(@NotNull String name2, @NotNull String value2) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder $this$add_u24lambda_u243 = builder = this;
            boolean bl = false;
            Companion.checkName(name2);
            Companion.checkValue(value2, name2);
            $this$add_u24lambda_u243.addLenient$okhttp(name2, value2);
            return builder;
        }

        @NotNull
        public final Builder addUnsafeNonAscii(@NotNull String name2, @NotNull String value2) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder $this$addUnsafeNonAscii_u24lambda_u244 = builder = this;
            boolean bl = false;
            Companion.checkName(name2);
            $this$addUnsafeNonAscii_u24lambda_u244.addLenient$okhttp(name2, value2);
            return builder;
        }

        @NotNull
        public final Builder addAll(@NotNull Headers headers2) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)headers2, (String)"headers");
            Builder $this$addAll_u24lambda_u245 = builder = this;
            boolean bl = false;
            int n = headers2.size();
            for (int i2 = 0; i2 < n; ++i2) {
                $this$addAll_u24lambda_u245.addLenient$okhttp(headers2.name(i2), headers2.value(i2));
            }
            return builder;
        }

        @NotNull
        public final Builder add(@NotNull String name2, @NotNull Date value2) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder $this$add_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$add_u24lambda_u246.add(name2, DatesKt.toHttpDateString(value2));
            return builder;
        }

        @IgnoreJRERequirement
        @NotNull
        public final Builder add(@NotNull String name2, @NotNull Instant value2) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder $this$add_u24lambda_u247 = builder = this;
            boolean bl = false;
            $this$add_u24lambda_u247.add(name2, new Date(value2.toEpochMilli()));
            return builder;
        }

        @NotNull
        public final Builder set(@NotNull String name2, @NotNull Date value2) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder $this$set_u24lambda_u248 = builder = this;
            boolean bl = false;
            $this$set_u24lambda_u248.set(name2, DatesKt.toHttpDateString(value2));
            return builder;
        }

        @IgnoreJRERequirement
        @NotNull
        public final Builder set(@NotNull String name2, @NotNull Instant value2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder $this$set_u24lambda_u249 = this;
            boolean bl = false;
            return $this$set_u24lambda_u249.set(name2, new Date(value2.toEpochMilli()));
        }

        @NotNull
        public final Builder addLenient$okhttp(@NotNull String name2, @NotNull String value2) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder $this$addLenient_u24lambda_u2410 = builder = this;
            boolean bl = false;
            $this$addLenient_u24lambda_u2410.namesAndValues.add(name2);
            $this$addLenient_u24lambda_u2410.namesAndValues.add(((Object)StringsKt.trim((CharSequence)value2)).toString());
            return builder;
        }

        @NotNull
        public final Builder removeAll(@NotNull String name2) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Builder $this$removeAll_u24lambda_u2411 = builder = this;
            boolean bl = false;
            for (int i2 = 0; i2 < $this$removeAll_u24lambda_u2411.namesAndValues.size(); i2 += 2) {
                if (!StringsKt.equals((String)name2, (String)$this$removeAll_u24lambda_u2411.namesAndValues.get(i2), (boolean)true)) continue;
                $this$removeAll_u24lambda_u2411.namesAndValues.remove(i2);
                $this$removeAll_u24lambda_u2411.namesAndValues.remove(i2);
                i2 -= 2;
            }
            return builder;
        }

        @NotNull
        public final Builder set(@NotNull String name2, @NotNull String value2) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder $this$set_u24lambda_u2412 = builder = this;
            boolean bl = false;
            Companion.checkName(name2);
            Companion.checkValue(value2, name2);
            $this$set_u24lambda_u2412.removeAll(name2);
            $this$set_u24lambda_u2412.addLenient$okhttp(name2, value2);
            return builder;
        }

        @Nullable
        public final String get(@NotNull String name2) {
            int n;
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            int i2 = n = this.namesAndValues.size() - 2;
            int n2 = ProgressionUtilKt.getProgressionLastElement((int)n, (int)0, (int)-2);
            if (n2 <= i2) {
                while (true) {
                    if (StringsKt.equals((String)name2, (String)this.namesAndValues.get(i2), (boolean)true)) {
                        return this.namesAndValues.get(i2 + 1);
                    }
                    if (i2 == n2) break;
                    i2 -= 2;
                }
            }
            return null;
        }

        @NotNull
        public final Headers build() {
            Collection $this$toTypedArray$iv = this.namesAndValues;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return new Headers(thisCollection$iv.toArray(new String[0]), null);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @SourceDebugExtension(value={"SMAP\nHeaders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Headers.kt\nokhttp3/Headers$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,458:1\n1#2:459\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final String get(String[] namesAndValues, String name2) {
            int n;
            int i2 = n = namesAndValues.length - 2;
            int n2 = ProgressionUtilKt.getProgressionLastElement((int)n, (int)0, (int)-2);
            if (n2 <= i2) {
                while (true) {
                    if (StringsKt.equals((String)name2, (String)namesAndValues[i2], (boolean)true)) {
                        return namesAndValues[i2 + 1];
                    }
                    if (i2 == n2) break;
                    i2 -= 2;
                }
            }
            return null;
        }

        @JvmStatic
        @JvmName(name="of")
        @NotNull
        public final Headers of(String ... namesAndValues) {
            Intrinsics.checkNotNullParameter((Object)namesAndValues, (String)"namesAndValues");
            if (!(namesAndValues.length % 2 == 0)) {
                boolean $i$a$-require-Headers$Companion$headersOf$32 = false;
                String $i$a$-require-Headers$Companion$headersOf$32 = "Expected alternating header names and values";
                throw new IllegalArgumentException($i$a$-require-Headers$Companion$headersOf$32.toString());
            }
            String[] namesAndValues2 = (String[])namesAndValues.clone();
            int n = namesAndValues2.length;
            for (int i2 = 0; i2 < n; ++i2) {
                if (!(namesAndValues2[i2] != null)) {
                    boolean $i$a$-require-Headers$Companion$headersOf$42 = false;
                    String $i$a$-require-Headers$Companion$headersOf$42 = "Headers cannot be null";
                    throw new IllegalArgumentException($i$a$-require-Headers$Companion$headersOf$42.toString());
                }
                namesAndValues2[i2] = ((Object)StringsKt.trim((CharSequence)namesAndValues2[i2])).toString();
            }
            int i3 = 0;
            int n2 = namesAndValues2.length + -1;
            int n3 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n2, (int)2);
            if (i3 <= n3) {
                while (true) {
                    String name2 = namesAndValues2[i3];
                    String value2 = namesAndValues2[i3 + 1];
                    this.checkName(name2);
                    this.checkValue(value2, name2);
                    if (i3 == n3) break;
                    i3 += 2;
                }
            }
            return new Headers(namesAndValues2, null);
        }

        @Deprecated(message="function name changed", replaceWith=@ReplaceWith(expression="headersOf(*namesAndValues)", imports={}), level=DeprecationLevel.ERROR)
        @JvmName(name="-deprecated_of")
        @NotNull
        public final Headers -deprecated_of(String ... namesAndValues) {
            Intrinsics.checkNotNullParameter((Object)namesAndValues, (String)"namesAndValues");
            return this.of(Arrays.copyOf(namesAndValues, namesAndValues.length));
        }

        @JvmStatic
        @JvmName(name="of")
        @NotNull
        public final Headers of(@NotNull Map<String, String> $this$toHeaders) {
            Intrinsics.checkNotNullParameter($this$toHeaders, (String)"<this>");
            String[] namesAndValues = new String[$this$toHeaders.size() * 2];
            int i2 = 0;
            for (Map.Entry<String, String> entry : $this$toHeaders.entrySet()) {
                String k = entry.getKey();
                String v = entry.getValue();
                String name2 = ((Object)StringsKt.trim((CharSequence)k)).toString();
                String value2 = ((Object)StringsKt.trim((CharSequence)v)).toString();
                this.checkName(name2);
                this.checkValue(value2, name2);
                namesAndValues[i2] = name2;
                namesAndValues[i2 + 1] = value2;
                i2 += 2;
            }
            return new Headers(namesAndValues, null);
        }

        @Deprecated(message="function moved to extension", replaceWith=@ReplaceWith(expression="headers.toHeaders()", imports={}), level=DeprecationLevel.ERROR)
        @JvmName(name="-deprecated_of")
        @NotNull
        public final Headers -deprecated_of(@NotNull Map<String, String> headers2) {
            Intrinsics.checkNotNullParameter(headers2, (String)"headers");
            return this.of(headers2);
        }

        private final void checkName(String name2) {
            if (!(((CharSequence)name2).length() > 0)) {
                boolean bl = false;
                String string = "name is empty";
                throw new IllegalArgumentException(string.toString());
            }
            int n = name2.length();
            for (int i2 = 0; i2 < n; ++i2) {
                char c = name2.charAt(i2);
                if ('!' <= c ? c < '\u007f' : false) continue;
                boolean bl = false;
                Object[] objectArray = new Object[]{(int)c, i2, name2};
                String string = Util.format("Unexpected char %#04x at %d in header name: %s", objectArray);
                throw new IllegalArgumentException(string.toString());
            }
        }

        /*
         * Unable to fully structure code
         */
        private final void checkValue(String value, String name) {
            var4_4 = value.length();
            for (i = 0; i < var4_4; ++i) {
                c = value.charAt(i);
                if (c == '\t') ** GOTO lbl-1000
                v0 = ' ' <= c ? c < '\u007f' : false;
                if (v0) lbl-1000:
                // 2 sources

                {
                    v1 = true;
                } else {
                    v1 = false;
                }
                if (v1) continue;
                $i$a$-require-Headers$Companion$checkValue$1 = false;
                var7_8 = new Object[]{(int)c, i, name};
                var6_7 = Util.format("Unexpected char %#04x at %d in %s value", var7_8) + (Util.isSensitiveHeader(name) != false ? "" : ": " + value);
                throw new IllegalArgumentException(var6_7.toString());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

