/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public interface Dns {
    @NotNull
    public static final Companion Companion = okhttp3.Dns$Companion.$$INSTANCE;
    @JvmField
    @NotNull
    public static final Dns SYSTEM = new Companion.DnsSystem();

    @NotNull
    public List<InetAddress> lookup(@NotNull String var1) throws UnknownHostException;

    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
        }

        private static final class DnsSystem
        implements Dns {
            @Override
            @NotNull
            public List<InetAddress> lookup(@NotNull String hostname) {
                Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
                try {
                    InetAddress[] inetAddressArray = InetAddress.getAllByName(hostname);
                    Intrinsics.checkNotNullExpressionValue((Object)inetAddressArray, (String)"getAllByName(hostname)");
                    return ArraysKt.toList((Object[])inetAddressArray);
                }
                catch (NullPointerException e) {
                    UnknownHostException unknownHostException;
                    UnknownHostException $this$lookup_u24lambda_u240 = unknownHostException = new UnknownHostException("Broken system behaviour for dns lookup of " + hostname);
                    boolean bl = false;
                    $this$lookup_u24lambda_u240.initCause(e);
                    throw (Throwable)unknownHostException;
                }
            }
        }
    }
}

