/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io;

import java.util.concurrent.atomic.AtomicReferenceArray;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.io.RefCountingCopyTracker;
import kotlinx.io.Segment;
import kotlinx.io.SegmentCopyTracker;
import org.jetbrains.annotations.NotNull;

public final class SegmentPool {
    @NotNull
    public static final SegmentPool INSTANCE = new SegmentPool();
    private static final int MAX_SIZE = 65536;
    @NotNull
    private static final Segment LOCK = Segment.Companion.new$kotlinx_io_core(new byte[0], 0, 0, null, false);
    private static final int HASH_BUCKET_COUNT = Integer.highestOneBit(Runtime.getRuntime().availableProcessors() * 2 - 1);
    private static final int HASH_BUCKET_COUNT_L2 = RangesKt.coerceAtLeast((int)(HASH_BUCKET_COUNT / 2), (int)1);
    @NotNull
    private static final String DEFAULT_SECOND_LEVEL_POOL_TOTAL_SIZE = Intrinsics.areEqual((Object)System.getProperty("java.vm.name"), (Object)"Dalvik") ? "0" : "4194304";
    private static final int SECOND_LEVEL_POOL_TOTAL_SIZE;
    private static final int SECOND_LEVEL_POOL_BUCKET_SIZE;
    @NotNull
    private static final AtomicReferenceArray<Segment> hashBuckets;
    @NotNull
    private static final AtomicReferenceArray<Segment> hashBucketsL2;

    private SegmentPool() {
    }

    public final int getMAX_SIZE() {
        return MAX_SIZE;
    }

    public final int getHASH_BUCKET_COUNT$kotlinx_io_core() {
        return HASH_BUCKET_COUNT;
    }

    public final int getSECOND_LEVEL_POOL_TOTAL_SIZE$kotlinx_io_core() {
        return SECOND_LEVEL_POOL_TOTAL_SIZE;
    }

    public final int getByteCount() {
        Segment segment = hashBuckets.get(this.l1BucketId());
        if (segment == null) {
            return 0;
        }
        Segment first = segment;
        return first.getLimit();
    }

    @JvmStatic
    @NotNull
    public static final Segment take() {
        Segment first;
        AtomicReferenceArray<Segment> buckets = hashBuckets;
        int bucketId = INSTANCE.l1BucketId();
        while (Intrinsics.areEqual((Object)(first = buckets.getAndSet(bucketId, LOCK)), (Object)LOCK)) {
        }
        if (first == null) {
            buckets.set(bucketId, null);
            if (SECOND_LEVEL_POOL_TOTAL_SIZE > 0) {
                return INSTANCE.takeL2();
            }
            return Segment.Companion.new$kotlinx_io_core();
        }
        buckets.set(bucketId, first.getNext());
        first.setNext(null);
        first.setLimit(0);
        return first;
    }

    @JvmStatic
    private static final Segment takeL2() {
        Segment first;
        int bucket;
        AtomicReferenceArray<Segment> buckets;
        block2: {
            buckets = hashBucketsL2;
            bucket = INSTANCE.l2BucketId();
            int attempts = 0;
            while (true) {
                if (Intrinsics.areEqual((Object)(first = buckets.getAndSet(bucket, LOCK)), (Object)LOCK)) {
                    continue;
                }
                if (first != null) break block2;
                buckets.set(bucket, null);
                if (attempts >= HASH_BUCKET_COUNT_L2) break;
                bucket = bucket + 1 & HASH_BUCKET_COUNT_L2 - 1;
                ++attempts;
            }
            return Segment.Companion.new$kotlinx_io_core();
        }
        buckets.set(bucket, first.getNext());
        first.setNext(null);
        first.setLimit(0);
        return first;
    }

    @JvmStatic
    public static final void recycle(@NotNull Segment segment) {
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        if (!(segment.getNext() == null && segment.getPrev() == null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        SegmentCopyTracker segmentCopyTracker = segment.getCopyTracker$kotlinx_io_core();
        boolean bl = segmentCopyTracker != null ? segmentCopyTracker.removeCopy() : false;
        if (bl) {
            return;
        }
        AtomicReferenceArray<Segment> buckets = hashBuckets;
        int bucketId = INSTANCE.l1BucketId();
        segment.setPos(0);
        segment.owner = true;
        while (true) {
            Segment first;
            if ((first = buckets.get(bucketId)) == LOCK) {
                continue;
            }
            Segment segment2 = first;
            int firstLimit = segment2 != null ? segment2.getLimit() : 0;
            if (firstLimit >= MAX_SIZE) {
                if (SECOND_LEVEL_POOL_TOTAL_SIZE > 0) {
                    SegmentPool.recycleL2(segment);
                }
                return;
            }
            segment.setNext(first);
            segment.setLimit(firstLimit + 8192);
            if (buckets.compareAndSet(bucketId, first, segment)) break;
        }
    }

    @JvmStatic
    private static final void recycleL2(Segment segment) {
        segment.setPos(0);
        segment.owner = true;
        int bucket = INSTANCE.l2BucketId();
        AtomicReferenceArray<Segment> buckets = hashBucketsL2;
        int attempts = 0;
        while (true) {
            int firstLimit;
            Segment first;
            if ((first = buckets.get(bucket)) == LOCK) {
                continue;
            }
            Segment segment2 = first;
            int n = firstLimit = segment2 != null ? segment2.getLimit() : 0;
            if (firstLimit + 8192 > SECOND_LEVEL_POOL_BUCKET_SIZE) {
                if (attempts < HASH_BUCKET_COUNT_L2) {
                    ++attempts;
                    bucket = bucket + 1 & HASH_BUCKET_COUNT_L2 - 1;
                    continue;
                }
                return;
            }
            segment.setNext(first);
            segment.setLimit(firstLimit + 8192);
            if (buckets.compareAndSet(bucket, first, segment)) break;
        }
    }

    @JvmStatic
    @NotNull
    public static final SegmentCopyTracker tracker() {
        return new RefCountingCopyTracker();
    }

    private final int l1BucketId() {
        return this.bucketId((long)HASH_BUCKET_COUNT - 1L);
    }

    private final int l2BucketId() {
        return this.bucketId((long)HASH_BUCKET_COUNT_L2 - 1L);
    }

    private final int bucketId(long mask) {
        return (int)(Thread.currentThread().getId() & mask);
    }

    static {
        String string = System.getProperty("kotlinx.io.pool.size.bytes", DEFAULT_SECOND_LEVEL_POOL_TOTAL_SIZE);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        Integer n = StringsKt.toIntOrNull((String)string);
        SECOND_LEVEL_POOL_TOTAL_SIZE = n != null ? RangesKt.coerceAtLeast((int)n, (int)0) : 0;
        SECOND_LEVEL_POOL_BUCKET_SIZE = RangesKt.coerceAtLeast((int)(SECOND_LEVEL_POOL_TOTAL_SIZE / HASH_BUCKET_COUNT_L2), (int)8192);
        hashBuckets = new AtomicReferenceArray(HASH_BUCKET_COUNT);
        hashBucketsL2 = new AtomicReferenceArray(HASH_BUCKET_COUNT_L2);
    }
}

