/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io;

import java.io.EOFException;
import kotlin.KotlinNothingValueException;
import kotlin.PublishedApi;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.CoreKt;
import kotlinx.io.InternalIoApi;
import kotlinx.io.PeekSource;
import kotlinx.io.RawSink;
import kotlinx.io.RawSource;
import kotlinx.io.Segment;
import kotlinx.io.SegmentKt;
import kotlinx.io.SegmentPool;
import kotlinx.io.Sink;
import kotlinx.io.Source;
import kotlinx.io._UtilKt;
import kotlinx.io.unsafe.SegmentReadContext;
import kotlinx.io.unsafe.UnsafeBufferOperations;
import kotlinx.io.unsafe.UnsafeBufferOperationsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Buffer.kt\nkotlinx/io/Buffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 -Util.kt\nkotlinx/io/_UtilKt\n+ 4 Buffer.kt\nkotlinx/io/BufferKt\n+ 5 UnsafeBufferOperations.kt\nkotlinx/io/unsafe/UnsafeBufferOperations\n*L\n1#1,686:1\n628#1,14:689\n630#1,12:743\n1#2:687\n1#2:729\n1#2:734\n1#2:737\n1#2:741\n95#3:688\n52#3:728\n53#3:730\n107#3:731\n38#3:732\n52#3:733\n53#3:735\n52#3:736\n53#3:738\n38#3:739\n52#3:740\n53#3:742\n110#3:755\n89#3:759\n95#3:760\n659#4,25:703\n378#5,3:756\n381#5,3:761\n*S KotlinDebug\n*F\n+ 1 Buffer.kt\nkotlinx/io/Buffer\n*L\n228#1:689,14\n484#1:743,12\n290#1:729\n322#1:734\n330#1:737\n388#1:741\n118#1:688\n290#1:728\n290#1:730\n295#1:731\n307#1:732\n322#1:733\n322#1:735\n330#1:736\n330#1:738\n376#1:739\n388#1:740\n388#1:742\n562#1:755\n572#1:759\n573#1:760\n270#1:703,25\n566#1:756,3\n566#1:761,3\n*E\n"})
public final class Buffer
implements Sink,
Source {
    @Nullable
    private Segment head;
    @Nullable
    private Segment tail;
    private long sizeMut;

    public final /* synthetic */ Segment getHead() {
        return this.head;
    }

    public final /* synthetic */ void setHead(Segment segment) {
        this.head = segment;
    }

    @PublishedApi
    public static /* synthetic */ void getHead$annotations() {
    }

    public final /* synthetic */ Segment getTail() {
        return this.tail;
    }

    public final /* synthetic */ void setTail(Segment segment) {
        this.tail = segment;
    }

    @PublishedApi
    public static /* synthetic */ void getTail$annotations() {
    }

    public final long getSize() {
        return this.sizeMut;
    }

    public final /* synthetic */ long getSizeMut() {
        return this.sizeMut;
    }

    public final /* synthetic */ void setSizeMut(long l) {
        this.sizeMut = l;
    }

    @PublishedApi
    public static /* synthetic */ void getSizeMut$annotations() {
    }

    @Override
    @NotNull
    public Buffer getBuffer() {
        return this;
    }

    @InternalIoApi
    public static /* synthetic */ void getBuffer$annotations() {
    }

    @Override
    public boolean exhausted() {
        return this.getSize() == 0L;
    }

    @Override
    public void require(long byteCount) {
        if (!(byteCount >= 0L)) {
            boolean bl = false;
            String string = "byteCount: " + byteCount;
            throw new IllegalArgumentException(string.toString());
        }
        if (this.getSize() < byteCount) {
            throw new EOFException("Buffer doesn't contain required number of bytes (size: " + this.getSize() + ", required: " + byteCount + ')');
        }
    }

    @Override
    public boolean request(long byteCount) {
        if (!(byteCount >= 0L)) {
            boolean bl = false;
            String string = "byteCount: " + byteCount + " < 0";
            throw new IllegalArgumentException(string.toString());
        }
        return this.getSize() >= byteCount;
    }

    @Override
    public byte readByte() {
        Segment segment = this.head;
        if (segment == null) {
            this.throwEof(1L);
            throw new KotlinNothingValueException();
        }
        Segment segment2 = segment;
        int segmentSize = segment2.getSize();
        if (segmentSize == 0) {
            this.recycleHead$kotlinx_io_core();
            return this.readByte();
        }
        byte v = segment2.readByte$kotlinx_io_core();
        --this.sizeMut;
        if (segmentSize == 1) {
            this.recycleHead$kotlinx_io_core();
        }
        return v;
    }

    @Override
    public short readShort() {
        Segment segment = this.head;
        if (segment == null) {
            this.throwEof(2L);
            throw new KotlinNothingValueException();
        }
        Segment segment2 = segment;
        int segmentSize = segment2.getSize();
        if (segmentSize < 2) {
            byte $this$and$iv;
            this.require(2L);
            if (segmentSize == 0) {
                this.recycleHead$kotlinx_io_core();
                return this.readShort();
            }
            byte by = this.readByte();
            int other$iv = 255;
            boolean $i$f$and = false;
            int n = ($this$and$iv & other$iv) << 8;
            $this$and$iv = this.readByte();
            other$iv = 255;
            $i$f$and = false;
            return (short)(n | $this$and$iv & other$iv);
        }
        short v = segment2.readShort$kotlinx_io_core();
        this.sizeMut -= 2L;
        if (segmentSize == 2) {
            this.recycleHead$kotlinx_io_core();
        }
        return v;
    }

    @Override
    public int readInt() {
        Segment segment = this.head;
        if (segment == null) {
            this.throwEof(4L);
            throw new KotlinNothingValueException();
        }
        Segment segment2 = segment;
        int segmentSize = segment2.getSize();
        if (segmentSize < 4) {
            this.require(4L);
            if (segmentSize == 0) {
                this.recycleHead$kotlinx_io_core();
                return this.readInt();
            }
            return this.readShort() << 16 | this.readShort() & 0xFFFF;
        }
        int v = segment2.readInt$kotlinx_io_core();
        this.sizeMut -= 4L;
        if (segmentSize == 4) {
            this.recycleHead$kotlinx_io_core();
        }
        return v;
    }

    @Override
    public long readLong() {
        Segment segment = this.head;
        if (segment == null) {
            this.throwEof(8L);
            throw new KotlinNothingValueException();
        }
        Segment segment2 = segment;
        int segmentSize = segment2.getSize();
        if (segmentSize < 8) {
            this.require(8L);
            if (segmentSize == 0) {
                this.recycleHead$kotlinx_io_core();
                return this.readLong();
            }
            return (long)this.readInt() << 32 | (long)this.readInt() & 0xFFFFFFFFL;
        }
        long v = segment2.readLong$kotlinx_io_core();
        this.sizeMut -= 8L;
        if (segmentSize == 8) {
            this.recycleHead$kotlinx_io_core();
        }
        return v;
    }

    private final Void throwEof(long byteCount) {
        throw new EOFException("Buffer doesn't contain required number of bytes (size: " + this.getSize() + ", required: " + byteCount + ')');
    }

    @Override
    @InternalIoApi
    public void hintEmit() {
    }

    @Override
    public void emit() {
    }

    @Override
    public void flush() {
    }

    public final void copyTo(@NotNull Buffer out, long startIndex, long endIndex) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        _UtilKt.checkBounds(this.getSize(), startIndex, endIndex);
        if (startIndex == endIndex) {
            return;
        }
        long currentOffset = startIndex;
        long remainingByteCount = endIndex - startIndex;
        out.sizeMut += remainingByteCount;
        Segment s = this.head;
        while (true) {
            Segment segment = s;
            Intrinsics.checkNotNull((Object)segment);
            if (currentOffset < (long)(segment.getLimit() - s.getPos())) break;
            currentOffset -= (long)(s.getLimit() - s.getPos());
            s = s.getNext();
        }
        while (remainingByteCount > 0L) {
            Segment segment = s;
            Intrinsics.checkNotNull((Object)segment);
            Segment copy2 = segment.sharedCopy$kotlinx_io_core();
            copy2.setPos(copy2.getPos() + (int)currentOffset);
            copy2.setLimit(Math.min(copy2.getPos() + (int)remainingByteCount, copy2.getLimit()));
            boolean tryCompact$iv = false;
            boolean $i$f$pushSegment = false;
            if (out.getHead() == null) {
                out.setHead(copy2);
                out.setTail(copy2);
            } else {
                Segment segment2 = out.getTail();
                Intrinsics.checkNotNull((Object)segment2);
                out.setTail(segment2.push$kotlinx_io_core(copy2));
            }
            remainingByteCount -= (long)(copy2.getLimit() - copy2.getPos());
            currentOffset = 0L;
            s = s.getNext();
        }
    }

    public static /* synthetic */ void copyTo$default(Buffer buffer, Buffer buffer2, long l, long l2, int n, Object object) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        if ((n & 4) != 0) {
            l2 = buffer.getSize();
        }
        buffer.copyTo(buffer2, l, l2);
    }

    public final long completeSegmentByteCount$kotlinx_io_core() {
        long result2 = this.getSize();
        if (result2 == 0L) {
            return 0L;
        }
        Segment segment = this.tail;
        Intrinsics.checkNotNull((Object)segment);
        Segment tail = segment;
        if (tail.getLimit() < 8192 && tail.owner) {
            result2 -= (long)(tail.getLimit() - tail.getPos());
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    public final byte get(long position) {
        void offset;
        long nextOffset$iv;
        Segment s$iv;
        if (position < 0L || position >= this.getSize()) {
            throw new IndexOutOfBoundsException("position (" + position + ") is not within the range [0..size(" + this.getSize() + "))");
        }
        if (position == 0L) {
            Segment segment = this.head;
            Intrinsics.checkNotNull((Object)segment);
            return segment.getUnchecked$kotlinx_io_core(0);
        }
        Buffer $this$seek$iv = this;
        boolean $i$f$seek = false;
        if ($this$seek$iv.getHead() == null) {
            void offset2;
            long l = -1L;
            Segment s = null;
            boolean bl = false;
            Segment segment = s;
            Intrinsics.checkNotNull(segment);
            return segment.getUnchecked$kotlinx_io_core((int)(position - offset2));
        }
        if ($this$seek$iv.getSize() - position < position) {
            void offset3;
            Segment s$iv2;
            long offset$iv = $this$seek$iv.getSize();
            for (s$iv2 = $this$seek$iv.getTail(); s$iv2 != null && offset$iv > position && (offset$iv -= (long)(s$iv2.getLimit() - s$iv2.getPos())) > position; s$iv2 = s$iv2.getPrev()) {
            }
            long l = offset$iv;
            Segment s = s$iv2;
            boolean bl = false;
            Segment segment = s;
            Intrinsics.checkNotNull((Object)segment);
            return segment.getUnchecked$kotlinx_io_core((int)(position - offset3));
        }
        long offset$iv = 0L;
        for (s$iv = $this$seek$iv.getHead(); s$iv != null && (nextOffset$iv = offset$iv + (long)(s$iv.getLimit() - s$iv.getPos())) <= position; s$iv = s$iv.getNext()) {
            offset$iv = nextOffset$iv;
        }
        long l = offset$iv;
        Segment s = s$iv;
        boolean bl = false;
        Segment segment = s;
        Intrinsics.checkNotNull((Object)segment);
        return segment.getUnchecked$kotlinx_io_core((int)(position - offset));
    }

    public final void clear() {
        this.skip(this.getSize());
    }

    @Override
    public void skip(long byteCount) {
        int toSkip;
        boolean $i$f$checkByteCount = false;
        if (!(byteCount >= 0L)) {
            boolean bl = false;
            String string = "byteCount (" + byteCount + ") < 0";
            throw new IllegalArgumentException(string.toString());
        }
        for (long remainingByteCount = byteCount; remainingByteCount > 0L; remainingByteCount -= (long)toSkip) {
            Segment head;
            if (this.head == null) {
                throw new EOFException("Buffer exhausted before skipping " + byteCount + " bytes.");
            }
            int b$iv = head.getLimit() - head.getPos();
            boolean $i$f$minOf = false;
            toSkip = (int)Math.min(remainingByteCount, (long)b$iv);
            this.sizeMut -= (long)toSkip;
            head.setPos(head.getPos() + toSkip);
            if (head.getPos() != head.getLimit()) continue;
            this.recycleHead$kotlinx_io_core();
        }
    }

    @Override
    public int readAtMostTo(@NotNull byte[] sink, int startIndex, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        int size$iv = sink.length;
        boolean $i$f$checkBounds = false;
        _UtilKt.checkBounds((long)size$iv, (long)startIndex, (long)endIndex);
        Segment segment = this.head;
        if (segment == null) {
            return -1;
        }
        Segment s = segment;
        int toCopy = Math.min(endIndex - startIndex, s.getSize());
        s.readTo$kotlinx_io_core(sink, startIndex, startIndex + toCopy);
        this.sizeMut -= (long)toCopy;
        if (SegmentKt.isEmpty(s)) {
            this.recycleHead$kotlinx_io_core();
        }
        return toCopy;
    }

    @Override
    public long readAtMostTo(@NotNull Buffer sink, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        boolean $i$f$checkByteCount = false;
        if (!(byteCount >= 0L)) {
            boolean bl = false;
            String string = "byteCount (" + byteCount + ") < 0";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.getSize() == 0L) {
            return -1L;
        }
        long bytesWritten = byteCount > this.getSize() ? this.getSize() : byteCount;
        sink.write(this, bytesWritten);
        return bytesWritten;
    }

    @Override
    public void readTo(@NotNull RawSink sink, long byteCount) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        boolean $i$f$checkByteCount = false;
        if (!(byteCount >= 0L)) {
            boolean bl = false;
            String string = "byteCount (" + byteCount + ") < 0";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.getSize() < byteCount) {
            sink.write(this, this.getSize());
            throw new EOFException("Buffer exhausted before writing " + byteCount + " bytes. Only " + this.getSize() + " bytes were written.");
        }
        sink.write(this, byteCount);
    }

    @Override
    public long transferTo(@NotNull RawSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        long byteCount = this.getSize();
        if (byteCount > 0L) {
            sink.write(this, byteCount);
        }
        return byteCount;
    }

    @Override
    @NotNull
    public Source peek() {
        return CoreKt.buffered(new PeekSource(this));
    }

    @PublishedApi
    public final /* synthetic */ Segment writableSegment(int minimumCapacity) {
        if (!(minimumCapacity >= 1 && minimumCapacity <= 8192)) {
            boolean $i$a$-require-Buffer$writableSegment$22 = false;
            String $i$a$-require-Buffer$writableSegment$22 = "unexpected capacity (" + minimumCapacity + "), should be in range [1, 8192]";
            throw new IllegalArgumentException($i$a$-require-Buffer$writableSegment$22.toString());
        }
        if (this.tail == null) {
            Segment result2;
            this.head = result2 = SegmentPool.take();
            this.tail = result2;
            return result2;
        }
        Segment segment = this.tail;
        Intrinsics.checkNotNull((Object)segment);
        Segment t2 = segment;
        if (t2.getLimit() + minimumCapacity > 8192 || !t2.owner) {
            Segment newTail;
            this.tail = newTail = t2.push$kotlinx_io_core(SegmentPool.take());
            return newTail;
        }
        return t2;
    }

    @Override
    public void write(@NotNull byte[] source, int startIndex, int endIndex) {
        int toCopy;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        int size$iv = source.length;
        boolean $i$f$checkBounds = false;
        _UtilKt.checkBounds((long)size$iv, (long)startIndex, (long)endIndex);
        for (int currentOffset = startIndex; currentOffset < endIndex; currentOffset += toCopy) {
            Segment tail = this.writableSegment(1);
            toCopy = Math.min(endIndex - currentOffset, tail.getRemainingCapacity());
            tail.write$kotlinx_io_core(source, currentOffset, currentOffset + toCopy);
        }
        this.sizeMut += (long)(endIndex - startIndex);
    }

    @Override
    public void write(@NotNull RawSource source, long byteCount) {
        long read2;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        boolean $i$f$checkByteCount = false;
        if (!(byteCount >= 0L)) {
            boolean bl = false;
            String string = "byteCount (" + byteCount + ") < 0";
            throw new IllegalArgumentException(string.toString());
        }
        for (long remainingByteCount = byteCount; remainingByteCount > 0L; remainingByteCount -= read2) {
            read2 = source.readAtMostTo(this, remainingByteCount);
            if (read2 != -1L) continue;
            throw new EOFException("Source exhausted before reading " + byteCount + " bytes. Only " + (byteCount - remainingByteCount) + " were read.");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(@NotNull Buffer source, long byteCount) {
        long movedByteCount;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!(source != this)) {
            boolean bl = false;
            String string = "source == this";
            throw new IllegalArgumentException(string.toString());
        }
        _UtilKt.checkOffsetAndCount(source.sizeMut, 0L, byteCount);
        for (long remainingByteCount = byteCount; remainingByteCount > 0L; remainingByteCount -= movedByteCount) {
            void this_$iv;
            Segment segmentToMove;
            Segment segment = source.head;
            Intrinsics.checkNotNull((Object)segment);
            if (remainingByteCount < (long)segment.getSize()) {
                Segment tail = this.tail;
                if (tail != null && tail.owner && remainingByteCount + (long)tail.getLimit() - (long)(tail.getShared$kotlinx_io_core() ? 0 : tail.getPos()) <= 8192L) {
                    Segment segment2 = source.head;
                    Intrinsics.checkNotNull((Object)segment2);
                    segment2.writeTo$kotlinx_io_core(tail, (int)remainingByteCount);
                    source.sizeMut -= remainingByteCount;
                    this.sizeMut += remainingByteCount;
                    return;
                }
                Segment segment3 = source.head;
                Intrinsics.checkNotNull((Object)segment3);
                source.head = segment3.split$kotlinx_io_core((int)remainingByteCount);
            }
            Intrinsics.checkNotNull((Object)source.head);
            movedByteCount = segmentToMove.getSize();
            source.head = segmentToMove.pop$kotlinx_io_core();
            if (source.head == null) {
                source.tail = null;
            }
            Buffer buffer = this;
            boolean tryCompact$iv = true;
            boolean $i$f$pushSegment = false;
            if (this_$iv.getHead() == null) {
                this_$iv.setHead(segmentToMove);
                this_$iv.setTail(segmentToMove);
            } else {
                Segment segment4 = this_$iv.getTail();
                Intrinsics.checkNotNull((Object)segment4);
                this_$iv.setTail(segment4.push$kotlinx_io_core(segmentToMove).compact$kotlinx_io_core());
                Segment segment5 = this_$iv.getTail();
                Intrinsics.checkNotNull((Object)segment5);
                if (segment5.getPrev() == null) {
                    this_$iv.setHead(this_$iv.getTail());
                }
            }
            source.sizeMut -= movedByteCount;
            this.sizeMut += movedByteCount;
        }
    }

    @Override
    public long transferFrom(@NotNull RawSource source) {
        long readCount;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        long totalBytesRead = 0L;
        while ((readCount = source.readAtMostTo(this, 8192L)) != -1L) {
            totalBytesRead += readCount;
        }
        return totalBytesRead;
    }

    @Override
    public void writeByte(byte by) {
        this.writableSegment(1).writeByte$kotlinx_io_core(by);
        ++this.sizeMut;
    }

    @Override
    public void writeShort(short s) {
        this.writableSegment(2).writeShort$kotlinx_io_core(s);
        this.sizeMut += 2L;
    }

    @Override
    public void writeInt(int n) {
        this.writableSegment(4).writeInt$kotlinx_io_core(n);
        this.sizeMut += 4L;
    }

    @Override
    public void writeLong(long l) {
        this.writableSegment(8).writeLong$kotlinx_io_core(l);
        this.sizeMut += 8L;
    }

    @NotNull
    public final Buffer copy() {
        Segment headCopy;
        Buffer result2 = new Buffer();
        if (this.getSize() == 0L) {
            return result2;
        }
        Segment segment = this.head;
        Intrinsics.checkNotNull((Object)segment);
        Segment head = segment;
        result2.head = headCopy = head.sharedCopy$kotlinx_io_core();
        result2.tail = headCopy;
        for (Segment s = head.getNext(); s != null; s = s.getNext()) {
            Segment segment2 = result2.tail;
            Intrinsics.checkNotNull((Object)segment2);
            result2.tail = segment2.push$kotlinx_io_core(s.sharedCopy$kotlinx_io_core());
        }
        result2.sizeMut = this.getSize();
        return result2;
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        if (this.getSize() == 0L) {
            return "Buffer(size=0)";
        }
        int maxPrintableBytes = 64;
        long b$iv = this.getSize();
        boolean $i$f$minOf = false;
        int len = (int)Math.min((long)maxPrintableBytes, b$iv);
        StringBuilder builder = new StringBuilder(len * 2 + (this.getSize() > (long)maxPrintableBytes ? 1 : 0));
        int bytesWritten = 0;
        UnsafeBufferOperations this_$iv = UnsafeBufferOperations.INSTANCE;
        boolean $i$f$forEachSegment = false;
        for (Segment curr$iv = this.getHead(); curr$iv != null; curr$iv = curr$iv.getNext()) {
            void segment;
            Segment segment2 = curr$iv;
            SegmentReadContext ctx = UnsafeBufferOperationsKt.getSegmentReadContextImpl();
            boolean bl = false;
            int idx = 0;
            while (bytesWritten < len && idx < segment.getSize()) {
                void $this$and$iv;
                byte $this$shr$iv;
                byte b = ctx.getUnchecked((Segment)segment, idx++);
                ++bytesWritten;
                byte by = b;
                int other$iv = 4;
                boolean $i$f$shr = false;
                StringBuilder stringBuilder = builder.append(_UtilKt.getHEX_DIGIT_CHARS()[$this$shr$iv >> other$iv & 0xF]);
                $this$shr$iv = b;
                other$iv = 15;
                boolean $i$f$and = false;
                stringBuilder.append(_UtilKt.getHEX_DIGIT_CHARS()[$this$and$iv & other$iv]);
            }
        }
        if (this.getSize() > (long)maxPrintableBytes) {
            builder.append('\u2026');
        }
        return "Buffer(size=" + this.getSize() + " hex=" + builder + ')';
    }

    public final void recycleHead$kotlinx_io_core() {
        Segment nextHead;
        Segment segment = this.head;
        Intrinsics.checkNotNull((Object)segment);
        Segment oldHead = segment;
        this.head = nextHead = oldHead.getNext();
        if (nextHead == null) {
            this.tail = null;
        } else {
            nextHead.setPrev(null);
        }
        oldHead.setNext(null);
        SegmentPool.recycle(oldHead);
    }

    @PublishedApi
    public final /* synthetic */ void recycleTail() {
        Segment newTail;
        Segment segment = this.tail;
        Intrinsics.checkNotNull((Object)segment);
        Segment oldTail = segment;
        this.tail = newTail = oldTail.getPrev();
        if (newTail == null) {
            this.head = null;
        } else {
            newTail.setNext(null);
        }
        oldTail.setPrev(null);
        SegmentPool.recycle(oldTail);
    }

    private final void pushSegment(Segment newTail, boolean tryCompact) {
        boolean $i$f$pushSegment = false;
        if (this.getHead() == null) {
            this.setHead(newTail);
            this.setTail(newTail);
        } else if (tryCompact) {
            Segment segment = this.getTail();
            Intrinsics.checkNotNull((Object)segment);
            this.setTail(segment.push$kotlinx_io_core(newTail).compact$kotlinx_io_core());
            Segment segment2 = this.getTail();
            Intrinsics.checkNotNull((Object)segment2);
            if (segment2.getPrev() == null) {
                this.setHead(this.getTail());
            }
        } else {
            Segment segment = this.getTail();
            Intrinsics.checkNotNull((Object)segment);
            this.setTail(segment.push$kotlinx_io_core(newTail));
        }
    }

    static /* synthetic */ void pushSegment$default(Buffer $this, Segment newTail, boolean tryCompact, int n, Object object) {
        if ((n & 2) != 0) {
            tryCompact = false;
        }
        boolean $i$f$pushSegment = false;
        if ($this.getHead() == null) {
            $this.setHead(newTail);
            $this.setTail(newTail);
        } else if (tryCompact) {
            Segment segment = $this.getTail();
            Intrinsics.checkNotNull((Object)segment);
            $this.setTail(segment.push$kotlinx_io_core(newTail).compact$kotlinx_io_core());
            Segment segment2 = $this.getTail();
            Intrinsics.checkNotNull((Object)segment2);
            if (segment2.getPrev() == null) {
                $this.setHead($this.getTail());
            }
        } else {
            Segment segment = $this.getTail();
            Intrinsics.checkNotNull((Object)segment);
            $this.setTail(segment.push$kotlinx_io_core(newTail));
        }
    }
}

