/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.collections.immutable.implementations.persistentOrderedMap;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlinx.collections.immutable.implementations.persistentOrderedMap.LinkedValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentOrderedMapLinksIterator<K, V>
implements Iterator<LinkedValue<V>>,
KMappedMarker {
    @Nullable
    private Object nextKey;
    @NotNull
    private final Map<K, LinkedValue<V>> hashMap;
    private int index;

    public PersistentOrderedMapLinksIterator(@Nullable Object nextKey, @NotNull Map<K, LinkedValue<V>> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"hashMap");
        this.nextKey = nextKey;
        this.hashMap = hashMap;
    }

    @Nullable
    public final Object getNextKey$kotlinx_collections_immutable() {
        return this.nextKey;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.hashMap.size();
    }

    @Override
    @NotNull
    public LinkedValue<V> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Map<K, LinkedValue<V>> map2 = this.hashMap;
        LinkedValue<V> linkedValue = map2.get(this.nextKey);
        if (linkedValue == null) {
            boolean bl = false;
            throw new ConcurrentModificationException("Hash code of a key (" + this.nextKey + ") has changed after it was added to the persistent map.");
        }
        LinkedValue<V> result2 = linkedValue;
        int n = this.index;
        this.index = n + 1;
        this.nextKey = result2.getNext();
        return result2;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

