/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.collections.immutable.implementations.persistentOrderedMap;

import kotlinx.collections.immutable.internal.EndOfChain;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LinkedValue<V> {
    private final V value;
    @Nullable
    private final Object previous;
    @Nullable
    private final Object next;

    public LinkedValue(V value2, @Nullable Object previous, @Nullable Object next2) {
        this.value = value2;
        this.previous = previous;
        this.next = next2;
    }

    public final V getValue() {
        return this.value;
    }

    @Nullable
    public final Object getPrevious() {
        return this.previous;
    }

    @Nullable
    public final Object getNext() {
        return this.next;
    }

    public LinkedValue(V value2) {
        this(value2, EndOfChain.INSTANCE, EndOfChain.INSTANCE);
    }

    public LinkedValue(V value2, @Nullable Object previous) {
        this(value2, previous, EndOfChain.INSTANCE);
    }

    @NotNull
    public final LinkedValue<V> withValue(V newValue) {
        return new LinkedValue<V>(newValue, this.previous, this.next);
    }

    @NotNull
    public final LinkedValue<V> withPrevious(@Nullable Object newPrevious) {
        return new LinkedValue<V>(this.value, newPrevious, this.next);
    }

    @NotNull
    public final LinkedValue<V> withNext(@Nullable Object newNext) {
        return new LinkedValue<V>(this.value, this.previous, newNext);
    }

    public final boolean getHasNext() {
        return this.next != EndOfChain.INSTANCE;
    }

    public final boolean getHasPrevious() {
        return this.previous != EndOfChain.INSTANCE;
    }
}

