/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.collections.immutable.implementations.immutableSet;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMutableIterator;
import kotlinx.collections.immutable.implementations.immutableSet.PersistentHashSetBuilder;
import kotlinx.collections.immutable.implementations.immutableSet.PersistentHashSetIterator;
import kotlinx.collections.immutable.implementations.immutableSet.TrieNode;
import kotlinx.collections.immutable.implementations.immutableSet.TrieNodeKt;
import kotlinx.collections.immutable.internal.CommonFunctionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PersistentHashSetMutableIterator<E>
extends PersistentHashSetIterator<E>
implements Iterator<E>,
KMutableIterator {
    @NotNull
    private final PersistentHashSetBuilder<E> builder;
    @Nullable
    private E lastIteratedElement;
    private boolean nextWasInvoked;
    private int expectedModCount;

    public PersistentHashSetMutableIterator(@NotNull PersistentHashSetBuilder<E> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        super(builder.getNode$kotlinx_collections_immutable());
        this.builder = builder;
        this.expectedModCount = this.builder.getModCount$kotlinx_collections_immutable();
    }

    @Override
    public E next() {
        this.checkForComodification();
        Object next2 = super.next();
        this.lastIteratedElement = next2;
        this.nextWasInvoked = true;
        return next2;
    }

    @Override
    public void remove() {
        this.checkNextWasInvoked();
        if (this.hasNext()) {
            Object currentElement = this.currentElement();
            Collection collection = this.builder;
            E e = this.lastIteratedElement;
            TypeIntrinsics.asMutableCollection((Object)collection).remove(e);
            Object e2 = currentElement;
            this.resetPath(e2 != null ? e2.hashCode() : 0, this.builder.getNode$kotlinx_collections_immutable(), currentElement, 0);
        } else {
            Collection collection = this.builder;
            E e = this.lastIteratedElement;
            TypeIntrinsics.asMutableCollection((Object)collection).remove(e);
        }
        this.lastIteratedElement = null;
        this.nextWasInvoked = false;
        this.expectedModCount = this.builder.getModCount$kotlinx_collections_immutable();
    }

    private final void resetPath(int hashCode, TrieNode<?> node2, E element, int pathIndex) {
        if (this.isCollision(node2)) {
            int index = ArraysKt.indexOf((Object[])node2.getBuffer(), element);
            CommonFunctionsKt.assert(index != -1);
            this.getPath().get(pathIndex).reset(node2.getBuffer(), index);
            this.setPathLastIndex(pathIndex);
            return;
        }
        int position = 1 << TrieNodeKt.indexSegment(hashCode, pathIndex * 5);
        int index = node2.indexOfCellAt$kotlinx_collections_immutable(position);
        this.getPath().get(pathIndex).reset(node2.getBuffer(), index);
        Object cell = node2.getBuffer()[index];
        if (cell instanceof TrieNode) {
            this.resetPath(hashCode, (TrieNode)cell, element, pathIndex + 1);
        } else {
            this.setPathLastIndex(pathIndex);
        }
    }

    private final boolean isCollision(TrieNode<?> node2) {
        return node2.getBitmap() == 0;
    }

    private final void checkNextWasInvoked() {
        if (!this.nextWasInvoked) {
            throw new IllegalStateException();
        }
    }

    private final void checkForComodification() {
        if (this.builder.getModCount$kotlinx_collections_immutable() != this.expectedModCount) {
            throw new ConcurrentModificationException();
        }
    }
}

