/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.collections.immutable.implementations.immutableMap;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlinx.collections.immutable.implementations.immutableMap.PersistentHashMapBuilder;
import kotlinx.collections.immutable.implementations.immutableMap.TrieNodeKt;
import kotlinx.collections.immutable.internal.CommonFunctionsKt;
import kotlinx.collections.immutable.internal.DeltaCounter;
import kotlinx.collections.immutable.internal.MutabilityOwnership;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nTrieNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrieNode.kt\nkotlinx/collections/immutable/implementations/immutableMap/TrieNode\n+ 2 ForEachOneBit.kt\nkotlinx/collections/immutable/internal/ForEachOneBitKt\n+ 3 TrieNode.kt\nkotlinx/collections/immutable/implementations/immutableMap/TrieNode$ModificationResult\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,889:1\n10#2,9:890\n10#2,9:899\n10#2,9:908\n83#3:917\n1#4:918\n1740#5,3:919\n*S KotlinDebug\n*F\n+ 1 TrieNode.kt\nkotlinx/collections/immutable/implementations/immutableMap/TrieNode\n*L\n597#1:890,9\n614#1:899,9\n618#1:908,9\n666#1:917\n666#1:918\n838#1:919,3\n*E\n"})
public final class TrieNode<K, V> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int dataMap;
    private int nodeMap;
    @Nullable
    private final MutabilityOwnership ownedBy;
    @NotNull
    private Object[] buffer;
    @NotNull
    private static final TrieNode EMPTY = new TrieNode(0, 0, new Object[0]);

    public TrieNode(int dataMap, int nodeMap, @NotNull Object[] buffer, @Nullable MutabilityOwnership ownedBy) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.dataMap = dataMap;
        this.nodeMap = nodeMap;
        this.ownedBy = ownedBy;
        this.buffer = buffer;
    }

    public TrieNode(int dataMap, int nodeMap, @NotNull Object[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this(dataMap, nodeMap, buffer, null);
    }

    private final ModificationResult<K, V> asInsertResult() {
        return new ModificationResult(this, 1);
    }

    private final ModificationResult<K, V> asUpdateResult() {
        return new ModificationResult(this, 0);
    }

    @NotNull
    public final Object[] getBuffer$kotlinx_collections_immutable() {
        return this.buffer;
    }

    public final int entryCount$kotlinx_collections_immutable() {
        return Integer.bitCount(this.dataMap);
    }

    public final boolean hasEntryAt$kotlinx_collections_immutable(int positionMask) {
        return (this.dataMap & positionMask) != 0;
    }

    private final boolean hasNodeAt(int positionMask) {
        return (this.nodeMap & positionMask) != 0;
    }

    public final int entryKeyIndex$kotlinx_collections_immutable(int positionMask) {
        return 2 * Integer.bitCount(this.dataMap & positionMask - 1);
    }

    public final int nodeIndex$kotlinx_collections_immutable(int positionMask) {
        return this.buffer.length - 1 - Integer.bitCount(this.nodeMap & positionMask - 1);
    }

    private final K keyAtIndex(int keyIndex) {
        return (K)this.buffer[keyIndex];
    }

    private final V valueAtKeyIndex(int keyIndex) {
        return (V)this.buffer[keyIndex + 1];
    }

    @NotNull
    public final TrieNode<K, V> nodeAtIndex$kotlinx_collections_immutable(int nodeIndex) {
        Object object = this.buffer[nodeIndex];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlinx.collections.immutable.implementations.immutableMap.TrieNode<K of kotlinx.collections.immutable.implementations.immutableMap.TrieNode, V of kotlinx.collections.immutable.implementations.immutableMap.TrieNode>");
        return (TrieNode)object;
    }

    private final TrieNode<K, V> insertEntryAt(int positionMask, K key, V value2) {
        int keyIndex = this.entryKeyIndex$kotlinx_collections_immutable(positionMask);
        Object[] newBuffer = TrieNodeKt.access$insertEntryAtIndex(this.buffer, keyIndex, key, value2);
        return new TrieNode<K, V>(this.dataMap | positionMask, this.nodeMap, newBuffer);
    }

    private final TrieNode<K, V> mutableInsertEntryAt(int positionMask, K key, V value2, MutabilityOwnership owner2) {
        int keyIndex = this.entryKeyIndex$kotlinx_collections_immutable(positionMask);
        if (this.ownedBy == owner2) {
            this.buffer = TrieNodeKt.access$insertEntryAtIndex(this.buffer, keyIndex, key, value2);
            this.dataMap |= positionMask;
            return this;
        }
        Object[] newBuffer = TrieNodeKt.access$insertEntryAtIndex(this.buffer, keyIndex, key, value2);
        return new TrieNode<K, V>(this.dataMap | positionMask, this.nodeMap, newBuffer, owner2);
    }

    private final TrieNode<K, V> updateValueAtIndex(int keyIndex, V value2) {
        Object[] objectArray = Arrays.copyOf(this.buffer, this.buffer.length);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
        Object[] newBuffer = objectArray;
        newBuffer[keyIndex + 1] = value2;
        return new TrieNode<K, V>(this.dataMap, this.nodeMap, newBuffer);
    }

    private final TrieNode<K, V> mutableUpdateValueAtIndex(int keyIndex, V value2, PersistentHashMapBuilder<K, V> mutator) {
        if (this.ownedBy == mutator.getOwnership$kotlinx_collections_immutable()) {
            this.buffer[keyIndex + 1] = value2;
            return this;
        }
        int n = mutator.getModCount$kotlinx_collections_immutable();
        mutator.setModCount$kotlinx_collections_immutable(n + 1);
        Object[] objectArray = Arrays.copyOf(this.buffer, this.buffer.length);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
        Object[] newBuffer = objectArray;
        newBuffer[keyIndex + 1] = value2;
        return new TrieNode<K, V>(this.dataMap, this.nodeMap, newBuffer, mutator.getOwnership$kotlinx_collections_immutable());
    }

    private final TrieNode<K, V> updateNodeAtIndex(int nodeIndex, int positionMask, TrieNode<K, V> newNode, MutabilityOwnership owner2) {
        Object[] newNodeBuffer = newNode.buffer;
        if (newNodeBuffer.length == 2 && newNode.nodeMap == 0) {
            if (this.buffer.length == 1) {
                newNode.dataMap = this.nodeMap;
                return newNode;
            }
            int keyIndex = this.entryKeyIndex$kotlinx_collections_immutable(positionMask);
            Object[] newBuffer = TrieNodeKt.access$replaceNodeWithEntry(this.buffer, nodeIndex, keyIndex, newNodeBuffer[0], newNodeBuffer[1]);
            return new TrieNode<K, V>(this.dataMap ^ positionMask, this.nodeMap ^ positionMask, newBuffer, owner2);
        }
        if (owner2 != null && this.ownedBy == owner2) {
            this.buffer[nodeIndex] = newNode;
            return this;
        }
        Object[] objectArray = Arrays.copyOf(this.buffer, this.buffer.length);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
        Object[] newBuffer = objectArray;
        newBuffer[nodeIndex] = newNode;
        return new TrieNode<K, V>(this.dataMap, this.nodeMap, newBuffer, owner2);
    }

    static /* synthetic */ TrieNode updateNodeAtIndex$default(TrieNode trieNode, int n, int n2, TrieNode trieNode2, MutabilityOwnership mutabilityOwnership, int n3, Object object) {
        if ((n3 & 8) != 0) {
            mutabilityOwnership = null;
        }
        return trieNode.updateNodeAtIndex(n, n2, trieNode2, mutabilityOwnership);
    }

    private final TrieNode<K, V> removeNodeAtIndex(int nodeIndex, int positionMask) {
        if (this.buffer.length == 1) {
            return null;
        }
        Object[] newBuffer = TrieNodeKt.access$removeNodeAtIndex(this.buffer, nodeIndex);
        return new TrieNode<K, V>(this.dataMap, this.nodeMap ^ positionMask, newBuffer);
    }

    private final TrieNode<K, V> mutableRemoveNodeAtIndex(int nodeIndex, int positionMask, MutabilityOwnership owner2) {
        if (this.buffer.length == 1) {
            return null;
        }
        if (this.ownedBy == owner2) {
            this.buffer = TrieNodeKt.access$removeNodeAtIndex(this.buffer, nodeIndex);
            this.nodeMap ^= positionMask;
            return this;
        }
        Object[] newBuffer = TrieNodeKt.access$removeNodeAtIndex(this.buffer, nodeIndex);
        return new TrieNode<K, V>(this.dataMap, this.nodeMap ^ positionMask, newBuffer, owner2);
    }

    private final Object[] bufferMoveEntryToNode(int keyIndex, int positionMask, int newKeyHash, K newKey, V newValue, int shift, MutabilityOwnership owner2) {
        K storedKey;
        K k = storedKey = this.keyAtIndex(keyIndex);
        int storedKeyHash = k != null ? k.hashCode() : 0;
        V storedValue = this.valueAtKeyIndex(keyIndex);
        TrieNode<K, V> newNode = this.makeNode(storedKeyHash, storedKey, storedValue, newKeyHash, newKey, newValue, shift + 5, owner2);
        int nodeIndex = this.nodeIndex$kotlinx_collections_immutable(positionMask) + 1;
        return TrieNodeKt.access$replaceEntryWithNode(this.buffer, keyIndex, nodeIndex, newNode);
    }

    private final TrieNode<K, V> moveEntryToNode(int keyIndex, int positionMask, int newKeyHash, K newKey, V newValue, int shift) {
        Object[] newBuffer = this.bufferMoveEntryToNode(keyIndex, positionMask, newKeyHash, newKey, newValue, shift, null);
        return new TrieNode<K, V>(this.dataMap ^ positionMask, this.nodeMap | positionMask, newBuffer);
    }

    private final TrieNode<K, V> mutableMoveEntryToNode(int keyIndex, int positionMask, int newKeyHash, K newKey, V newValue, int shift, MutabilityOwnership owner2) {
        if (this.ownedBy == owner2) {
            this.buffer = this.bufferMoveEntryToNode(keyIndex, positionMask, newKeyHash, newKey, newValue, shift, owner2);
            this.dataMap ^= positionMask;
            this.nodeMap |= positionMask;
            return this;
        }
        Object[] newBuffer = this.bufferMoveEntryToNode(keyIndex, positionMask, newKeyHash, newKey, newValue, shift, owner2);
        return new TrieNode<K, V>(this.dataMap ^ positionMask, this.nodeMap | positionMask, newBuffer, owner2);
    }

    private final TrieNode<K, V> makeNode(int keyHash1, K key1, V value1, int keyHash2, K key2, V value2, int shift, MutabilityOwnership owner2) {
        int setBit2;
        if (shift > 30) {
            Object[] objectArray = new Object[]{key1, value1, key2, value2};
            return new TrieNode<K, V>(0, 0, objectArray, owner2);
        }
        int setBit1 = TrieNodeKt.indexSegment(keyHash1, shift);
        if (setBit1 != (setBit2 = TrieNodeKt.indexSegment(keyHash2, shift))) {
            Object[] objectArray;
            Object[] objectArray2;
            if (setBit1 < setBit2) {
                objectArray2 = new Object[]{key1, value1, key2, value2};
                objectArray = objectArray2;
            } else {
                objectArray2 = new Object[]{key2, value2, key1, value1};
                objectArray = objectArray2;
            }
            Object[] nodeBuffer = objectArray;
            return new TrieNode<K, V>(1 << setBit1 | 1 << setBit2, 0, nodeBuffer, owner2);
        }
        TrieNode<K, V> node2 = this.makeNode(keyHash1, key1, value1, keyHash2, key2, value2, shift + 5, owner2);
        Object[] objectArray = new Object[]{node2};
        return new TrieNode<K, V>(0, 1 << setBit1, objectArray, owner2);
    }

    private final TrieNode<K, V> removeEntryAtIndex(int keyIndex, int positionMask) {
        if (this.buffer.length == 2) {
            return null;
        }
        Object[] newBuffer = TrieNodeKt.access$removeEntryAtIndex(this.buffer, keyIndex);
        return new TrieNode<K, V>(this.dataMap ^ positionMask, this.nodeMap, newBuffer);
    }

    private final TrieNode<K, V> mutableRemoveEntryAtIndex(int keyIndex, int positionMask, PersistentHashMapBuilder<K, V> mutator) {
        int n = mutator.size();
        mutator.setSize(n + -1);
        mutator.setOperationResult$kotlinx_collections_immutable(this.valueAtKeyIndex(keyIndex));
        if (this.buffer.length == 2) {
            return null;
        }
        if (this.ownedBy == mutator.getOwnership$kotlinx_collections_immutable()) {
            this.buffer = TrieNodeKt.access$removeEntryAtIndex(this.buffer, keyIndex);
            this.dataMap ^= positionMask;
            return this;
        }
        Object[] newBuffer = TrieNodeKt.access$removeEntryAtIndex(this.buffer, keyIndex);
        return new TrieNode<K, V>(this.dataMap ^ positionMask, this.nodeMap, newBuffer, mutator.getOwnership$kotlinx_collections_immutable());
    }

    private final TrieNode<K, V> collisionRemoveEntryAtIndex(int i2) {
        if (this.buffer.length == 2) {
            return null;
        }
        Object[] newBuffer = TrieNodeKt.access$removeEntryAtIndex(this.buffer, i2);
        return new TrieNode<K, V>(0, 0, newBuffer);
    }

    private final TrieNode<K, V> mutableCollisionRemoveEntryAtIndex(int i2, PersistentHashMapBuilder<K, V> mutator) {
        int n = mutator.size();
        mutator.setSize(n + -1);
        mutator.setOperationResult$kotlinx_collections_immutable(this.valueAtKeyIndex(i2));
        if (this.buffer.length == 2) {
            return null;
        }
        if (this.ownedBy == mutator.getOwnership$kotlinx_collections_immutable()) {
            this.buffer = TrieNodeKt.access$removeEntryAtIndex(this.buffer, i2);
            return this;
        }
        Object[] newBuffer = TrieNodeKt.access$removeEntryAtIndex(this.buffer, i2);
        return new TrieNode<K, V>(0, 0, newBuffer, mutator.getOwnership$kotlinx_collections_immutable());
    }

    private final int collisionKeyIndex(Object key) {
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)this.buffer.length)), (int)2);
        int i2 = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && i2 <= n || n2 < 0 && n <= i2) {
            while (true) {
                if (Intrinsics.areEqual((Object)key, this.keyAtIndex(i2))) {
                    return i2;
                }
                if (i2 == n) break;
                i2 += n2;
            }
        }
        return -1;
    }

    private final boolean collisionContainsKey(K key) {
        return this.collisionKeyIndex(key) != -1;
    }

    private final V collisionGet(K key) {
        int keyIndex = this.collisionKeyIndex(key);
        return keyIndex != -1 ? (V)this.valueAtKeyIndex(keyIndex) : null;
    }

    private final ModificationResult<K, V> collisionPut(K key, V value2) {
        int keyIndex = this.collisionKeyIndex(key);
        if (keyIndex != -1) {
            if (value2 == this.valueAtKeyIndex(keyIndex)) {
                return null;
            }
            Object[] objectArray = Arrays.copyOf(this.buffer, this.buffer.length);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
            Object[] newBuffer = objectArray;
            newBuffer[keyIndex + 1] = value2;
            return super.asUpdateResult();
        }
        Object[] newBuffer = TrieNodeKt.access$insertEntryAtIndex(this.buffer, 0, key, value2);
        return super.asInsertResult();
    }

    private final TrieNode<K, V> mutableCollisionPut(K key, V value2, PersistentHashMapBuilder<K, V> mutator) {
        int keyIndex = this.collisionKeyIndex(key);
        if (keyIndex != -1) {
            mutator.setOperationResult$kotlinx_collections_immutable(this.valueAtKeyIndex(keyIndex));
            if (this.ownedBy == mutator.getOwnership$kotlinx_collections_immutable()) {
                this.buffer[keyIndex + 1] = value2;
                return this;
            }
            int n = mutator.getModCount$kotlinx_collections_immutable();
            mutator.setModCount$kotlinx_collections_immutable(n + 1);
            Object[] objectArray = Arrays.copyOf(this.buffer, this.buffer.length);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
            Object[] newBuffer = objectArray;
            newBuffer[keyIndex + 1] = value2;
            return new TrieNode<K, V>(0, 0, newBuffer, mutator.getOwnership$kotlinx_collections_immutable());
        }
        int newBuffer = mutator.size();
        mutator.setSize(newBuffer + 1);
        Object[] newBuffer2 = TrieNodeKt.access$insertEntryAtIndex(this.buffer, 0, key, value2);
        return new TrieNode<K, V>(0, 0, newBuffer2, mutator.getOwnership$kotlinx_collections_immutable());
    }

    private final TrieNode<K, V> collisionRemove(K key) {
        int keyIndex = this.collisionKeyIndex(key);
        if (keyIndex != -1) {
            return this.collisionRemoveEntryAtIndex(keyIndex);
        }
        return this;
    }

    private final TrieNode<K, V> mutableCollisionRemove(K key, PersistentHashMapBuilder<K, V> mutator) {
        int keyIndex = this.collisionKeyIndex(key);
        if (keyIndex != -1) {
            return this.mutableCollisionRemoveEntryAtIndex(keyIndex, mutator);
        }
        return this;
    }

    private final TrieNode<K, V> mutableCollisionRemove(K key, V value2, PersistentHashMapBuilder<K, V> mutator) {
        int keyIndex = this.collisionKeyIndex(key);
        if (keyIndex != -1 && Intrinsics.areEqual(value2, this.valueAtKeyIndex(keyIndex))) {
            return this.mutableCollisionRemoveEntryAtIndex(keyIndex, mutator);
        }
        return this;
    }

    private final TrieNode<K, V> mutableCollisionPutAll(TrieNode<K, V> otherNode, DeltaCounter intersectionCounter, MutabilityOwnership owner2) {
        TrieNode<Object, V> trieNode;
        int newSize;
        CommonFunctionsKt.assert(this.nodeMap == 0);
        CommonFunctionsKt.assert(this.dataMap == 0);
        CommonFunctionsKt.assert(otherNode.nodeMap == 0);
        CommonFunctionsKt.assert(otherNode.dataMap == 0);
        Object[] objectArray = Arrays.copyOf(this.buffer, this.buffer.length + otherNode.buffer.length);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
        Object[] tempBuffer = objectArray;
        int i2 = this.buffer.length;
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)otherNode.buffer.length)), (int)2);
        int j = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && j <= n || n2 < 0 && n <= j) {
            while (true) {
                if (!this.collisionContainsKey(otherNode.buffer[j])) {
                    tempBuffer[i2] = otherNode.buffer[j];
                    tempBuffer[i2 + 1] = otherNode.buffer[j + 1];
                    i2 += 2;
                } else {
                    int n3 = intersectionCounter.getCount();
                    intersectionCounter.setCount(n3 + 1);
                }
                if (j == n) break;
                j += n2;
            }
        }
        if ((newSize = i2) == this.buffer.length) {
            trieNode = this;
        } else if (newSize == otherNode.buffer.length) {
            trieNode = otherNode;
        } else if (newSize == tempBuffer.length) {
            trieNode = new TrieNode<Object, V>(0, 0, tempBuffer, owner2);
        } else {
            Object[] objectArray2 = Arrays.copyOf(tempBuffer, newSize);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"copyOf(...)");
            trieNode = new TrieNode<K, V>(0, 0, objectArray2, owner2);
        }
        return trieNode;
    }

    private final TrieNode<K, V> mutablePutAllFromOtherNodeCell(TrieNode<K, V> otherNode, int positionMask, int shift, DeltaCounter intersectionCounter, PersistentHashMapBuilder<K, V> mutator) {
        TrieNode<K, V> trieNode;
        if (this.hasNodeAt(positionMask)) {
            TrieNode<K, V> targetNode = this.nodeAtIndex$kotlinx_collections_immutable(this.nodeIndex$kotlinx_collections_immutable(positionMask));
            if (super.hasNodeAt(positionMask)) {
                TrieNode<K, V> otherTargetNode = otherNode.nodeAtIndex$kotlinx_collections_immutable(otherNode.nodeIndex$kotlinx_collections_immutable(positionMask));
                trieNode = targetNode.mutablePutAll(otherTargetNode, shift + 5, intersectionCounter, mutator);
            } else if (otherNode.hasEntryAt$kotlinx_collections_immutable(positionMask)) {
                TrieNode<K, V> trieNode2;
                int keyIndex = otherNode.entryKeyIndex$kotlinx_collections_immutable(positionMask);
                K key = super.keyAtIndex(keyIndex);
                V value2 = super.valueAtKeyIndex(keyIndex);
                int oldSize = mutator.size();
                K k = key;
                TrieNode<K, V> it = trieNode2 = targetNode.mutablePut(k != null ? k.hashCode() : 0, key, value2, shift + 5, mutator);
                boolean bl = false;
                if (mutator.size() == oldSize) {
                    int n = intersectionCounter.getCount();
                    intersectionCounter.setCount(n + 1);
                }
                trieNode = trieNode2;
            } else {
                trieNode = targetNode;
            }
        } else if (super.hasNodeAt(positionMask)) {
            TrieNode<K, V> otherTargetNode = otherNode.nodeAtIndex$kotlinx_collections_immutable(otherNode.nodeIndex$kotlinx_collections_immutable(positionMask));
            if (this.hasEntryAt$kotlinx_collections_immutable(positionMask)) {
                K key;
                int keyIndex = this.entryKeyIndex$kotlinx_collections_immutable(positionMask);
                K k = key = this.keyAtIndex(keyIndex);
                if (otherTargetNode.containsKey(k != null ? k.hashCode() : 0, key, shift + 5)) {
                    int value2 = intersectionCounter.getCount();
                    intersectionCounter.setCount(value2 + 1);
                    trieNode = otherTargetNode;
                } else {
                    V value3 = this.valueAtKeyIndex(keyIndex);
                    K k2 = key;
                    trieNode = otherTargetNode.mutablePut(k2 != null ? k2.hashCode() : 0, key, value3, shift + 5, mutator);
                }
            } else {
                trieNode = otherTargetNode;
            }
        } else {
            int thisKeyIndex = this.entryKeyIndex$kotlinx_collections_immutable(positionMask);
            K thisKey = this.keyAtIndex(thisKeyIndex);
            V thisValue = this.valueAtKeyIndex(thisKeyIndex);
            int otherKeyIndex = otherNode.entryKeyIndex$kotlinx_collections_immutable(positionMask);
            K otherKey = super.keyAtIndex(otherKeyIndex);
            V otherValue = super.valueAtKeyIndex(otherKeyIndex);
            K k = thisKey;
            K k3 = otherKey;
            trieNode = this.makeNode(k != null ? k.hashCode() : 0, thisKey, thisValue, k3 != null ? k3.hashCode() : 0, otherKey, otherValue, shift + 5, mutator.getOwnership$kotlinx_collections_immutable());
        }
        return trieNode;
    }

    private final int calculateSize() {
        int numValues;
        if (this.nodeMap == 0) {
            return this.buffer.length / 2;
        }
        int result2 = numValues = Integer.bitCount(this.dataMap);
        int n = this.buffer.length;
        for (int i2 = numValues * 2; i2 < n; ++i2) {
            result2 += super.calculateSize();
        }
        return result2;
    }

    private final boolean elementsIdentityEquals(TrieNode<K, V> otherNode) {
        if (this == otherNode) {
            return true;
        }
        if (this.nodeMap != otherNode.nodeMap) {
            return false;
        }
        if (this.dataMap != otherNode.dataMap) {
            return false;
        }
        int n = this.buffer.length;
        for (int i2 = 0; i2 < n; ++i2) {
            if (this.buffer[i2] == otherNode.buffer[i2]) continue;
            return false;
        }
        return true;
    }

    public final boolean containsKey(int keyHash, K key, int shift) {
        int keyPositionMask = 1 << TrieNodeKt.indexSegment(keyHash, shift);
        if (this.hasEntryAt$kotlinx_collections_immutable(keyPositionMask)) {
            return Intrinsics.areEqual(key, this.keyAtIndex(this.entryKeyIndex$kotlinx_collections_immutable(keyPositionMask)));
        }
        if (this.hasNodeAt(keyPositionMask)) {
            TrieNode<K, V> targetNode = this.nodeAtIndex$kotlinx_collections_immutable(this.nodeIndex$kotlinx_collections_immutable(keyPositionMask));
            if (shift == 30) {
                return super.collisionContainsKey(key);
            }
            return targetNode.containsKey(keyHash, key, shift + 5);
        }
        return false;
    }

    @Nullable
    public final V get(int keyHash, K key, int shift) {
        int keyPositionMask = 1 << TrieNodeKt.indexSegment(keyHash, shift);
        if (this.hasEntryAt$kotlinx_collections_immutable(keyPositionMask)) {
            int keyIndex = this.entryKeyIndex$kotlinx_collections_immutable(keyPositionMask);
            if (Intrinsics.areEqual(key, this.keyAtIndex(keyIndex))) {
                return this.valueAtKeyIndex(keyIndex);
            }
            return null;
        }
        if (this.hasNodeAt(keyPositionMask)) {
            TrieNode<K, V> targetNode = this.nodeAtIndex$kotlinx_collections_immutable(this.nodeIndex$kotlinx_collections_immutable(keyPositionMask));
            if (shift == 30) {
                return super.collisionGet(key);
            }
            return targetNode.get(keyHash, key, shift + 5);
        }
        return null;
    }

    @NotNull
    public final TrieNode<K, V> mutablePutAll(@NotNull TrieNode<K, V> otherNode, int shift, @NotNull DeltaCounter intersectionCounter, @NotNull PersistentHashMapBuilder<K, V> mutator) {
        int index;
        int positionMask;
        int mask$iv;
        int bit$iv;
        TrieNode<K, V> trieNode;
        int positionMask2;
        int bit$iv2;
        Intrinsics.checkNotNullParameter(otherNode, (String)"otherNode");
        Intrinsics.checkNotNullParameter((Object)intersectionCounter, (String)"intersectionCounter");
        Intrinsics.checkNotNullParameter(mutator, (String)"mutator");
        if (this == otherNode) {
            intersectionCounter.plusAssign(this.calculateSize());
            return this;
        }
        if (shift > 30) {
            return this.mutableCollisionPutAll(otherNode, intersectionCounter, mutator.getOwnership$kotlinx_collections_immutable());
        }
        int newNodeMap = 0;
        newNodeMap = this.nodeMap | otherNode.nodeMap;
        int newDataMap = 0;
        newDataMap = (this.dataMap ^ otherNode.dataMap) & ~newNodeMap;
        int $this$forEachOneBit$iv = this.dataMap & otherNode.dataMap;
        boolean $i$f$forEachOneBit = false;
        int index$iv = 0;
        for (int mask$iv2 = $this$forEachOneBit$iv; mask$iv2 != 0; mask$iv2 ^= bit$iv2) {
            K rightKey;
            positionMask2 = bit$iv2 = Integer.lowestOneBit(mask$iv2);
            boolean bl = false;
            K leftKey = this.keyAtIndex(this.entryKeyIndex$kotlinx_collections_immutable(positionMask2));
            if (Intrinsics.areEqual(leftKey, rightKey = super.keyAtIndex(otherNode.entryKeyIndex$kotlinx_collections_immutable(positionMask2)))) {
                newDataMap |= positionMask2;
            } else {
                newNodeMap |= positionMask2;
            }
            ++index$iv;
        }
        if (!((newNodeMap & newDataMap) == 0)) {
            throw new IllegalStateException("Check failed.");
        }
        if (Intrinsics.areEqual((Object)this.ownedBy, (Object)mutator.getOwnership$kotlinx_collections_immutable()) && this.dataMap == newDataMap && this.nodeMap == newNodeMap) {
            trieNode = this;
        } else {
            Object[] newBuffer = new Object[Integer.bitCount(newDataMap) * 2 + Integer.bitCount(newNodeMap)];
            trieNode = new TrieNode<K, V>(newDataMap, newNodeMap, newBuffer);
        }
        TrieNode<K, V> mutableNode = trieNode;
        int $this$forEachOneBit$iv2 = newNodeMap;
        boolean $i$f$forEachOneBit2 = false;
        int index$iv2 = 0;
        for (mask$iv = $this$forEachOneBit$iv2; mask$iv != 0; mask$iv ^= bit$iv) {
            bit$iv = Integer.lowestOneBit(mask$iv);
            positionMask2 = index$iv2++;
            positionMask = bit$iv;
            boolean bl = false;
            int newNodeIndex = mutableNode.buffer.length - 1 - index;
            mutableNode.buffer[newNodeIndex] = super.mutablePutAllFromOtherNodeCell(otherNode, positionMask, shift, intersectionCounter, mutator);
        }
        $this$forEachOneBit$iv2 = newDataMap;
        $i$f$forEachOneBit2 = false;
        index$iv2 = 0;
        for (mask$iv = $this$forEachOneBit$iv2; mask$iv != 0; mask$iv ^= bit$iv) {
            int oldKeyIndex;
            bit$iv = Integer.lowestOneBit(mask$iv);
            index = index$iv2;
            positionMask = bit$iv;
            boolean bl = false;
            int newKeyIndex = index * 2;
            if (!otherNode.hasEntryAt$kotlinx_collections_immutable(positionMask)) {
                oldKeyIndex = this.entryKeyIndex$kotlinx_collections_immutable(positionMask);
                mutableNode.buffer[newKeyIndex] = super.keyAtIndex(oldKeyIndex);
                mutableNode.buffer[newKeyIndex + 1] = super.valueAtKeyIndex(oldKeyIndex);
            } else {
                oldKeyIndex = otherNode.entryKeyIndex$kotlinx_collections_immutable(positionMask);
                mutableNode.buffer[newKeyIndex] = super.keyAtIndex(oldKeyIndex);
                mutableNode.buffer[newKeyIndex + 1] = super.valueAtKeyIndex(oldKeyIndex);
                if (this.hasEntryAt$kotlinx_collections_immutable(positionMask)) {
                    int n = intersectionCounter.getCount();
                    intersectionCounter.setCount(n + 1);
                }
            }
            ++index$iv2;
        }
        return this.elementsIdentityEquals(mutableNode) ? this : (super.elementsIdentityEquals(mutableNode) ? otherNode : mutableNode);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ModificationResult<K, V> put(int keyHash, K key, V value2, int shift) {
        int keyPositionMask = 1 << TrieNodeKt.indexSegment(keyHash, shift);
        if (this.hasEntryAt$kotlinx_collections_immutable(keyPositionMask)) {
            int keyIndex = this.entryKeyIndex$kotlinx_collections_immutable(keyPositionMask);
            if (Intrinsics.areEqual(key, this.keyAtIndex(keyIndex))) {
                if (this.valueAtKeyIndex(keyIndex) == value2) {
                    return null;
                }
                return super.asUpdateResult();
            }
            return super.asInsertResult();
        }
        if (this.hasNodeAt(keyPositionMask)) {
            void node2;
            ModificationResult<K, V> modificationResult;
            ModificationResult<K, V> putResult;
            ModificationResult<K, V> modificationResult2;
            int nodeIndex = this.nodeIndex$kotlinx_collections_immutable(keyPositionMask);
            TrieNode<K, V> targetNode = this.nodeAtIndex$kotlinx_collections_immutable(nodeIndex);
            if (shift == 30 ? (modificationResult2 = super.collisionPut(key, value2)) == null : (modificationResult2 = targetNode.put(keyHash, key, value2, shift + 5)) == null) {
                return null;
            }
            ModificationResult<K, V> this_$iv = putResult = modificationResult2;
            boolean $i$f$replaceNode = false;
            ModificationResult<K, V> $this$replaceNode_u24lambda_u240$iv = modificationResult = this_$iv;
            boolean bl = false;
            TrieNode<K, V> trieNode = $this$replaceNode_u24lambda_u240$iv.getNode();
            ModificationResult<K, V> modificationResult3 = $this$replaceNode_u24lambda_u240$iv;
            boolean bl2 = false;
            modificationResult3.setNode(TrieNode.updateNodeAtIndex$default(this, nodeIndex, keyPositionMask, (TrieNode)node2, null, 8, null));
            return modificationResult;
        }
        return super.asInsertResult();
    }

    @NotNull
    public final TrieNode<K, V> mutablePut(int keyHash, K key, V value2, int shift, @NotNull PersistentHashMapBuilder<K, V> mutator) {
        Intrinsics.checkNotNullParameter(mutator, (String)"mutator");
        int keyPositionMask = 1 << TrieNodeKt.indexSegment(keyHash, shift);
        if (this.hasEntryAt$kotlinx_collections_immutable(keyPositionMask)) {
            int keyIndex = this.entryKeyIndex$kotlinx_collections_immutable(keyPositionMask);
            if (Intrinsics.areEqual(key, this.keyAtIndex(keyIndex))) {
                mutator.setOperationResult$kotlinx_collections_immutable(this.valueAtKeyIndex(keyIndex));
                if (this.valueAtKeyIndex(keyIndex) == value2) {
                    return this;
                }
                return this.mutableUpdateValueAtIndex(keyIndex, value2, mutator);
            }
            int n = mutator.size();
            mutator.setSize(n + 1);
            return this.mutableMoveEntryToNode(keyIndex, keyPositionMask, keyHash, key, value2, shift, mutator.getOwnership$kotlinx_collections_immutable());
        }
        if (this.hasNodeAt(keyPositionMask)) {
            TrieNode<K, V> newNode;
            int nodeIndex = this.nodeIndex$kotlinx_collections_immutable(keyPositionMask);
            TrieNode<K, V> targetNode = this.nodeAtIndex$kotlinx_collections_immutable(nodeIndex);
            TrieNode<K, V> trieNode = newNode = shift == 30 ? super.mutableCollisionPut(key, value2, mutator) : targetNode.mutablePut(keyHash, key, value2, shift + 5, mutator);
            if (targetNode == newNode) {
                return this;
            }
            return this.updateNodeAtIndex(nodeIndex, keyPositionMask, newNode, mutator.getOwnership$kotlinx_collections_immutable());
        }
        int n = mutator.size();
        mutator.setSize(n + 1);
        return this.mutableInsertEntryAt(keyPositionMask, key, value2, mutator.getOwnership$kotlinx_collections_immutable());
    }

    @Nullable
    public final TrieNode<K, V> remove(int keyHash, K key, int shift) {
        int keyPositionMask = 1 << TrieNodeKt.indexSegment(keyHash, shift);
        if (this.hasEntryAt$kotlinx_collections_immutable(keyPositionMask)) {
            int keyIndex = this.entryKeyIndex$kotlinx_collections_immutable(keyPositionMask);
            if (Intrinsics.areEqual(key, this.keyAtIndex(keyIndex))) {
                return this.removeEntryAtIndex(keyIndex, keyPositionMask);
            }
            return this;
        }
        if (this.hasNodeAt(keyPositionMask)) {
            int nodeIndex = this.nodeIndex$kotlinx_collections_immutable(keyPositionMask);
            TrieNode<K, V> targetNode = this.nodeAtIndex$kotlinx_collections_immutable(nodeIndex);
            TrieNode<K, V> newNode = shift == 30 ? super.collisionRemove(key) : targetNode.remove(keyHash, key, shift + 5);
            return this.replaceNode(targetNode, newNode, nodeIndex, keyPositionMask);
        }
        return this;
    }

    private final TrieNode<K, V> replaceNode(TrieNode<K, V> targetNode, TrieNode<K, V> newNode, int nodeIndex, int positionMask) {
        return newNode == null ? this.removeNodeAtIndex(nodeIndex, positionMask) : (targetNode != newNode ? TrieNode.updateNodeAtIndex$default(this, nodeIndex, positionMask, newNode, null, 8, null) : this);
    }

    @Nullable
    public final TrieNode<K, V> mutableRemove(int keyHash, K key, int shift, @NotNull PersistentHashMapBuilder<K, V> mutator) {
        Intrinsics.checkNotNullParameter(mutator, (String)"mutator");
        int keyPositionMask = 1 << TrieNodeKt.indexSegment(keyHash, shift);
        if (this.hasEntryAt$kotlinx_collections_immutable(keyPositionMask)) {
            int keyIndex = this.entryKeyIndex$kotlinx_collections_immutable(keyPositionMask);
            if (Intrinsics.areEqual(key, this.keyAtIndex(keyIndex))) {
                return this.mutableRemoveEntryAtIndex(keyIndex, keyPositionMask, mutator);
            }
            return this;
        }
        if (this.hasNodeAt(keyPositionMask)) {
            int nodeIndex = this.nodeIndex$kotlinx_collections_immutable(keyPositionMask);
            TrieNode<K, V> targetNode = this.nodeAtIndex$kotlinx_collections_immutable(nodeIndex);
            TrieNode<K, V> newNode = shift == 30 ? super.mutableCollisionRemove(key, mutator) : targetNode.mutableRemove(keyHash, key, shift + 5, mutator);
            return this.mutableReplaceNode(newNode, nodeIndex, keyPositionMask, mutator.getOwnership$kotlinx_collections_immutable());
        }
        return this;
    }

    private final TrieNode<K, V> mutableReplaceNode(TrieNode<K, V> newNode, int nodeIndex, int positionMask, MutabilityOwnership owner2) {
        return newNode == null ? this.mutableRemoveNodeAtIndex(nodeIndex, positionMask, owner2) : this.updateNodeAtIndex(nodeIndex, positionMask, newNode, owner2);
    }

    @Nullable
    public final TrieNode<K, V> mutableRemove(int keyHash, K key, V value2, int shift, @NotNull PersistentHashMapBuilder<K, V> mutator) {
        Intrinsics.checkNotNullParameter(mutator, (String)"mutator");
        int keyPositionMask = 1 << TrieNodeKt.indexSegment(keyHash, shift);
        if (this.hasEntryAt$kotlinx_collections_immutable(keyPositionMask)) {
            int keyIndex = this.entryKeyIndex$kotlinx_collections_immutable(keyPositionMask);
            if (Intrinsics.areEqual(key, this.keyAtIndex(keyIndex)) && Intrinsics.areEqual(value2, this.valueAtKeyIndex(keyIndex))) {
                return this.mutableRemoveEntryAtIndex(keyIndex, keyPositionMask, mutator);
            }
            return this;
        }
        if (this.hasNodeAt(keyPositionMask)) {
            int nodeIndex = this.nodeIndex$kotlinx_collections_immutable(keyPositionMask);
            TrieNode<K, V> targetNode = this.nodeAtIndex$kotlinx_collections_immutable(nodeIndex);
            TrieNode<K, V> newNode = shift == 30 ? super.mutableCollisionRemove(key, value2, mutator) : targetNode.mutableRemove(keyHash, key, value2, shift + 5, mutator);
            return this.mutableReplaceNode(newNode, nodeIndex, keyPositionMask, mutator.getOwnership$kotlinx_collections_immutable());
        }
        return this;
    }

    public final <K1, V1> boolean equalsWith$kotlinx_collections_immutable(@NotNull TrieNode<K1, V1> that, @NotNull Function2<? super V, ? super V1, Boolean> equalityComparator) {
        Intrinsics.checkNotNullParameter(that, (String)"that");
        Intrinsics.checkNotNullParameter(equalityComparator, (String)"equalityComparator");
        if (this == that) {
            return true;
        }
        if (this.dataMap != that.dataMap || this.nodeMap != that.nodeMap) {
            return false;
        }
        if (this.dataMap == 0 && this.nodeMap == 0) {
            boolean bl;
            block14: {
                if (this.buffer.length != that.buffer.length) {
                    return false;
                }
                Iterable $this$all$iv = (Iterable)RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)this.buffer.length)), (int)2);
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    Iterator iterator2 = $this$all$iv.iterator();
                    while (iterator2.hasNext()) {
                        boolean bl2;
                        int element$iv;
                        int i2 = element$iv = ((IntIterator)iterator2).nextInt();
                        boolean bl3 = false;
                        K1 thatKey = super.keyAtIndex(i2);
                        V1 thatValue = super.valueAtKeyIndex(i2);
                        int keyIndex = this.collisionKeyIndex(thatKey);
                        if (keyIndex != -1) {
                            V value2 = this.valueAtKeyIndex(keyIndex);
                            bl2 = (Boolean)equalityComparator.invoke(value2, thatValue);
                        } else {
                            bl2 = false;
                        }
                        if (bl2) continue;
                        bl = false;
                        break block14;
                    }
                    bl = true;
                }
            }
            return bl;
        }
        int valueSize = Integer.bitCount(this.dataMap) * 2;
        IntProgression $i$f$all = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)valueSize)), (int)2);
        int i3 = $i$f$all.getFirst();
        int n = $i$f$all.getLast();
        int n2 = $i$f$all.getStep();
        if (n2 > 0 && i3 <= n || n2 < 0 && n <= i3) {
            while (true) {
                if (!Intrinsics.areEqual(this.keyAtIndex(i3), super.keyAtIndex(i3))) {
                    return false;
                }
                if (!((Boolean)equalityComparator.invoke(this.valueAtKeyIndex(i3), super.valueAtKeyIndex(i3))).booleanValue()) {
                    return false;
                }
                if (i3 == n) break;
                i3 += n2;
            }
        }
        int n3 = this.buffer.length;
        for (int i4 = valueSize; i4 < n3; ++i4) {
            if (this.nodeAtIndex$kotlinx_collections_immutable(i4).equalsWith$kotlinx_collections_immutable(that.nodeAtIndex$kotlinx_collections_immutable(i4), equalityComparator)) continue;
            return false;
        }
        return true;
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TrieNode getEMPTY$kotlinx_collections_immutable() {
            return EMPTY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @SourceDebugExtension(value={"SMAP\nTrieNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrieNode.kt\nkotlinx/collections/immutable/implementations/immutableMap/TrieNode$ModificationResult\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,889:1\n1#2:890\n*E\n"})
    public static final class ModificationResult<K, V> {
        @NotNull
        private TrieNode<K, V> node;
        private final int sizeDelta;

        public ModificationResult(@NotNull TrieNode<K, V> node2, int sizeDelta) {
            Intrinsics.checkNotNullParameter(node2, (String)"node");
            this.node = node2;
            this.sizeDelta = sizeDelta;
        }

        @NotNull
        public final TrieNode<K, V> getNode() {
            return this.node;
        }

        public final void setNode(@NotNull TrieNode<K, V> trieNode) {
            Intrinsics.checkNotNullParameter(trieNode, (String)"<set-?>");
            this.node = trieNode;
        }

        public final int getSizeDelta() {
            return this.sizeDelta;
        }
    }
}

