/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.collections.immutable.implementations.immutableList;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.collections.immutable.PersistentList;
import kotlinx.collections.immutable.implementations.immutableList.AbstractPersistentList;
import kotlinx.collections.immutable.implementations.immutableList.BufferIterator;
import kotlinx.collections.immutable.implementations.immutableList.PersistentVector;
import kotlinx.collections.immutable.implementations.immutableList.PersistentVectorBuilder;
import kotlinx.collections.immutable.implementations.immutableList.UtilsKt;
import kotlinx.collections.immutable.internal.CommonFunctionsKt;
import kotlinx.collections.immutable.internal.ListImplementation;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nSmallPersistentVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SmallPersistentVector.kt\nkotlinx/collections/immutable/implementations/immutableList/SmallPersistentVector\n+ 2 extensions.kt\nkotlinx/collections/immutable/ExtensionsKt\n*L\n1#1,165:1\n41#2:166\n41#2:167\n*S KotlinDebug\n*F\n+ 1 SmallPersistentVector.kt\nkotlinx/collections/immutable/implementations/immutableList/SmallPersistentVector\n*L\n49#1:166\n95#1:167\n*E\n"})
public final class SmallPersistentVector<E>
extends AbstractPersistentList<E> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Object[] buffer;
    @NotNull
    private static final SmallPersistentVector EMPTY = new SmallPersistentVector(new Object[0]);

    public SmallPersistentVector(@NotNull Object[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.buffer = buffer;
        CommonFunctionsKt.assert(this.buffer.length <= 32);
    }

    public int getSize() {
        return this.buffer.length;
    }

    @Override
    @NotNull
    public PersistentList<E> add(E element) {
        if (this.size() < 32) {
            Object[] objectArray = Arrays.copyOf(this.buffer, this.size() + 1);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
            Object[] newBuffer = objectArray;
            newBuffer[this.size()] = element;
            return new SmallPersistentVector<E>(newBuffer);
        }
        Object[] tail = UtilsKt.presizedBufferWith(element);
        return new PersistentVector(this.buffer, tail, this.size() + 1, 0);
    }

    @Override
    @NotNull
    public PersistentList<E> addAll(@NotNull Collection<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (elements.isEmpty()) {
            return this;
        }
        if (this.size() + elements.size() <= 32) {
            Object[] objectArray = Arrays.copyOf(this.buffer, this.size() + elements.size());
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
            Object[] newBuffer = objectArray;
            int index = this.size();
            for (E element : elements) {
                newBuffer[index++] = element;
            }
            return new SmallPersistentVector<E>(newBuffer);
        }
        PersistentList $this$mutate$iv = this;
        boolean $i$f$mutate = false;
        PersistentList.Builder builder = $this$mutate$iv.builder();
        List it = builder;
        boolean bl = false;
        it.addAll(elements);
        return builder.build();
    }

    @Override
    @NotNull
    public PersistentList<E> removeAt(int index) {
        ListImplementation.checkElementIndex$kotlinx_collections_immutable(index, this.size());
        if (this.size() == 1) {
            return EMPTY;
        }
        Object[] objectArray = Arrays.copyOf(this.buffer, this.size() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
        Object[] newBuffer = objectArray;
        ArraysKt.copyInto((Object[])this.buffer, (Object[])newBuffer, (int)index, (int)(index + 1), (int)this.size());
        return new SmallPersistentVector<E>(newBuffer);
    }

    @Override
    @NotNull
    public PersistentList.Builder<E> builder() {
        return new PersistentVectorBuilder(this, null, this.buffer, 0);
    }

    @Override
    public int indexOf(Object element) {
        return ArraysKt.indexOf((Object[])this.buffer, (Object)element);
    }

    @Override
    public int lastIndexOf(Object element) {
        return ArraysKt.lastIndexOf((Object[])this.buffer, (Object)element);
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator(int index) {
        ListImplementation.checkPositionIndex$kotlinx_collections_immutable(index, this.size());
        return new BufferIterator<Object>(this.buffer, index, this.size());
    }

    @Override
    public E get(int index) {
        ListImplementation.checkElementIndex$kotlinx_collections_immutable(index, this.size());
        return (E)this.buffer[index];
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SmallPersistentVector getEMPTY() {
            return EMPTY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

