/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.collections.immutable.implementations.immutableList;

import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.collections.immutable.implementations.immutableList.AbstractListIterator;
import kotlinx.collections.immutable.implementations.immutableList.TrieIterator;
import kotlinx.collections.immutable.implementations.immutableList.UtilsKt;
import org.jetbrains.annotations.NotNull;

public final class PersistentVectorIterator<T>
extends AbstractListIterator<T> {
    @NotNull
    private final T[] tail;
    @NotNull
    private final TrieIterator<T> trieIterator;

    public PersistentVectorIterator(@NotNull Object[] root, @NotNull T[] tail, int index, int size, int trieHeight) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(tail, (String)"tail");
        super(index, size);
        this.tail = tail;
        int trieSize = UtilsKt.rootSize(size);
        int trieIndex = RangesKt.coerceAtMost((int)index, (int)trieSize);
        this.trieIterator = new TrieIterator(root, trieIndex, trieSize, trieHeight);
    }

    @Override
    public T next() {
        this.checkHasNext$kotlinx_collections_immutable();
        if (this.trieIterator.hasNext()) {
            int n = this.getIndex();
            this.setIndex(n + 1);
            return this.trieIterator.next();
        }
        int n = this.getIndex();
        this.setIndex(n + 1);
        return this.tail[n - this.trieIterator.getSize()];
    }

    @Override
    public T previous() {
        this.checkHasPrevious$kotlinx_collections_immutable();
        if (this.getIndex() > this.trieIterator.getSize()) {
            this.setIndex(this.getIndex() + -1);
            return this.tail[this.getIndex() - this.trieIterator.getSize()];
        }
        int n = this.getIndex();
        this.setIndex(n + -1);
        return this.trieIterator.previous();
    }
}

