/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import java.util.List;

public final class ThrowableUtil {
    public static <T extends Throwable> T unknownStackTrace(T cause, Class<?> clazz, String method) {
        cause.setStackTrace(new StackTraceElement[]{new StackTraceElement(clazz.getName(), method, null, -1)});
        return cause;
    }

    public static void addSuppressed(Throwable target, Throwable suppressed) {
        target.addSuppressed(suppressed);
    }

    public static void addSuppressedAndClear(Throwable target, List<Throwable> suppressed) {
        ThrowableUtil.addSuppressed(target, suppressed);
        suppressed.clear();
    }

    public static void addSuppressed(Throwable target, List<Throwable> suppressed) {
        for (Throwable t2 : suppressed) {
            ThrowableUtil.addSuppressed(target, t2);
        }
    }

    public static Throwable[] getSuppressed(Throwable source) {
        return source.getSuppressed();
    }
}

