/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.InternalThreadLocalMap;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.SystemPropertyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public final class StringUtil {
    public static final String NEWLINE = SystemPropertyUtil.get("line.separator", "\n");
    private static final String[] BYTE2HEX_PAD = new String[256];
    private static final String[] BYTE2HEX_NOPAD = new String[256];
    private static final byte[] HEX2B;

    private StringUtil() {
    }

    public static String byteToHexStringPadded(int value2) {
        return BYTE2HEX_PAD[value2 & 0xFF];
    }

    public static int decodeHexNibble(char c) {
        return HEX2B[c];
    }

    public static int decodeHexNibble(byte b) {
        return HEX2B[b];
    }

    public static byte decodeHexByte(CharSequence s, int pos) {
        int hi = StringUtil.decodeHexNibble(s.charAt(pos));
        int lo = StringUtil.decodeHexNibble(s.charAt(pos + 1));
        if (hi == -1 || lo == -1) {
            throw new IllegalArgumentException(String.format("invalid hex byte '%s' at index %d of '%s'", s.subSequence(pos, pos + 2), pos, s));
        }
        return (byte)((hi << 4) + lo);
    }

    public static String className(Object o) {
        if (o == null) {
            return "null_object";
        }
        return o.getClass().getName();
    }

    public static String simpleClassName(Object o) {
        if (o == null) {
            return "null_object";
        }
        return StringUtil.simpleClassName(o.getClass());
    }

    public static String simpleClassName(Class<?> clazz) {
        String className = ObjectUtil.checkNotNull(clazz, "clazz").getName();
        int lastDotIdx = className.lastIndexOf(46);
        if (lastDotIdx > -1) {
            return className.substring(lastDotIdx + 1);
        }
        return className;
    }

    public static CharSequence escapeCsv(CharSequence value2, boolean trimWhiteSpace) {
        int last;
        int start2;
        int length = ObjectUtil.checkNotNull(value2, "value").length();
        if (trimWhiteSpace) {
            start2 = StringUtil.indexOfFirstNonOwsChar(value2, length);
            last = StringUtil.indexOfLastNonOwsChar(value2, start2, length);
        } else {
            start2 = 0;
            last = length - 1;
        }
        if (start2 > last) {
            return "";
        }
        int firstUnescapedSpecial = -1;
        boolean quoted = false;
        if (StringUtil.isDoubleQuote(value2.charAt(start2))) {
            boolean bl = quoted = StringUtil.isDoubleQuote(value2.charAt(last)) && last > start2;
            if (quoted) {
                ++start2;
                --last;
            } else {
                firstUnescapedSpecial = start2;
            }
        }
        if (firstUnescapedSpecial < 0) {
            int i2;
            if (quoted) {
                for (i2 = start2; i2 <= last; ++i2) {
                    if (!StringUtil.isDoubleQuote(value2.charAt(i2))) continue;
                    if (i2 == last || !StringUtil.isDoubleQuote(value2.charAt(i2 + 1))) {
                        firstUnescapedSpecial = i2;
                        break;
                    }
                    ++i2;
                }
            } else {
                for (i2 = start2; i2 <= last; ++i2) {
                    char c = value2.charAt(i2);
                    if (c == '\n' || c == '\r' || c == ',') {
                        firstUnescapedSpecial = i2;
                        break;
                    }
                    if (!StringUtil.isDoubleQuote(c)) continue;
                    if (i2 == last || !StringUtil.isDoubleQuote(value2.charAt(i2 + 1))) {
                        firstUnescapedSpecial = i2;
                        break;
                    }
                    ++i2;
                }
            }
            if (firstUnescapedSpecial < 0) {
                return quoted ? value2.subSequence(start2 - 1, last + 2) : value2.subSequence(start2, last + 1);
            }
        }
        StringBuilder result2 = new StringBuilder(last - start2 + 1 + 7);
        result2.append('\"').append(value2, start2, firstUnescapedSpecial);
        for (int i3 = firstUnescapedSpecial; i3 <= last; ++i3) {
            char c = value2.charAt(i3);
            if (StringUtil.isDoubleQuote(c)) {
                result2.append('\"');
                if (i3 < last && StringUtil.isDoubleQuote(value2.charAt(i3 + 1))) {
                    ++i3;
                }
            }
            result2.append(c);
        }
        return result2.append('\"');
    }

    public static List<CharSequence> unescapeCsvFields(CharSequence value2) {
        ArrayList<CharSequence> unescaped = new ArrayList<CharSequence>(2);
        StringBuilder current = InternalThreadLocalMap.get().stringBuilder();
        boolean quoted = false;
        int last = value2.length() - 1;
        block8: for (int i2 = 0; i2 <= last; ++i2) {
            char c = value2.charAt(i2);
            if (quoted) {
                switch (c) {
                    case '\"': {
                        char next2;
                        if (i2 == last) {
                            unescaped.add(current.toString());
                            return unescaped;
                        }
                        if ((next2 = value2.charAt(++i2)) == '\"') {
                            current.append('\"');
                            break;
                        }
                        if (next2 == ',') {
                            quoted = false;
                            unescaped.add(current.toString());
                            current.setLength(0);
                            break;
                        }
                        throw StringUtil.newInvalidEscapedCsvFieldException(value2, i2 - 1);
                    }
                    default: {
                        current.append(c);
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case ',': {
                    unescaped.add(current.toString());
                    current.setLength(0);
                    continue block8;
                }
                case '\"': {
                    if (current.length() == 0) {
                        quoted = true;
                        continue block8;
                    }
                }
                case '\n': 
                case '\r': {
                    throw StringUtil.newInvalidEscapedCsvFieldException(value2, i2);
                }
                default: {
                    current.append(c);
                }
            }
        }
        if (quoted) {
            throw StringUtil.newInvalidEscapedCsvFieldException(value2, last);
        }
        unescaped.add(current.toString());
        return unescaped;
    }

    private static IllegalArgumentException newInvalidEscapedCsvFieldException(CharSequence value2, int index) {
        return new IllegalArgumentException("invalid escaped CSV field: " + value2 + " index: " + index);
    }

    public static boolean isSurrogate(char c) {
        return c >= '\ud800' && c <= '\udfff';
    }

    private static boolean isDoubleQuote(char c) {
        return c == '\"';
    }

    public static CharSequence trimOws(CharSequence value2) {
        int length = value2.length();
        if (length == 0) {
            return value2;
        }
        int start2 = StringUtil.indexOfFirstNonOwsChar(value2, length);
        int end = StringUtil.indexOfLastNonOwsChar(value2, start2, length);
        return start2 == 0 && end == length - 1 ? value2 : value2.subSequence(start2, end + 1);
    }

    public static CharSequence join(CharSequence separator, Iterable<? extends CharSequence> elements) {
        ObjectUtil.checkNotNull(separator, "separator");
        ObjectUtil.checkNotNull(elements, "elements");
        Iterator<? extends CharSequence> iterator2 = elements.iterator();
        if (!iterator2.hasNext()) {
            return "";
        }
        CharSequence firstElement = iterator2.next();
        if (!iterator2.hasNext()) {
            return firstElement;
        }
        StringBuilder builder = new StringBuilder(firstElement);
        do {
            builder.append(separator).append(iterator2.next());
        } while (iterator2.hasNext());
        return builder;
    }

    private static int indexOfFirstNonOwsChar(CharSequence value2, int length) {
        int i2;
        for (i2 = 0; i2 < length && StringUtil.isOws(value2.charAt(i2)); ++i2) {
        }
        return i2;
    }

    private static int indexOfLastNonOwsChar(CharSequence value2, int start2, int length) {
        int i2;
        for (i2 = length - 1; i2 > start2 && StringUtil.isOws(value2.charAt(i2)); --i2) {
        }
        return i2;
    }

    private static boolean isOws(char c) {
        return c == ' ' || c == '\t';
    }

    static {
        for (int i2 = 0; i2 < BYTE2HEX_PAD.length; ++i2) {
            String str = Integer.toHexString(i2);
            StringUtil.BYTE2HEX_PAD[i2] = i2 > 15 ? str : '0' + str;
            StringUtil.BYTE2HEX_NOPAD[i2] = str;
        }
        HEX2B = new byte[65536];
        Arrays.fill(HEX2B, (byte)-1);
        StringUtil.HEX2B[48] = 0;
        StringUtil.HEX2B[49] = 1;
        StringUtil.HEX2B[50] = 2;
        StringUtil.HEX2B[51] = 3;
        StringUtil.HEX2B[52] = 4;
        StringUtil.HEX2B[53] = 5;
        StringUtil.HEX2B[54] = 6;
        StringUtil.HEX2B[55] = 7;
        StringUtil.HEX2B[56] = 8;
        StringUtil.HEX2B[57] = 9;
        StringUtil.HEX2B[65] = 10;
        StringUtil.HEX2B[66] = 11;
        StringUtil.HEX2B[67] = 12;
        StringUtil.HEX2B[68] = 13;
        StringUtil.HEX2B[69] = 14;
        StringUtil.HEX2B[70] = 15;
        StringUtil.HEX2B[97] = 10;
        StringUtil.HEX2B[98] = 11;
        StringUtil.HEX2B[99] = 12;
        StringUtil.HEX2B[100] = 13;
        StringUtil.HEX2B[101] = 14;
        StringUtil.HEX2B[102] = 15;
    }
}

