/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.handler.codec.Headers;
import io.netty.handler.codec.HeadersUtils;
import io.netty.handler.codec.ValueConverter;
import io.netty.util.HashingStrategy;
import io.netty.util.internal.MathUtil;
import io.netty.util.internal.ObjectUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class DefaultHeaders<K, V, T extends Headers<K, V, T>>
implements Headers<K, V, T> {
    private final HeaderEntry<K, V>[] entries;
    protected final HeaderEntry<K, V> head;
    private final byte hashMask;
    private final ValueConverter<V> valueConverter;
    private final NameValidator<K> nameValidator;
    private final ValueValidator<V> valueValidator;
    private final HashingStrategy<K> hashingStrategy;
    int size;

    public DefaultHeaders(HashingStrategy<K> nameHashingStrategy, ValueConverter<V> valueConverter, NameValidator<K> nameValidator, int arraySizeHint) {
        this(nameHashingStrategy, valueConverter, nameValidator, arraySizeHint, ValueValidator.NO_VALIDATION);
    }

    public DefaultHeaders(HashingStrategy<K> nameHashingStrategy, ValueConverter<V> valueConverter, NameValidator<K> nameValidator, int arraySizeHint, ValueValidator<V> valueValidator) {
        this.valueConverter = ObjectUtil.checkNotNull(valueConverter, "valueConverter");
        this.nameValidator = ObjectUtil.checkNotNull(nameValidator, "nameValidator");
        this.hashingStrategy = ObjectUtil.checkNotNull(nameHashingStrategy, "nameHashingStrategy");
        this.valueValidator = ObjectUtil.checkNotNull(valueValidator, "valueValidator");
        this.entries = new HeaderEntry[MathUtil.findNextPositivePowerOfTwo(Math.max(2, Math.min(arraySizeHint, 128)))];
        this.hashMask = (byte)(this.entries.length - 1);
        this.head = new HeaderEntry();
    }

    @Override
    public V get(K name2) {
        ObjectUtil.checkNotNull(name2, "name");
        int h = this.hashingStrategy.hashCode(name2);
        int i2 = this.index(h);
        HeaderEntry<K, V> e = this.entries[i2];
        V value2 = null;
        while (e != null) {
            if (e.hash == h && this.hashingStrategy.equals(name2, e.key)) {
                value2 = e.value;
            }
            e = e.next;
        }
        return value2;
    }

    public V getAndRemove(K name2) {
        int h = this.hashingStrategy.hashCode(name2);
        return this.remove0(h, this.index(h), ObjectUtil.checkNotNull(name2, "name"));
    }

    @Override
    public List<V> getAll(K name2) {
        ObjectUtil.checkNotNull(name2, "name");
        LinkedList<V> values = new LinkedList<V>();
        int h = this.hashingStrategy.hashCode(name2);
        int i2 = this.index(h);
        HeaderEntry<K, V> e = this.entries[i2];
        while (e != null) {
            if (e.hash == h && this.hashingStrategy.equals(name2, e.key)) {
                values.addFirst(e.getValue());
            }
            e = e.next;
        }
        return values;
    }

    public Iterator<V> valueIterator(K name2) {
        return new ValueIterator(name2);
    }

    @Override
    public boolean contains(K name2) {
        return this.get(name2) != null;
    }

    public final boolean contains(K name2, V value2, HashingStrategy<? super V> valueHashingStrategy) {
        ObjectUtil.checkNotNull(name2, "name");
        int h = this.hashingStrategy.hashCode(name2);
        int i2 = this.index(h);
        HeaderEntry<K, V> e = this.entries[i2];
        while (e != null) {
            if (e.hash == h && this.hashingStrategy.equals(name2, e.key) && valueHashingStrategy.equals(value2, e.value)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.head.after;
    }

    @Override
    public Set<K> names() {
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet names = new LinkedHashSet(this.size());
        HeaderEntry e = this.head.after;
        while (e != this.head) {
            names.add(e.getKey());
            e = e.after;
        }
        return names;
    }

    public T add(K name2, V value2) {
        this.validateName(this.nameValidator, true, name2);
        this.validateValue(this.valueValidator, name2, value2);
        ObjectUtil.checkNotNull(value2, "value");
        int h = this.hashingStrategy.hashCode(name2);
        int i2 = this.index(h);
        this.add0(h, i2, name2, value2);
        return this.thisT();
    }

    public T addObject(K name2, Object value2) {
        return this.add(name2, this.fromObject(name2, value2));
    }

    public T addObject(K name2, Iterable<?> values) {
        for (Object value2 : values) {
            this.addObject(name2, value2);
        }
        return this.thisT();
    }

    public T add(Headers<? extends K, ? extends V, ?> headers2) {
        if (headers2 == this) {
            throw new IllegalArgumentException("can't add to itself.");
        }
        this.addImpl(headers2);
        return this.thisT();
    }

    protected void addImpl(Headers<? extends K, ? extends V, ?> headers2) {
        if (headers2 instanceof DefaultHeaders) {
            DefaultHeaders defaultHeaders = (DefaultHeaders)headers2;
            HeaderEntry e = defaultHeaders.head.after;
            if (defaultHeaders.hashingStrategy == this.hashingStrategy && defaultHeaders.nameValidator == this.nameValidator) {
                while (e != defaultHeaders.head) {
                    this.add0(e.hash, this.index(e.hash), e.key, e.value);
                    e = e.after;
                }
            } else {
                while (e != defaultHeaders.head) {
                    this.add(e.key, e.value);
                    e = e.after;
                }
            }
        } else {
            for (Map.Entry<K, V> header : headers2) {
                this.add(header.getKey(), header.getValue());
            }
        }
    }

    public T set(K name2, V value2) {
        this.validateName(this.nameValidator, false, name2);
        this.validateValue(this.valueValidator, name2, value2);
        ObjectUtil.checkNotNull(value2, "value");
        int h = this.hashingStrategy.hashCode(name2);
        int i2 = this.index(h);
        this.remove0(h, i2, name2);
        this.add0(h, i2, name2, value2);
        return this.thisT();
    }

    public T setObject(K name2, Object value2) {
        V convertedValue = ObjectUtil.checkNotNull(this.fromObject(name2, value2), "convertedValue");
        return this.set(name2, convertedValue);
    }

    public T setObject(K name2, Iterable<?> values) {
        this.validateName(this.nameValidator, false, name2);
        int h = this.hashingStrategy.hashCode(name2);
        int i2 = this.index(h);
        this.remove0(h, i2, name2);
        for (Object v : values) {
            if (v == null) break;
            V converted = this.fromObject(name2, v);
            this.validateValue(this.valueValidator, name2, converted);
            this.add0(h, i2, name2, converted);
        }
        return this.thisT();
    }

    public T setInt(K name2, int value2) {
        return this.set(name2, this.fromInt(name2, value2));
    }

    public T set(Headers<? extends K, ? extends V, ?> headers2) {
        if (headers2 != this) {
            this.clear();
            this.addImpl(headers2);
        }
        return this.thisT();
    }

    public boolean remove(K name2) {
        return this.getAndRemove(name2) != null;
    }

    public T clear() {
        Arrays.fill(this.entries, null);
        this.head.after = this.head;
        this.head.before = this.head.after;
        this.size = 0;
        return this.thisT();
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new HeaderIterator();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Headers)) {
            return false;
        }
        return this.equals((Headers)o, HashingStrategy.JAVA_HASHER);
    }

    public int hashCode() {
        return this.hashCode(HashingStrategy.JAVA_HASHER);
    }

    public final boolean equals(Headers<K, V, ?> h2, HashingStrategy<V> valueHashingStrategy) {
        if (h2.size() != this.size()) {
            return false;
        }
        if (this == h2) {
            return true;
        }
        for (K name2 : this.names()) {
            List<V> otherValues = h2.getAll(name2);
            List<V> values = this.getAll(name2);
            if (otherValues.size() != values.size()) {
                return false;
            }
            for (int i2 = 0; i2 < otherValues.size(); ++i2) {
                if (valueHashingStrategy.equals(otherValues.get(i2), values.get(i2))) continue;
                return false;
            }
        }
        return true;
    }

    public final int hashCode(HashingStrategy<V> valueHashingStrategy) {
        int result2 = -1028477387;
        for (K name2 : this.names()) {
            result2 = 31 * result2 + this.hashingStrategy.hashCode(name2);
            List<V> values = this.getAll(name2);
            for (int i2 = 0; i2 < values.size(); ++i2) {
                result2 = 31 * result2 + valueHashingStrategy.hashCode(values.get(i2));
            }
        }
        return result2;
    }

    public String toString() {
        return HeadersUtils.toString(this.getClass(), this.iterator(), this.size());
    }

    protected void validateName(NameValidator<K> validator, boolean forAdd, K name2) {
        validator.validateName(name2);
    }

    protected void validateValue(ValueValidator<V> validator, K name2, V value2) {
        try {
            validator.validate(value2);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Validation failed for header '" + name2 + "'", e);
        }
    }

    protected HeaderEntry<K, V> newHeaderEntry(int h, K name2, V value2, HeaderEntry<K, V> next2) {
        return new HeaderEntry<K, V>(h, name2, value2, next2, this.head);
    }

    protected ValueConverter<V> valueConverter() {
        return this.valueConverter;
    }

    private int index(int hash) {
        return hash & this.hashMask;
    }

    private void add0(int h, int i2, K name2, V value2) {
        this.entries[i2] = this.newHeaderEntry(h, name2, value2, this.entries[i2]);
        ++this.size;
    }

    private V remove0(int h, int i2, K name2) {
        HeaderEntry<K, V> e = this.entries[i2];
        if (e == null) {
            return null;
        }
        V value2 = null;
        HeaderEntry next2 = e.next;
        while (next2 != null) {
            if (next2.hash == h && this.hashingStrategy.equals(name2, next2.key)) {
                value2 = next2.value;
                e.next = next2.next;
                next2.remove();
                --this.size;
            } else {
                e = next2;
            }
            next2 = e.next;
        }
        e = this.entries[i2];
        if (e.hash == h && this.hashingStrategy.equals(name2, e.key)) {
            if (value2 == null) {
                value2 = e.value;
            }
            this.entries[i2] = e.next;
            e.remove();
            --this.size;
        }
        return value2;
    }

    HeaderEntry<K, V> remove0(HeaderEntry<K, V> entry, HeaderEntry<K, V> previous) {
        int i2 = this.index(entry.hash);
        HeaderEntry<K, V> firstEntry = this.entries[i2];
        if (firstEntry == entry) {
            this.entries[i2] = entry.next;
            previous = this.entries[i2];
        } else if (previous == null) {
            previous = firstEntry;
            HeaderEntry next2 = firstEntry.next;
            while (next2 != null && next2 != entry) {
                previous = next2;
                next2 = next2.next;
            }
            assert (next2 != null) : "Entry not found in its hash bucket: " + entry;
            previous.next = entry.next;
        } else {
            previous.next = entry.next;
        }
        entry.remove();
        --this.size;
        return previous;
    }

    private T thisT() {
        return (T)this;
    }

    private V fromObject(K name2, Object value2) {
        try {
            return this.valueConverter.convertObject(ObjectUtil.checkNotNull(value2, "value"));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Failed to convert object value for header '" + name2 + '\'', e);
        }
    }

    private V fromInt(K name2, int value2) {
        try {
            return this.valueConverter.convertInt(value2);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Failed to convert int value for header '" + name2 + '\'', e);
        }
    }

    public DefaultHeaders<K, V, T> copy() {
        DefaultHeaders<K, V, T> copy2 = new DefaultHeaders<K, V, T>(this.hashingStrategy, this.valueConverter, this.nameValidator, this.entries.length);
        copy2.addImpl(this);
        return copy2;
    }

    protected static class HeaderEntry<K, V>
    implements Map.Entry<K, V> {
        protected final int hash;
        protected final K key;
        protected V value;
        protected HeaderEntry<K, V> next;
        protected HeaderEntry<K, V> before;
        protected HeaderEntry<K, V> after;

        HeaderEntry(int hash, K key, V value2, HeaderEntry<K, V> next2, HeaderEntry<K, V> head) {
            this.hash = hash;
            this.key = key;
            this.value = value2;
            this.next = next2;
            this.after = head;
            this.before = head.before;
            this.pointNeighborsToThis();
        }

        HeaderEntry() {
            this.hash = -1;
            this.key = null;
            this.before = this.after = this;
        }

        protected final void pointNeighborsToThis() {
            this.before.after = this;
            this.after.before = this;
        }

        protected void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        @Override
        public final V setValue(V value2) {
            ObjectUtil.checkNotNull(value2, "value");
            V oldValue = this.value;
            this.value = value2;
            return oldValue;
        }

        public final String toString() {
            return this.key.toString() + '=' + this.value.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry other = (Map.Entry)o;
            return (this.getKey() == null ? other.getKey() == null : this.getKey().equals(other.getKey())) && (this.getValue() == null ? other.getValue() == null : this.getValue().equals(other.getValue()));
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }
    }

    private final class ValueIterator
    implements Iterator<V> {
        private final K name;
        private final int hash;
        private HeaderEntry<K, V> removalPrevious;
        private HeaderEntry<K, V> previous;
        private HeaderEntry<K, V> next;

        ValueIterator(K name2) {
            this.name = ObjectUtil.checkNotNull(name2, "name");
            this.hash = DefaultHeaders.this.hashingStrategy.hashCode(name2);
            this.calculateNext(DefaultHeaders.this.entries[DefaultHeaders.this.index(this.hash)]);
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.previous != null) {
                this.removalPrevious = this.previous;
            }
            this.previous = this.next;
            this.calculateNext(this.next.next);
            return this.previous.value;
        }

        @Override
        public void remove() {
            if (this.previous == null) {
                throw new IllegalStateException();
            }
            this.removalPrevious = DefaultHeaders.this.remove0(this.previous, this.removalPrevious);
            this.previous = null;
        }

        private void calculateNext(HeaderEntry<K, V> entry) {
            while (entry != null) {
                if (entry.hash == this.hash && DefaultHeaders.this.hashingStrategy.equals(this.name, entry.key)) {
                    this.next = entry;
                    return;
                }
                entry = entry.next;
            }
            this.next = null;
        }
    }

    private final class HeaderIterator
    implements Iterator<Map.Entry<K, V>> {
        private HeaderEntry<K, V> current;

        private HeaderIterator() {
            this.current = DefaultHeaders.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.current.after != DefaultHeaders.this.head;
        }

        @Override
        public Map.Entry<K, V> next() {
            this.current = this.current.after;
            if (this.current == DefaultHeaders.this.head) {
                throw new NoSuchElementException();
            }
            return this.current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("read only");
        }
    }

    public static interface ValueValidator<V> {
        public static final ValueValidator<?> NO_VALIDATION = new ValueValidator<Object>(){

            @Override
            public void validate(Object value2) {
            }
        };

        public void validate(V var1);
    }

    public static interface NameValidator<K> {
        public static final NameValidator NOT_NULL = new NameValidator(){

            public void validateName(Object name2) {
                ObjectUtil.checkNotNull(name2, "name");
            }
        };

        public void validateName(K var1);
    }
}

