/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.kotlin.sdk.shared;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import io.modelcontextprotocol.kotlin.sdk.JSONRPCMessage;
import io.modelcontextprotocol.kotlin.sdk.shared.ReadBufferKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.io.Buffer;
import kotlinx.io.BuffersKt;
import kotlinx.io.Sink;
import kotlinx.io.Utf8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReadBuffer {
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger(ReadBuffer::logger$lambda$0);
    @NotNull
    private final Buffer buffer = new Buffer();

    public final void append(@NotNull byte[] chunk2) {
        Intrinsics.checkNotNullParameter((Object)chunk2, (String)"chunk");
        Sink.write$default(this.buffer, chunk2, 0, 0, 6, null);
    }

    @Nullable
    public final JSONRPCMessage readMessage() {
        if (this.buffer.exhausted()) {
            return null;
        }
        long lfIndex = BuffersKt.indexOf$default(this.buffer, (byte)10, 0L, 0L, 6, null);
        long l = lfIndex;
        if (l == -1L) {
            return null;
        }
        if (l == 0L) {
            this.buffer.skip(1L);
            return null;
        }
        int skipBytes = 1;
        if (this.buffer.get(lfIndex - 1L) == 13) {
            --lfIndex;
            ++skipBytes;
        }
        String string = Utf8Kt.readString(this.buffer, lfIndex);
        this.buffer.skip(skipBytes);
        String line = string;
        try {
            return ReadBufferKt.deserializeMessage(line);
        }
        catch (Exception e) {
            this.logger.error((Throwable)e, () -> ReadBuffer.readMessage$lambda$1(line));
            int braceIndex = StringsKt.indexOf$default((CharSequence)line, (char)'{', (int)0, (boolean)false, (int)6, null);
            if (braceIndex != -1) {
                String string2 = line.substring(braceIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                String trimmed = string2;
                try {
                    return ReadBufferKt.deserializeMessage(trimmed);
                }
                catch (Exception ignored) {
                    this.logger.error((Throwable)ignored, () -> ReadBuffer.readMessage$lambda$2(line));
                }
            }
            return null;
        }
    }

    public final void clear() {
        this.buffer.clear();
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object readMessage$lambda$1(String $line) {
        return "Failed to deserialize message from line: " + $line + "\nAttempting to recover...";
    }

    private static final Object readMessage$lambda$2(String $line) {
        return "Deserialization failed for line: " + $line + "\nSkipping...";
    }
}

