/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.websocket;

import io.ktor.serialization.WebsocketContentConverter;
import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationEnvironment;
import io.ktor.server.application.BaseApplicationPlugin;
import io.ktor.server.application.DefaultApplicationEventsKt;
import io.ktor.server.application.PipelineCall;
import io.ktor.server.response.ApplicationSendPipeline;
import io.ktor.server.websocket.WebSocketUpgrade;
import io.ktor.server.websocket.WebSocketsKt;
import io.ktor.util.AttributeKey;
import io.ktor.util.pipeline.PipelineContext;
import io.ktor.util.reflect.TypeInfo;
import io.ktor.utils.io.KtorDsl;
import io.ktor.websocket.WebSocketExtension;
import io.ktor.websocket.WebSocketExtensionsConfig;
import java.util.List;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nWebSockets.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSockets.kt\nio/ktor/server/websocket/WebSockets\n+ 2 Attributes.kt\nio/ktor/util/AttributesKt\n+ 3 Type.kt\nio/ktor/util/reflect/TypeKt\n*L\n1#1,167:1\n21#2:168\n21#2:178\n69#3:169\n84#3,8:170\n69#3:179\n84#3,8:180\n*S KotlinDebug\n*F\n+ 1 WebSockets.kt\nio/ktor/server/websocket/WebSockets\n*L\n131#1:168\n139#1:178\n131#1:169\n131#1:170,8\n139#1:179\n139#1:180,8\n*E\n"})
public final class WebSockets
implements CoroutineScope {
    @NotNull
    public static final Plugin Plugin;
    private final long pingIntervalMillis;
    private final long timeoutMillis;
    private final long maxFrameSize;
    private final boolean masking;
    @NotNull
    private final WebSocketExtensionsConfig extensionsConfig;
    @Nullable
    private final WebsocketContentConverter contentConverter;
    @NotNull
    private final CompletableJob parent;
    @NotNull
    private static final AttributeKey<WebSockets> key;
    @NotNull
    private static final AttributeKey<List<WebSocketExtension<?>>> EXTENSIONS_KEY;

    private WebSockets(long pingIntervalMillis, long timeoutMillis, long maxFrameSize, boolean masking, WebSocketExtensionsConfig extensionsConfig, WebsocketContentConverter contentConverter) {
        this.pingIntervalMillis = pingIntervalMillis;
        this.timeoutMillis = timeoutMillis;
        this.maxFrameSize = maxFrameSize;
        this.masking = masking;
        this.extensionsConfig = extensionsConfig;
        this.contentConverter = contentConverter;
        this.parent = JobKt.Job$default(null, (int)1, null);
        if (!(this.pingIntervalMillis >= 0L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.timeoutMillis >= 0L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.maxFrameSize > 0L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final long getPingIntervalMillis() {
        return this.pingIntervalMillis;
    }

    public final long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public final long getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public final boolean getMasking() {
        return this.masking;
    }

    @NotNull
    public final WebSocketExtensionsConfig getExtensionsConfig() {
        return this.extensionsConfig;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return (CoroutineContext)this.parent;
    }

    private final void shutdown() {
        this.parent.complete();
    }

    public /* synthetic */ WebSockets(long pingIntervalMillis, long timeoutMillis, long maxFrameSize, boolean masking, WebSocketExtensionsConfig extensionsConfig, WebsocketContentConverter contentConverter, DefaultConstructorMarker $constructor_marker) {
        this(pingIntervalMillis, timeoutMillis, maxFrameSize, masking, extensionsConfig, contentConverter);
    }

    static {
        KType kType;
        Plugin = new Plugin(null);
        String name$iv = "WebSockets";
        boolean $i$f$AttributeKey = false;
        String string = name$iv;
        boolean $i$f$typeInfo = false;
        KClass kClass = Reflection.getOrCreateKotlinClass(WebSockets.class);
        boolean $i$f$typeOfOrNull = false;
        try {
            kType = Reflection.typeOf(WebSockets.class);
        }
        catch (Throwable throwable) {
            kType = null;
        }
        KType kType2 = kType;
        KClass kClass2 = kClass;
        TypeInfo typeInfo = new TypeInfo(kClass2, kType2);
        String string2 = string;
        key = new AttributeKey(string2, typeInfo);
        name$iv = "WebSocket extensions";
        $i$f$AttributeKey = false;
        string = name$iv;
        $i$f$typeInfo = false;
        kClass = Reflection.getOrCreateKotlinClass(List.class);
        $i$f$typeOfOrNull = false;
        try {
            kType = Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(WebSocketExtension.class, (KTypeProjection)KTypeProjection.Companion.getSTAR())));
        }
        catch (Throwable throwable) {
            kType = null;
        }
        kType2 = kType;
        kClass2 = kClass;
        typeInfo = new TypeInfo(kClass2, kType2);
        string2 = string;
        EXTENSIONS_KEY = new AttributeKey(string2, typeInfo);
    }

    public static final class Plugin
    implements BaseApplicationPlugin<Application, WebSocketOptions, WebSockets> {
        private Plugin() {
        }

        @Override
        @NotNull
        public AttributeKey<WebSockets> getKey() {
            return key;
        }

        @NotNull
        public final AttributeKey<List<WebSocketExtension<?>>> getEXTENSIONS_KEY() {
            return EXTENSIONS_KEY;
        }

        @Override
        @NotNull
        public WebSockets install(@NotNull Application pipeline, @NotNull Function1<? super WebSocketOptions, Unit> configure2) {
            WebSocketOptions config2;
            Intrinsics.checkNotNullParameter((Object)((Object)pipeline), (String)"pipeline");
            Intrinsics.checkNotNullParameter(configure2, (String)"configure");
            WebSocketOptions webSocketOptions = new WebSocketOptions();
            configure2.invoke((Object)webSocketOptions);
            WebSocketOptions $this$install_u24lambda_u241 = config2 = webSocketOptions;
            boolean bl = false;
            WebSockets webSockets = new WebSockets($this$install_u24lambda_u241.getPingPeriodMillis(), $this$install_u24lambda_u241.getTimeoutMillis(), $this$install_u24lambda_u241.getMaxFrameSize(), $this$install_u24lambda_u241.getMasking(), $this$install_u24lambda_u241.getExtensionsConfig$ktor_server_websockets(), $this$install_u24lambda_u241.getContentConverter(), null);
            pipeline.getMonitor().subscribe(DefaultApplicationEventsKt.getApplicationStopPreparing(), arg_0 -> Plugin.install$lambda$1$lambda$0(webSockets, arg_0));
            pipeline.getSendPipeline().intercept(ApplicationSendPipeline.Phases.getTransform(), (Function3)new Function3<PipelineContext<Object, PipelineCall>, Object, Continuation<? super Unit>, Object>(null){
                int label;
                /* synthetic */ Object L$0;

                /*
                 * WARNING - void declaration
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = this.L$0;
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            void it;
                            ResultKt.throwOnFailure((Object)$result);
                            if (!(it instanceof WebSocketUpgrade)) {
                                return Unit.INSTANCE;
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Object invoke(PipelineContext<Object, PipelineCall> p1, Object p2, Continuation<? super Unit> p3) {
                    Function3<PipelineContext<Object, PipelineCall>, Object, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                    function3.L$0 = p2;
                    return function3.invokeSuspend((Object)Unit.INSTANCE);
                }
            });
            return webSockets;
        }

        private static final Unit install$lambda$1$lambda$0(WebSockets $webSockets, ApplicationEnvironment it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            WebSocketsKt.getLOGGER().trace("Shutdown WebSockets due to application stop");
            $webSockets.shutdown();
            return Unit.INSTANCE;
        }

        public /* synthetic */ Plugin(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @KtorDsl
    public static final class WebSocketOptions {
        @NotNull
        private final WebSocketExtensionsConfig extensionsConfig = new WebSocketExtensionsConfig();
        private long pingPeriodMillis;
        private long timeoutMillis = 15000L;
        private long maxFrameSize = Long.MAX_VALUE;
        private boolean masking;
        @Nullable
        private WebsocketContentConverter contentConverter;

        @NotNull
        public final WebSocketExtensionsConfig getExtensionsConfig$ktor_server_websockets() {
            return this.extensionsConfig;
        }

        public final long getPingPeriodMillis() {
            return this.pingPeriodMillis;
        }

        public final long getTimeoutMillis() {
            return this.timeoutMillis;
        }

        public final long getMaxFrameSize() {
            return this.maxFrameSize;
        }

        public final boolean getMasking() {
            return this.masking;
        }

        @Nullable
        public final WebsocketContentConverter getContentConverter() {
            return this.contentConverter;
        }
    }
}

