/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.routing;

import io.ktor.server.application.PipelineCall;
import io.ktor.server.routing.RoutingNode;
import io.ktor.server.routing.RoutingResolveResult;
import io.ktor.server.routing.RoutingResolveTraceEntry;
import io.ktor.server.routing.Stack;
import java.util.ArrayList;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nRoutingResolveTrace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoutingResolveTrace.kt\nio/ktor/server/routing/RoutingResolveTrace\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,171:1\n1#2:172\n*E\n"})
public final class RoutingResolveTrace {
    @NotNull
    private final PipelineCall call;
    @NotNull
    private final List<String> segments;
    @NotNull
    private final Stack<RoutingResolveTraceEntry> stack;
    @Nullable
    private RoutingResolveTraceEntry routing;
    private RoutingResolveResult finalResult;
    @NotNull
    private final List<List<RoutingResolveResult.Success>> resolveCandidates;

    public RoutingResolveTrace(@NotNull PipelineCall call2, @NotNull List<String> segments) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        Intrinsics.checkNotNullParameter(segments, (String)"segments");
        this.call = call2;
        this.segments = segments;
        this.stack = new Stack();
        this.resolveCandidates = new ArrayList();
    }

    private final void register(RoutingResolveTraceEntry entry) {
        if (this.stack.empty()) {
            this.routing = entry;
        } else {
            this.stack.peek().append(entry);
        }
    }

    public final void begin(@NotNull RoutingNode route, int segmentIndex) {
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        this.stack.push(new RoutingResolveTraceEntry(route, segmentIndex, null, 4, null));
    }

    public final void finish(@NotNull RoutingNode route, int segmentIndex, @NotNull RoutingResolveResult result2) {
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        RoutingResolveTraceEntry entry = this.stack.pop();
        if (!Intrinsics.areEqual((Object)entry.getRoute(), (Object)route)) {
            boolean $i$a$-require-RoutingResolveTrace$finish$32 = false;
            String $i$a$-require-RoutingResolveTrace$finish$32 = "end should be called for the same route as begin";
            throw new IllegalArgumentException($i$a$-require-RoutingResolveTrace$finish$32.toString());
        }
        if (!(entry.getSegmentIndex() == segmentIndex)) {
            boolean bl = false;
            String string = "end should be called for the same segmentIndex as begin";
            throw new IllegalArgumentException(string.toString());
        }
        entry.setResult(result2);
        this.register(entry);
    }

    public final void skip(@NotNull RoutingNode route, int segmentIndex, @NotNull RoutingResolveResult result2) {
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        this.register(new RoutingResolveTraceEntry(route, segmentIndex, result2));
    }

    public final void registerFinalResult(@NotNull RoutingResolveResult result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        this.finalResult = result2;
    }

    @NotNull
    public String toString() {
        return "Trace for " + this.segments;
    }

    @NotNull
    public final String buildText() {
        StringBuilder stringBuilder;
        StringBuilder $this$buildText_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$buildText_u24lambda_u244.append(this.toString()).append('\n');
        RoutingResolveTraceEntry routingResolveTraceEntry = this.routing;
        if (routingResolveTraceEntry != null) {
            routingResolveTraceEntry.buildText($this$buildText_u24lambda_u244, 0);
        }
        if (this.finalResult != null) {
            $this$buildText_u24lambda_u244.append("Matched routes:").append('\n');
            StringBuilder stringBuilder2 = this.resolveCandidates.isEmpty() ? $this$buildText_u24lambda_u244.append("  No results").append('\n') : $this$buildText_u24lambda_u244.append(CollectionsKt.joinToString$default((Iterable)this.resolveCandidates, (CharSequence)"\n", null, null, (int)0, null, RoutingResolveTrace::buildText$lambda$4$lambda$3, (int)30, null)).append('\n');
            $this$buildText_u24lambda_u244.append("Routing resolve result:").append('\n');
            StringBuilder stringBuilder3 = new StringBuilder().append("  ");
            RoutingResolveResult routingResolveResult = this.finalResult;
            if (routingResolveResult == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"finalResult");
                routingResolveResult = null;
            }
            $this$buildText_u24lambda_u244.append(stringBuilder3.append(routingResolveResult).toString());
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final void addCandidate(@NotNull List<RoutingResolveResult.Success> trait) {
        Intrinsics.checkNotNullParameter(trait, (String)"trait");
        int n = trait.size();
        ArrayList<RoutingResolveResult.Success> arrayList = new ArrayList<RoutingResolveResult.Success>(n);
        int n2 = 0;
        while (n2 < n) {
            void it;
            int n3;
            int n4 = n3 = n2++;
            ArrayList<RoutingResolveResult.Success> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(trait.get((int)it));
        }
        List candidate = arrayList;
        this.resolveCandidates.add(candidate);
    }

    private static final CharSequence buildText$lambda$4$lambda$3$lambda$2(RoutingResolveResult.Success it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "" + '\"' + it.getRoute().getSelector() + '\"';
    }

    private static final CharSequence buildText$lambda$4$lambda$3(List path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return CollectionsKt.joinToString$default((Iterable)path2, (CharSequence)" -> ", (CharSequence)"  ", null, (int)0, null, RoutingResolveTrace::buildText$lambda$4$lambda$3$lambda$2, (int)28, null);
    }
}

