/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.routing;

import io.ktor.http.CodecsKt;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.ParametersBuilder;
import io.ktor.http.ParametersKt;
import io.ktor.http.URLDecodeException;
import io.ktor.server.application.PipelineCall;
import io.ktor.server.plugins.BadRequestException;
import io.ktor.server.request.ApplicationRequestPropertiesKt;
import io.ktor.server.routing.IgnoreTrailingSlashKt;
import io.ktor.server.routing.RouteSelectorEvaluation;
import io.ktor.server.routing.RoutingNode;
import io.ktor.server.routing.RoutingResolveContext;
import io.ktor.server.routing.RoutingResolveResult;
import io.ktor.server.routing.RoutingResolveTrace;
import io.ktor.util.StringValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nRoutingResolveContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoutingResolveContext.kt\nio/ktor/server/routing/RoutingResolveContext\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,256:1\n1104#2,3:257\n1#3:260\n1869#4,2:261\n1788#4,4:263\n1788#4,4:267\n1740#4,3:271\n*S KotlinDebug\n*F\n+ 1 RoutingResolveContext.kt\nio/ktor/server/routing/RoutingResolveContext\n*L\n64#1:257,3\n97#1:261,2\n235#1:263,4\n236#1:267,4\n246#1:271,3\n*E\n"})
public final class RoutingResolveContext {
    @NotNull
    private final RoutingNode routing;
    @NotNull
    private final PipelineCall call;
    @NotNull
    private final List<Function1<RoutingResolveTrace, Unit>> tracers;
    @NotNull
    private final List<String> segments;
    private final boolean hasTrailingSlash;
    @Nullable
    private final RoutingResolveTrace trace;
    @NotNull
    private final ArrayList<RoutingResolveResult.Success> resolveResult;
    @Nullable
    private RouteSelectorEvaluation.Failure failedEvaluation;
    private int failedEvaluationDepth;

    public RoutingResolveContext(@NotNull RoutingNode routing, @NotNull PipelineCall call2, @NotNull List<? extends Function1<? super RoutingResolveTrace, Unit>> tracers) {
        Intrinsics.checkNotNullParameter((Object)routing, (String)"routing");
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        Intrinsics.checkNotNullParameter(tracers, (String)"tracers");
        this.routing = routing;
        this.call = call2;
        this.tracers = tracers;
        this.hasTrailingSlash = StringsKt.endsWith$default((CharSequence)ApplicationRequestPropertiesKt.path(this.call.getRequest()), (char)'/', (boolean)false, (int)2, null);
        this.resolveResult = new ArrayList(16);
        this.failedEvaluation = RouteSelectorEvaluation.Companion.getFailedPath();
        try {
            this.segments = this.parse(ApplicationRequestPropertiesKt.path(this.call.getRequest()));
            this.trace = this.tracers.isEmpty() ? null : new RoutingResolveTrace(this.call, this.segments);
        }
        catch (URLDecodeException cause) {
            throw new BadRequestException("Url decode failed for " + ApplicationRequestPropertiesKt.getUri(this.call.getRequest()), cause);
        }
    }

    @NotNull
    public final PipelineCall getCall() {
        return this.call;
    }

    @NotNull
    public final List<String> getSegments() {
        return this.segments;
    }

    public final boolean getHasTrailingSlash() {
        return this.hasTrailingSlash;
    }

    private final List<String> parse(String path2) {
        if (((CharSequence)path2).length() == 0 || Intrinsics.areEqual((Object)path2, (Object)"/")) {
            return CollectionsKt.emptyList();
        }
        int length = path2.length();
        int beginSegment = 0;
        int nextSegment = 0;
        CharSequence $this$count$iv = path2;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int j = 0; j < $this$count$iv.length(); ++j) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(j);
            boolean bl = false;
            if (!(it == '/')) continue;
            ++count$iv;
        }
        int segmentCount = count$iv;
        ArrayList<String> segments = new ArrayList<String>(segmentCount);
        while (nextSegment < length) {
            nextSegment = StringsKt.indexOf$default((CharSequence)path2, (char)'/', (int)beginSegment, (boolean)false, (int)4, null);
            if (nextSegment == -1) {
                nextSegment = length;
            }
            if (nextSegment == beginSegment) {
                beginSegment = nextSegment + 1;
                continue;
            }
            String segment = CodecsKt.decodeURLPart$default((String)path2, (int)beginSegment, (int)nextSegment, null, (int)4, null);
            segments.add(segment);
            beginSegment = nextSegment + 1;
        }
        if (!IgnoreTrailingSlashKt.getIgnoreTrailingSlash(this.call) && StringsKt.endsWith$default((String)path2, (String)"/", (boolean)false, (int)2, null)) {
            segments.add("");
        }
        return segments;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object resolve(@NotNull Continuation<? super RoutingResolveResult> $completion) {
        if (!($completion instanceof resolve.1)) ** GOTO lbl-1000
        var13_2 = $completion;
        if ((var13_2.label & -2147483648) != 0) {
            var13_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ RoutingResolveContext this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.resolve((Continuation<? super RoutingResolveResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var14_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.handleRoute(this.routing, 0, new ArrayList<RoutingResolveResult.Success>(), -1.7976931348623157E308, (Continuation<? super Double>)$continuation);
                if (v0 == var14_4) {
                    return var14_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                resolveResult = this.findBestRoute();
                v1 = this.trace;
                if (v1 != null) {
                    v1.registerFinalResult(resolveResult);
                }
                v2 = this.trace;
                if (v2 != null) {
                    $this$resolve_u24lambda_u242 = var3_6 = v2;
                    $i$a$-apply-RoutingResolveContext$resolve$2 = false;
                    $this$forEach$iv = this.tracers;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (Function1)element$iv;
                        $i$a$-forEach-RoutingResolveContext$resolve$2$1 = false;
                        it.invoke((Object)$this$resolve_u24lambda_u242);
                    }
                }
                return resolveResult;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object handleRoute(RoutingNode entry, int segmentIndex, ArrayList<RoutingResolveResult.Success> trait, double matchedQuality, Continuation<? super Double> $completion) {
        if (!($completion instanceof handleRoute.1)) ** GOTO lbl-1000
        var19_6 = $completion;
        if ((var19_6.label & -2147483648) != 0) {
            var19_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                int I$0;
                int I$1;
                int I$2;
                int I$3;
                int I$4;
                double D$0;
                double D$1;
                /* synthetic */ Object result;
                final /* synthetic */ RoutingResolveContext this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RoutingResolveContext.access$handleRoute(this.this$0, null, 0, null, 0.0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var20_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = entry;
                $continuation.L$1 = trait;
                $continuation.I$0 = segmentIndex;
                $continuation.D$0 = matchedQuality;
                $continuation.label = 1;
                v0 = entry.getSelector().evaluate(this, segmentIndex, (Continuation<? super RouteSelectorEvaluation>)$continuation);
                if (v0 == var20_8) {
                    return var20_8;
                }
                ** GOTO lbl28
            }
            case 1: {
                matchedQuality = $continuation.D$0;
                segmentIndex = $continuation.I$0;
                trait = (ArrayList)$continuation.L$1;
                entry = (RoutingNode)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                if ((evaluation = (RouteSelectorEvaluation)v0) instanceof RouteSelectorEvaluation.Failure) {
                    v1 = this.trace;
                    if (v1 != null) {
                        v1.skip(entry, segmentIndex, new RoutingResolveResult.Failure(entry, "Selector didn't match", ((RouteSelectorEvaluation.Failure)evaluation).getFailureStatusCode()));
                    }
                    if (segmentIndex == this.segments.size()) {
                        this.updateFailedEvaluation((RouteSelectorEvaluation.Failure)evaluation, trait);
                    }
                    return Boxing.boxDouble((double)-1.7976931348623157E308);
                }
                if (!(evaluation instanceof RouteSelectorEvaluation.Success)) {
                    throw new IllegalStateException("Check failed.");
                }
                if (!(((RouteSelectorEvaluation.Success)evaluation).getQuality() == -1.0) && ((RouteSelectorEvaluation.Success)evaluation).getQuality() < matchedQuality) {
                    v2 = this.trace;
                    if (v2 != null) {
                        v2.skip(entry, segmentIndex, new RoutingResolveResult.Failure(entry, "Better match was already found", HttpStatusCode.Companion.getNotFound()));
                    }
                    return Boxing.boxDouble((double)-1.7976931348623157E308);
                }
                result = new RoutingResolveResult.Success(entry, ((RouteSelectorEvaluation.Success)evaluation).getParameters(), ((RouteSelectorEvaluation.Success)evaluation).getQuality());
                newIndex = segmentIndex + ((RouteSelectorEvaluation.Success)evaluation).getSegmentIncrement();
                if (entry.getChildren().isEmpty() && newIndex != this.segments.size()) {
                    v3 = this.trace;
                    if (v3 != null) {
                        v3.skip(entry, newIndex, new RoutingResolveResult.Failure(entry, "Not all segments matched", HttpStatusCode.Companion.getNotFound()));
                    }
                    return Boxing.boxDouble((double)-1.7976931348623157E308);
                }
                v4 = this.trace;
                if (v4 != null) {
                    v4.begin(entry, newIndex);
                }
                trait.add(result);
                hasHandlers = ((Collection)entry.getHandlers$ktor_server_core()).isEmpty() == false ? 1 : 0;
                bestSucceedChildQuality = -1.7976931348623157E308;
                if (hasHandlers != 0 && newIndex == this.segments.size()) {
                    if (this.resolveResult.isEmpty() || this.isBetterResolve(trait)) {
                        bestSucceedChildQuality = ((RouteSelectorEvaluation.Success)evaluation).getQuality();
                        this.resolveResult.clear();
                        this.resolveResult.addAll(trait);
                        this.failedEvaluation = null;
                    }
                    v5 = this.trace;
                    if (v5 != null) {
                        v5.addCandidate(trait);
                    }
                }
                if ((childIndex = 0) > (var14_15 = CollectionsKt.getLastIndex(entry.getChildren()))) ** GOTO lbl106
lbl67:
                // 2 sources

                while (true) {
                    child = entry.getChildren().get(childIndex);
                    $continuation.L$0 = entry;
                    $continuation.L$1 = trait;
                    $continuation.L$2 = evaluation;
                    $continuation.L$3 = result;
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)child);
                    $continuation.I$0 = segmentIndex;
                    $continuation.D$0 = matchedQuality;
                    $continuation.I$1 = newIndex;
                    $continuation.I$2 = hasHandlers;
                    $continuation.D$1 = bestSucceedChildQuality;
                    $continuation.I$3 = childIndex;
                    $continuation.I$4 = var14_15;
                    $continuation.label = 2;
                    v6 = this.handleRoute(child, newIndex, trait, bestSucceedChildQuality, (Continuation<? super Double>)$continuation);
                    if (v6 == var20_8) {
                        return var20_8;
                    }
                    ** GOTO lbl101
                    break;
                }
            }
            case 2: {
                var14_15 = $continuation.I$4;
                childIndex = $continuation.I$3;
                bestSucceedChildQuality = $continuation.D$1;
                hasHandlers = $continuation.I$2;
                newIndex = $continuation.I$1;
                matchedQuality = $continuation.D$0;
                segmentIndex = $continuation.I$0;
                child = (RoutingNode)$continuation.L$4;
                result = (RoutingResolveResult.Success)$continuation.L$3;
                evaluation = (RouteSelectorEvaluation)$continuation.L$2;
                trait = (ArrayList)$continuation.L$1;
                entry = (RoutingNode)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
lbl101:
                // 2 sources

                if ((childQuality = ((Number)v6).doubleValue()) > 0.0) {
                    bestSucceedChildQuality = Math.max(bestSucceedChildQuality, childQuality);
                }
                if (childIndex != var14_15) {
                    ++childIndex;
                    ** continue;
                }
lbl106:
                // 3 sources

                CollectionsKt.removeLast((List)trait);
                v7 = this.trace;
                if (v7 != null) {
                    v7.finish(entry, newIndex, result);
                }
                return Boxing.boxDouble((double)(bestSucceedChildQuality > 0.0 ? ((RouteSelectorEvaluation.Success)evaluation).getQuality() : -1.7976931348623157E308));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final RoutingResolveResult findBestRoute() {
        ArrayList<RoutingResolveResult.Success> finalResolve = this.resolveResult;
        if (finalResolve.isEmpty()) {
            RouteSelectorEvaluation.Failure failure = this.failedEvaluation;
            if (failure == null || (failure = failure.getFailureStatusCode()) == null) {
                failure = HttpStatusCode.Companion.getNotFound();
            }
            return new RoutingResolveResult.Failure(this.routing, "No matched subtrees found", (HttpStatusCode)failure);
        }
        ParametersBuilder parameters = ParametersKt.ParametersBuilder$default((int)0, (int)1, null);
        double quality = Double.MAX_VALUE;
        int index = 0;
        int n = CollectionsKt.getLastIndex((List)finalResolve);
        if (index <= n) {
            while (true) {
                RoutingResolveResult.Success part;
                Intrinsics.checkNotNullExpressionValue((Object)finalResolve.get(index), (String)"get(...)");
                parameters.appendAll((StringValues)part.getParameters());
                double partQuality = part.getQuality$ktor_server_core() == -1.0 ? 1.0 : part.getQuality$ktor_server_core();
                quality = Math.min(quality, partQuality);
                if (index == n) break;
                ++index;
            }
        }
        return new RoutingResolveResult.Success(((RoutingResolveResult.Success)CollectionsKt.last((List)finalResolve)).getRoute(), parameters.build(), quality);
    }

    private final boolean isBetterResolve(List<RoutingResolveResult.Success> list2) {
        int n;
        int n2;
        int index1 = 0;
        int index2 = 0;
        ArrayList<RoutingResolveResult.Success> currentResolve = this.resolveResult;
        while (index1 < currentResolve.size() && index2 < list2.size()) {
            double quality1 = currentResolve.get(index1).getQuality$ktor_server_core();
            double quality2 = list2.get(index2).getQuality$ktor_server_core();
            if (quality1 == -1.0) {
                ++index1;
                continue;
            }
            if (quality2 == -1.0) {
                ++index2;
                continue;
            }
            if (!(quality1 == quality2)) {
                return quality2 > quality1;
            }
            ++index1;
            ++index2;
        }
        Iterable $this$count$iv = currentResolve;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n2 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                RoutingResolveResult.Success it = (RoutingResolveResult.Success)element$iv;
                boolean bl = false;
                if (!(!(it.getQuality$ktor_server_core() == -1.0)) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = count$iv;
        }
        int firstQuality = n2;
        Iterable $this$count$iv2 = list2;
        boolean $i$f$count2 = false;
        if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv2) {
                RoutingResolveResult.Success it = (RoutingResolveResult.Success)element$iv;
                boolean bl = false;
                if (!(!(it.getQuality$ktor_server_core() == -1.0)) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int secondQuality = n;
        return secondQuality > firstQuality;
    }

    private final void updateFailedEvaluation(RouteSelectorEvaluation.Failure failure, ArrayList<RoutingResolveResult.Success> trait) {
        RouteSelectorEvaluation.Failure failure2 = this.failedEvaluation;
        if (failure2 == null) {
            return;
        }
        RouteSelectorEvaluation.Failure current = failure2;
        if (current.getQuality() < failure.getQuality() || this.failedEvaluationDepth < trait.size()) {
            boolean bl;
            block6: {
                Iterable $this$all$iv = trait;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        RoutingResolveResult.Success it = (RoutingResolveResult.Success)element$iv;
                        boolean bl2 = false;
                        if (it.getQuality$ktor_server_core() == -1.0 || it.getQuality$ktor_server_core() == 1.0) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            if (bl) {
                this.failedEvaluation = failure;
                this.failedEvaluationDepth = trait.size();
            }
        }
    }

    public static final /* synthetic */ Object access$handleRoute(RoutingResolveContext $this, RoutingNode entry, int segmentIndex, ArrayList trait, double matchedQuality, Continuation $completion) {
        return $this.handleRoute(entry, segmentIndex, trait, matchedQuality, (Continuation<? super Double>)$completion);
    }
}

