/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.routing;

import io.ktor.http.HttpStatusCode;
import io.ktor.http.Parameters;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RouteSelectorEvaluation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean succeeded;
    @NotNull
    private static final Failure Failed = new Failure(0.0, HttpStatusCode.Companion.getNotFound());
    @NotNull
    private static final Failure FailedPath = new Failure(0.0, HttpStatusCode.Companion.getNotFound());
    @NotNull
    private static final Failure FailedMethod = new Failure(0.02, HttpStatusCode.Companion.getMethodNotAllowed());
    @NotNull
    private static final Failure FailedParameter = new Failure(0.01, HttpStatusCode.Companion.getBadRequest());
    @NotNull
    private static final Failure FailedAcceptHeader = new Failure(0.01, HttpStatusCode.Companion.getNotAcceptable());
    @NotNull
    private static final RouteSelectorEvaluation Missing = new Success(0.2, null, 0, 6, null);
    @NotNull
    private static final RouteSelectorEvaluation Constant = new Success(1.0, null, 0, 6, null);
    @NotNull
    private static final RouteSelectorEvaluation Transparent = new Success(-1.0, null, 0, 6, null);
    @NotNull
    private static final RouteSelectorEvaluation ConstantPath = new Success(1.0, null, 1, 2, null);
    @NotNull
    private static final RouteSelectorEvaluation WildcardPath = new Success(0.5, null, 1, 2, null);

    private RouteSelectorEvaluation(boolean succeeded) {
        this.succeeded = succeeded;
    }

    public /* synthetic */ RouteSelectorEvaluation(boolean succeeded, DefaultConstructorMarker $constructor_marker) {
        this(succeeded);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Failure getFailedPath() {
            return FailedPath;
        }

        @NotNull
        public final Failure getFailedMethod() {
            return FailedMethod;
        }

        @NotNull
        public final Failure getFailedParameter() {
            return FailedParameter;
        }

        @NotNull
        public final RouteSelectorEvaluation getMissing() {
            return Missing;
        }

        @NotNull
        public final RouteSelectorEvaluation getConstant() {
            return Constant;
        }

        @NotNull
        public final RouteSelectorEvaluation getTransparent() {
            return Transparent;
        }

        @NotNull
        public final RouteSelectorEvaluation getConstantPath() {
            return ConstantPath;
        }

        @NotNull
        public final RouteSelectorEvaluation getWildcardPath() {
            return WildcardPath;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static final class Failure
    extends RouteSelectorEvaluation {
        private final double quality;
        @NotNull
        private final HttpStatusCode failureStatusCode;

        public Failure(double quality, @NotNull HttpStatusCode failureStatusCode) {
            Intrinsics.checkNotNullParameter((Object)failureStatusCode, (String)"failureStatusCode");
            super(false, null);
            this.quality = quality;
            this.failureStatusCode = failureStatusCode;
        }

        public final double getQuality() {
            return this.quality;
        }

        @NotNull
        public final HttpStatusCode getFailureStatusCode() {
            return this.failureStatusCode;
        }

        @NotNull
        public String toString() {
            return "Failure(quality=" + this.quality + ", failureStatusCode=" + this.failureStatusCode + ')';
        }

        public int hashCode() {
            int result2 = Double.hashCode(this.quality);
            result2 = result2 * 31 + this.failureStatusCode.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Failure)) {
                return false;
            }
            Failure failure = (Failure)other;
            if (Double.compare(this.quality, failure.quality) != 0) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.failureStatusCode, (Object)failure.failureStatusCode);
        }
    }

    public static final class Success
    extends RouteSelectorEvaluation {
        private final double quality;
        @NotNull
        private final Parameters parameters;
        private final int segmentIncrement;

        public Success(double quality, @NotNull Parameters parameters, int segmentIncrement) {
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            super(true, null);
            this.quality = quality;
            this.parameters = parameters;
            this.segmentIncrement = segmentIncrement;
        }

        public /* synthetic */ Success(double d, Parameters parameters, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                parameters = Parameters.Companion.getEmpty();
            }
            if ((n2 & 4) != 0) {
                n = 0;
            }
            this(d, parameters, n);
        }

        public final double getQuality() {
            return this.quality;
        }

        @NotNull
        public final Parameters getParameters() {
            return this.parameters;
        }

        public final int getSegmentIncrement() {
            return this.segmentIncrement;
        }

        @NotNull
        public String toString() {
            return "Success(quality=" + this.quality + ", parameters=" + this.parameters + ", segmentIncrement=" + this.segmentIncrement + ')';
        }

        public int hashCode() {
            int result2 = Double.hashCode(this.quality);
            result2 = result2 * 31 + this.parameters.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.segmentIncrement);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Success)) {
                return false;
            }
            Success success2 = (Success)other;
            if (Double.compare(this.quality, success2.quality) != 0) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.parameters, (Object)success2.parameters)) {
                return false;
            }
            return this.segmentIncrement == success2.segmentIncrement;
        }
    }
}

