/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.routing;

import io.ktor.server.routing.RouteSelector;
import io.ktor.server.routing.RouteSelectorEvaluation;
import io.ktor.server.routing.RouteSelectorKt;
import io.ktor.server.routing.RoutingResolveContext;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PathSegmentParameterRouteSelector
extends RouteSelector {
    @NotNull
    private final String name;
    @Nullable
    private final String prefix;
    @Nullable
    private final String suffix;

    public PathSegmentParameterRouteSelector(@NotNull String name2, @Nullable String prefix, @Nullable String suffix) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this.name = name2;
        this.prefix = prefix;
        this.suffix = suffix;
    }

    @Override
    @Nullable
    public Object evaluate(@NotNull RoutingResolveContext context2, int segmentIndex, @NotNull Continuation<? super RouteSelectorEvaluation> $completion) {
        return RouteSelectorKt.evaluatePathSegmentParameter(context2.getSegments(), segmentIndex, this.name, this.prefix, this.suffix, false);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.prefix;
        if (string == null) {
            string = "";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string).append('{').append(this.name).append('}');
        String string2 = this.suffix;
        if (string2 == null) {
            string2 = "";
        }
        return stringBuilder2.append(string2).toString();
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + (this.prefix == null ? 0 : this.prefix.hashCode());
        result2 = result2 * 31 + (this.suffix == null ? 0 : this.suffix.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PathSegmentParameterRouteSelector)) {
            return false;
        }
        PathSegmentParameterRouteSelector pathSegmentParameterRouteSelector = (PathSegmentParameterRouteSelector)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)pathSegmentParameterRouteSelector.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.prefix, (Object)pathSegmentParameterRouteSelector.prefix)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.suffix, (Object)pathSegmentParameterRouteSelector.suffix);
    }
}

