/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.routing;

import io.ktor.http.HeaderValue;
import io.ktor.http.HttpHeaderValueParserKt;
import io.ktor.server.routing.RouteSelector;
import io.ktor.server.routing.RouteSelectorEvaluation;
import io.ktor.server.routing.RoutingResolveContext;
import java.util.List;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nRouteSelector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RouteSelector.kt\nio/ktor/server/routing/HttpHeaderRouteSelector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,782:1\n295#2,2:783\n*S KotlinDebug\n*F\n+ 1 RouteSelector.kt\nio/ktor/server/routing/HttpHeaderRouteSelector\n*L\n636#1:783,2\n*E\n"})
public final class HttpHeaderRouteSelector
extends RouteSelector {
    @NotNull
    private final String name;
    @NotNull
    private final String value;

    public HttpHeaderRouteSelector(@NotNull String name2, @NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.name = name2;
        this.value = value2;
    }

    @Override
    @Nullable
    public Object evaluate(@NotNull RoutingResolveContext context2, int segmentIndex, @NotNull Continuation<? super RouteSelectorEvaluation> $completion) {
        Object v0;
        block2: {
            String headers2 = context2.getCall().getRequest().getHeaders().get(this.name);
            List parsedHeaders = HttpHeaderValueParserKt.parseAndSortHeader((String)headers2);
            Iterable $this$firstOrNull$iv = parsedHeaders;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                HeaderValue it = (HeaderValue)element$iv;
                boolean bl = false;
                if (!StringsKt.equals((String)it.getValue(), (String)this.value, (boolean)true)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        HeaderValue headerValue = v0;
        if (headerValue == null) {
            return RouteSelectorEvaluation.Companion.getFailedParameter();
        }
        HeaderValue header = headerValue;
        return new RouteSelectorEvaluation.Success(header.getQuality(), null, 0, 6, null);
    }

    @NotNull
    public String toString() {
        return "(header:" + this.name + " = " + this.value + ')';
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + this.value.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HttpHeaderRouteSelector)) {
            return false;
        }
        HttpHeaderRouteSelector httpHeaderRouteSelector = (HttpHeaderRouteSelector)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)httpHeaderRouteSelector.name)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.value, (Object)httpHeaderRouteSelector.value);
    }
}

