/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.response;

import io.ktor.http.HttpHeaders;
import io.ktor.http.UnsafeHeaderException;
import java.util.List;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nResponseHeaders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResponseHeaders.kt\nio/ktor/server/response/ResponseHeaders\n+ 2 Headers.kt\nio/ktor/http/Headers$Companion\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n30#2:102\n1869#3,2:103\n*S KotlinDebug\n*F\n+ 1 ResponseHeaders.kt\nio/ktor/server/response/ResponseHeaders\n*L\n49#1:102\n50#1:103,2\n*E\n"})
public abstract class ResponseHeaders {
    @NotNull
    private final Set<String> managedByEngineHeaders = SetsKt.emptySet();

    @NotNull
    protected Set<String> getManagedByEngineHeaders() {
        return this.managedByEngineHeaders;
    }

    public final boolean contains(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return this.get(name2) != null;
    }

    @Nullable
    public String get(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return (String)CollectionsKt.firstOrNull(this.getEngineHeaderValues(name2));
    }

    public final void append(@NotNull String name2, @NotNull String value2, boolean safeOnly) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        if (this.getManagedByEngineHeaders().contains(name2)) {
            return;
        }
        if (safeOnly && HttpHeaders.INSTANCE.isUnsafe(name2)) {
            throw new UnsafeHeaderException(name2);
        }
        HttpHeaders.INSTANCE.checkHeaderName(name2);
        HttpHeaders.INSTANCE.checkHeaderValue(value2);
        this.engineAppendHeader(name2, value2);
    }

    public static /* synthetic */ void append$default(ResponseHeaders responseHeaders, String string, String string2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: append");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        responseHeaders.append(string, string2, bl);
    }

    protected abstract void engineAppendHeader(@NotNull String var1, @NotNull String var2);

    @NotNull
    protected abstract List<String> getEngineHeaderValues(@NotNull String var1);
}

