/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nOverridingClassLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OverridingClassLoader.kt\nio/ktor/server/engine/OverridingClassLoader\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,70:1\n37#2:71\n36#2,3:72\n*S KotlinDebug\n*F\n+ 1 OverridingClassLoader.kt\nio/ktor/server/engine/OverridingClassLoader\n*L\n18#1:71\n18#1:72,3\n*E\n"})
public final class OverridingClassLoader
extends ClassLoader
implements Closeable {
    @NotNull
    private final ChildURLClassLoader childClassLoader;

    public OverridingClassLoader(@NotNull List<URL> classpath, @Nullable ClassLoader parentClassLoader) {
        Intrinsics.checkNotNullParameter(classpath, (String)"classpath");
        super(parentClassLoader);
        Collection $this$toTypedArray$iv = classpath;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ClassLoader classLoader = this.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getParent(...)");
        this.childClassLoader = new ChildURLClassLoader(thisCollection$iv.toArray(new URL[0]), classLoader);
    }

    @Override
    @NotNull
    protected synchronized Class<?> loadClass(@NotNull String name2, boolean resolve2) {
        Class<?> clazz;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        try {
            clazz = this.childClassLoader.findClass(name2);
        }
        catch (ClassNotFoundException e) {
            Class<?> clazz2 = super.loadClass(name2, resolve2);
            Intrinsics.checkNotNull(clazz2);
            clazz = clazz2;
        }
        return clazz;
    }

    @Override
    public void close() {
        this.childClassLoader.close();
    }

    private static final class ChildURLClassLoader
    extends URLClassLoader {
        @NotNull
        private final ClassLoader realParent;

        public ChildURLClassLoader(@NotNull URL[] urls2, @NotNull ClassLoader realParent) {
            Intrinsics.checkNotNullParameter((Object)urls2, (String)"urls");
            Intrinsics.checkNotNullParameter((Object)realParent, (String)"realParent");
            super(urls2, (ClassLoader)null);
            this.realParent = realParent;
        }

        @Override
        @NotNull
        public Class<?> findClass(@NotNull String name2) {
            Class<?> clazz;
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Class<?> loaded = super.findLoadedClass(name2);
            if (loaded != null) {
                return loaded;
            }
            try {
                clazz = super.findClass(name2);
                Intrinsics.checkNotNull(clazz);
            }
            catch (ClassNotFoundException e) {
                Class<?> clazz2 = this.realParent.loadClass(name2);
                Intrinsics.checkNotNull(clazz2);
                clazz = clazz2;
            }
            return clazz;
        }

        @Override
        @NotNull
        public Enumeration<URL> getResources(@Nullable String name2) {
            Enumeration<URL> enumeration = this.realParent.getResources(name2);
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getResources(...)");
            return enumeration;
        }

        @Override
        @Nullable
        public URL getResource(@Nullable String name2) {
            return this.realParent.getResource(name2);
        }

        @Override
        @Nullable
        public InputStream getResourceAsStream(@Nullable String name2) {
            return this.realParent.getResourceAsStream(name2);
        }

        @Override
        @Nullable
        public URL findResource(@Nullable String name2) {
            return null;
        }

        @Override
        @NotNull
        public Enumeration<URL> findResources(@Nullable String name2) {
            Enumeration<URL> enumeration = Collections.emptyEnumeration();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"emptyEnumeration(...)");
            return enumeration;
        }
    }
}

