/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import io.ktor.http.Headers;
import io.ktor.http.HeadersBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nBaseApplicationRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseApplicationRequest.kt\nio/ktor/server/engine/DelegateHeaders\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n827#2:89\n855#2,2:90\n*S KotlinDebug\n*F\n+ 1 BaseApplicationRequest.kt\nio/ktor/server/engine/DelegateHeaders\n*L\n81#1:89\n81#1:90,2\n*E\n"})
final class DelegateHeaders
implements Headers {
    @NotNull
    private final Headers original;
    @NotNull
    private final HeadersBuilder overridden;
    @NotNull
    private final Set<String> removed;
    private final boolean caseInsensitiveName;

    public DelegateHeaders(@NotNull Headers original) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        this.original = original;
        this.overridden = new HeadersBuilder(0, 1, null);
        this.removed = new LinkedHashSet();
        this.caseInsensitiveName = this.original.getCaseInsensitiveName();
    }

    public boolean getCaseInsensitiveName() {
        return this.caseInsensitiveName;
    }

    @Nullable
    public List<String> getAll(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (this.removed.contains(name2)) {
            return null;
        }
        if (this.overridden.contains(name2)) {
            return this.overridden.getAll(name2);
        }
        return this.original.getAll(name2);
    }

    @NotNull
    public Set<String> names() {
        return SetsKt.minus((Set)SetsKt.plus((Set)this.original.names(), (Iterable)this.overridden.names()), (Iterable)this.removed);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<Map.Entry<String, List<String>>> entries() {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = SetsKt.plus((Set)this.original.entries(), (Iterable)this.overridden.build().entries());
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (this.removed.contains(it.getKey())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public boolean isEmpty() {
        return this.names().isEmpty();
    }

    @Nullable
    public String get(@NotNull String name2) {
        return super.get(name2);
    }

    public boolean contains(@NotNull String name2) {
        return super.contains(name2);
    }

    public boolean contains(@NotNull String name2, @NotNull String value2) {
        return super.contains(name2, value2);
    }

    public void forEach(@NotNull Function2<? super String, ? super List<String>, Unit> body) {
        super.forEach(body);
    }
}

