/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.auth;

import io.ktor.server.application.ApplicationCall;
import io.ktor.server.auth.AuthenticationFailedCause;
import io.ktor.server.auth.AuthenticationProcedureChallenge;
import io.ktor.server.auth.CombinedPrincipal;
import io.ktor.util.AttributeKey;
import io.ktor.util.reflect.TypeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SourceDebugExtension(value={"SMAP\nAuthenticationContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthenticationContext.kt\nio/ktor/server/auth/AuthenticationContext\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Attributes.kt\nio/ktor/util/AttributesKt\n+ 4 Type.kt\nio/ktor/util/reflect/TypeKt\n*L\n1#1,138:1\n808#2,11:139\n21#3:150\n69#4:151\n84#4,8:152\n*S KotlinDebug\n*F\n+ 1 AuthenticationContext.kt\nio/ktor/server/auth/AuthenticationContext\n*L\n47#1:139,11\n124#1:150\n124#1:151\n124#1:152,8\n*E\n"})
public final class AuthenticationContext {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private ApplicationCall call;
    @NotNull
    private final HashMap<Object, AuthenticationFailedCause> errors;
    @NotNull
    private final CombinedPrincipal _principal;
    @NotNull
    private final AuthenticationProcedureChallenge challenge;
    @NotNull
    private static final AttributeKey<AuthenticationContext> AttributeKey;

    public AuthenticationContext(@NotNull ApplicationCall call2) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        this.call = call2;
        this.errors = new HashMap();
        this._principal = new CombinedPrincipal();
        this.challenge = new AuthenticationProcedureChallenge();
    }

    @NotNull
    public final ApplicationCall getCall() {
        return this.call;
    }

    @NotNull
    public final CombinedPrincipal get_principal$ktor_server_auth() {
        return this._principal;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AuthenticationFailedCause.Error> getAllErrors() {
        void $this$filterIsInstanceTo$iv$iv;
        Collection<AuthenticationFailedCause> collection = this.errors.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$filterIsInstance$iv = collection;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof AuthenticationFailedCause.Error)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<AuthenticationFailedCause> getAllFailures() {
        Collection<AuthenticationFailedCause> collection = this.errors.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return CollectionsKt.toList((Iterable)collection);
    }

    public final void error(@NotNull Object key, @NotNull AuthenticationFailedCause cause) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        ((Map)this.errors).put(key, cause);
    }

    @NotNull
    public final AuthenticationProcedureChallenge getChallenge() {
        return this.challenge;
    }

    public final void principal(@NotNull Object principal2) {
        Intrinsics.checkNotNullParameter((Object)principal2, (String)"principal");
        this._principal.add(null, principal2);
    }

    @Nullable
    public final <T> T principal(@Nullable String provider2, @NotNull KClass<T> klass) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        return this._principal.get(provider2, klass);
    }

    public final void challenge(@NotNull Object key, @NotNull AuthenticationFailedCause cause, @NotNull Function3<? super AuthenticationProcedureChallenge, ? super ApplicationCall, ? super Continuation<? super Unit>, ? extends Object> function) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Intrinsics.checkNotNullParameter(function, (String)"function");
        this.error(key, cause);
        this.challenge.getRegister$ktor_server_auth().add((Pair<AuthenticationFailedCause, Function3<AuthenticationProcedureChallenge, ApplicationCall, Continuation<? super Unit>, Object>>)TuplesKt.to((Object)cause, function));
    }

    static {
        KType kType;
        Companion = new Companion(null);
        String name$iv = "AuthContext";
        boolean $i$f$AttributeKey = false;
        String string = name$iv;
        boolean $i$f$typeInfo = false;
        KClass kClass = Reflection.getOrCreateKotlinClass(AuthenticationContext.class);
        boolean $i$f$typeOfOrNull = false;
        try {
            kType = Reflection.typeOf(AuthenticationContext.class);
        }
        catch (Throwable throwable) {
            kType = null;
        }
        KType kType2 = kType;
        KClass kClass2 = kClass;
        TypeInfo typeInfo = new TypeInfo(kClass2, kType2);
        String string2 = string;
        AttributeKey = new AttributeKey(string2, typeInfo);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AuthenticationContext from$ktor_server_auth(@NotNull ApplicationCall call2) {
            Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
            AuthenticationContext existingContext = (AuthenticationContext)call2.getAttributes().getOrNull(AttributeKey);
            if (existingContext != null) {
                existingContext.call = call2;
                return existingContext;
            }
            AuthenticationContext context2 = new AuthenticationContext(call2);
            call2.getAttributes().put(AttributeKey, (Object)context2);
            return context2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

