/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.auth;

import io.ktor.server.auth.AuthenticationProvider;
import io.ktor.utils.io.KtorDsl;
import java.util.Map;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@KtorDsl
public final class AuthenticationConfig {
    @NotNull
    private final Map<String, AuthenticationProvider> providers;

    public AuthenticationConfig(@NotNull Map<String, ? extends AuthenticationProvider> providers) {
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        this.providers = MapsKt.toMutableMap(providers);
    }

    public /* synthetic */ AuthenticationConfig(Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map2 = MapsKt.emptyMap();
        }
        this(map2);
    }

    @NotNull
    public final Map<String, AuthenticationProvider> getProviders$ktor_server_auth() {
        return this.providers;
    }

    public final void register(@NotNull AuthenticationProvider provider2) {
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        this.requireProviderNotRegistered(provider2.getName());
        this.providers.put(provider2.getName(), provider2);
    }

    private final void requireProviderNotRegistered(String providerName) {
        if (this.providers.containsKey(providerName)) {
            throw new IllegalArgumentException("Provider with the name " + providerName + " is already registered");
        }
    }

    public AuthenticationConfig() {
        this(null, 1, null);
    }
}

