/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.application;

import io.ktor.server.application.ApplicationEnvironment;
import io.ktor.server.application.ApplicationStartupMode;
import io.ktor.server.config.ApplicationConfigValue;
import java.util.List;
import java.util.Locale;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

public final class ApplicationModulesKt {
    @NotNull
    public static final List<String> getModuleConfigReferences(@NotNull ApplicationEnvironment $this$moduleConfigReferences) {
        Intrinsics.checkNotNullParameter((Object)$this$moduleConfigReferences, (String)"<this>");
        ApplicationConfigValue applicationConfigValue = $this$moduleConfigReferences.getConfig().propertyOrNull("ktor.application.modules");
        List list2 = applicationConfigValue != null ? applicationConfigValue.getList() : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @NotNull
    public static final ApplicationStartupMode getStartupMode(@NotNull ApplicationEnvironment $this$startupMode) {
        ApplicationStartupMode applicationStartupMode;
        String text2;
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$startupMode, (String)"<this>");
        Object object = $this$startupMode.getConfig().propertyOrNull("ktor.application.startup");
        if (object != null && (object = object.getString()) != null) {
            String string2 = ((String)object).toLowerCase(Locale.ROOT);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        } else {
            string = text2 = null;
        }
        if (Intrinsics.areEqual((Object)text2, (Object)"concurrent")) {
            applicationStartupMode = ApplicationStartupMode.CONCURRENT;
        } else if (Intrinsics.areEqual((Object)text2, (Object)"sequential") || text2 == null) {
            applicationStartupMode = ApplicationStartupMode.SEQUENTIAL;
        } else {
            throw new IllegalStateException(("Invalid startup mode: " + text2).toString());
        }
        return applicationStartupMode;
    }

    public static final long getStartupTimeout(@NotNull ApplicationEnvironment $this$startupTimeout) {
        long l;
        Intrinsics.checkNotNullParameter((Object)$this$startupTimeout, (String)"<this>");
        Object object = $this$startupTimeout.getConfig().propertyOrNull("ktor.application.startupTimeoutMillis");
        if (object != null && (object = object.getString()) != null) {
            long l2 = Long.parseLong((String)object);
            l = DurationKt.toDuration((long)l2, (DurationUnit)DurationUnit.MILLISECONDS);
        } else {
            l = DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS);
        }
        return l;
    }
}

